/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.macro.input;

import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42DataHelper;
import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.confluence.macro.input.AbstractInput;
import org.apache.commons.lang.StringUtils;

public class ObjectInput
extends AbstractInput {
    private static final String NAME_PARAMETER_KEY = "view_device_v1_name";
    private String d42Value;
    private String objectType;
    private String objectId;
    private String objectName;

    public ObjectInput(String objectType, String objectId, String objectName, long firstLevelId) {
        super(firstLevelId, 0L);
        this.objectType = objectType;
        this.objectId = objectId;
        this.objectName = objectName;
    }

    public ObjectInput(String d42Value, long firstLevelId) {
        super(firstLevelId, 0L);
        this.d42Value = d42Value;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getD42Value() {
        return this.d42Value;
    }

    public D42DataHelper getHelper(long firstLevelId, long secondLevelId, D42DataManager d42DataManager, D42SettingsManager d42SettingsManager, I18nResolver i18n) throws D42Exception {
        D42DataHelper.D42DataHelperBuilder dataHelperBuilder = D42DataHelper.create((D42DataManager)d42DataManager, (D42SettingsManager)d42SettingsManager, (I18nResolver)i18n).filterInfo(Long.valueOf(firstLevelId), Long.valueOf(secondLevelId));
        if (StringUtils.isNotBlank((String)this.d42Value)) {
            dataHelperBuilder.value(this.d42Value);
        } else if (StringUtils.isNotBlank((String)this.objectType)) {
            ConfigurationItem configurationItem;
            ParameterType parameterType;
            ConfigurationItemType type = d42DataManager.getConfigurationItemTypeByName(this.objectType);
            if (StringUtils.isNotBlank((String)this.objectId)) {
                dataHelperBuilder.value(type, this.objectId);
            } else if (StringUtils.isNotBlank((String)this.objectName) && type != null && (parameterType = type.getParameterTypeByKey(NAME_PARAMETER_KEY)) != null && (configurationItem = d42DataManager.getOneByParameter(this.objectName, parameterType, type)) != null) {
                dataHelperBuilder.value(type, Long.toString(configurationItem.getStorageId()));
            }
        }
        return dataHelperBuilder.build();
    }

    public String toString() {
        return "ObjectInput [objectType=" + this.objectType + ", objectId=" + this.objectId + ", objectName=" + this.objectName + "]";
    }
}

