/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.manager;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42DataUpdaterMonitor;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.confluence.job.D42ConfluenceUpdateDataTask;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class D42ConfluenceDataUpdaterMonitorImpl
implements D42DataUpdaterMonitor,
LifecycleAware {
    private static final Logger.Log log = Logger.getInstance(D42ConfluenceDataUpdaterMonitorImpl.class);
    private final D42SettingsManager d42SettingsManager;
    private final D42JobStatisticsManager jobStatisticsManager;
    private final D42DataManager d42DataManager;
    private final SchedulerService schedulerService;
    private final TransactionTemplate transactionTemplate;
    public static final String RUN_ONCE_JOB_KEY = "d42RunOnceJob";

    public D42ConfluenceDataUpdaterMonitorImpl(D42SettingsManager d42SettingsManager, D42JobStatisticsManager jobStatisticsManager, D42DataManager d42DataManager, SchedulerService schedulerService, TransactionTemplate transactionTemplate) {
        this.d42SettingsManager = d42SettingsManager;
        this.schedulerService = schedulerService;
        this.d42DataManager = d42DataManager;
        this.transactionTemplate = transactionTemplate;
        this.jobStatisticsManager = jobStatisticsManager;
    }

    private JobConfig createJobConfig(String key, String cron) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)key)).withParameters(this.createTaskParameters(false, false)).withSchedule(Schedule.forCronExpression((String)cron));
    }

    private Map<String, Serializable> createTaskParameters(boolean forceStart, boolean fullRescan) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (forceStart) {
            result.put("forceStart", Boolean.valueOf(forceStart));
        }
        if (fullRescan) {
            result.put("fullRescan", Boolean.valueOf(fullRescan));
        }
        return result;
    }

    public Date getNextFireDate() throws D42Exception {
        Date nextFireDate = null;
        try {
            JobDetails jobDetails = this.schedulerService.getJobDetails(JobId.of((String)"d42defaultjob"));
            if (jobDetails != null && jobDetails.getNextRunTime() != null) {
                nextFireDate = jobDetails.getNextRunTime();
            }
        }
        catch (Exception e) {
            log.error((Object)"getNextFireDate error ", (Throwable)e);
            throw new D42Exception("getNextFireDate error", (Throwable)e);
        }
        return nextFireDate;
    }

    public boolean validateCronExpression(String cron) {
        try {
            Schedule.forCronExpression((String)cron);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Invalid cron expression '" + cron + "': " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String getCronValidationError(String cron) {
        try {
            Schedule.forCronExpression((String)cron);
            return null;
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg != null && errorMsg.contains("cron")) {
                return errorMsg;
            }
            return "Invalid cron expression format. Expected format: <seconds> <minutes> <hours> <day-of-month> <month> <day-of-week>";
        }
    }

    private void registerJob(String key) {
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)key), (JobRunner)new D42ConfluenceUpdateDataTask(this.d42SettingsManager, this.d42DataManager, this.transactionTemplate, this.jobStatisticsManager, this));
    }

    private void registerTemporary(boolean forceStart, boolean fullRescan) throws SchedulerServiceException {
        this.schedulerService.unscheduleJob(JobId.of((String)RUN_ONCE_JOB_KEY));
        this.jobStatisticsManager.setPendingManually(true);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)RUN_ONCE_JOB_KEY)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(this.createTaskParameters(forceStart, fullRescan)).withSchedule(Schedule.runOnce(null));
        this.schedulerService.scheduleJob(JobId.of((String)RUN_ONCE_JOB_KEY), jobConfig);
    }

    public void unregisterTemporary() {
        this.schedulerService.unscheduleJob(JobId.of((String)RUN_ONCE_JOB_KEY));
    }

    public void onStart() {
        try {
            this.registerJob("d42defaultjob");
            this.registerJob(RUN_ONCE_JOB_KEY);
            this.reSchedule();
        }
        catch (D42Exception e) {
            log.error((Object)"Exception on schedule on start", (Throwable)e);
            throw new RuntimeException("Could not start the schedule", e);
        }
    }

    public void onStop() {
        log.debug((Object)"D42ConfluenceDataUpdaterMonitorImpl::onStop");
        this.stopConnectionMonitor();
    }

    private void stopConnectionMonitor() {
        log.debug((Object)"Stopping D42 Confluence connection monitor");
        try {
            if (this.schedulerService != null) {
                this.schedulerService.unscheduleJob(JobId.of((String)"d42defaultjob"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error stopping connection monitor", (Throwable)e);
        }
    }

    public void reSchedule() throws D42Exception {
        String cron = this.d42SettingsManager.getCron();
        try {
            this.schedulerService.unscheduleJob(JobId.of((String)"d42defaultjob"));
            if (StringUtils.isBlank((String)cron)) {
                return;
            }
            JobConfig jobConfig = this.createJobConfig("d42defaultjob", cron);
            this.schedulerService.scheduleJob(JobId.of((String)"d42defaultjob"), jobConfig);
        }
        catch (Exception e) {
            log.error((Object)("Failed to reschedule job with cron expression '" + cron + "'"), (Throwable)e);
            throw new D42Exception("Failed to schedule automatic data updates. Please check the cron expression format.", (Throwable)e);
        }
    }

    public boolean runOnce(boolean forceRun, boolean fullRescan) throws D42Exception {
        try {
            this.registerTemporary(forceRun, fullRescan);
            return true;
        }
        catch (SchedulerServiceException e) {
            log.error((Object)"runOnce error ", (Throwable)e);
            return false;
        }
    }

    public boolean abortCurrentJob() {
        if (this.jobStatisticsManager.isPendingManually()) {
            log.error((Object)"Pending job abort");
            this.unregisterTemporary();
            this.jobStatisticsManager.setPendingManually(false);
            return true;
        }
        log.error((Object)"Aborting execution");
        return this.jobStatisticsManager.abortCurrentJob();
    }
}

