/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.macro;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42DataHelper;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.confluence.macro.D42Macro;
import com.device42.atlas.confluence.macro.input.TableInput;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class D42TableMacro
extends D42Macro<TableInput> {
    private static final String DEFAULT_OBJECT = "Device";
    private static final List<String> ALLOWED_FILTERS = Arrays.asList("type", "service_level", "in_service", "rack", "room", "building");

    public D42TableMacro(D42SettingsManager d42SettingsManager, D42DataManager d42DataManager, SpaceManager spaceManager, I18nResolver i18n, PluginSettingsFactory pluginSettingsFactory) {
        super(d42SettingsManager, d42DataManager, spaceManager, i18n, pluginSettingsFactory);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    @Override
    protected String getTemplatePath() {
        return "/com/device42/atlas/confluence/templates/macro/table.vm";
    }

    @Override
    protected TableInput parseParameters(Map<String, String> parameters, long firstLevelId) {
        String secondLevelIdString = parameters.get("d42SecondLevelId");
        String d42Type = parameters.get("d42Type");
        if (StringUtils.isNotBlank((CharSequence)secondLevelIdString) && StringUtils.isNotBlank((CharSequence)d42Type)) {
            long secondLevelId = 0L;
            try {
                secondLevelId = Long.parseLong(secondLevelIdString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new TableInput(d42Type, firstLevelId, secondLevelId);
        }
        String objectType = parameters.get("objectType");
        String filterParam1 = parameters.get("filterParam1");
        String filterParamValue1 = parameters.get("filterParamValue1");
        String filterParam2 = parameters.get("filterParam2");
        String filterParamValue2 = parameters.get("filterParamValue2");
        if ((StringUtils.isNotBlank((CharSequence)filterParam1) || StringUtils.isNotBlank((CharSequence)filterParam2)) && StringUtils.isNotBlank((CharSequence)objectType) && !objectType.equals(DEFAULT_OBJECT)) {
            throw new IllegalArgumentException("Search supported for Devices only!");
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam1) && !ALLOWED_FILTERS.contains(filterParam1)) {
            throw new IllegalArgumentException("Filter 1 can contain only: " + StringUtils.join(ALLOWED_FILTERS, (String)",") + ".");
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam2) && !ALLOWED_FILTERS.contains(filterParam2)) {
            throw new IllegalArgumentException("Filter 2 can contain only: " + StringUtils.join(ALLOWED_FILTERS, (String)",") + ".");
        }
        return new TableInput(StringUtils.isBlank((CharSequence)objectType) ? DEFAULT_OBJECT : objectType, filterParam1, filterParamValue1, filterParam2, filterParamValue2, firstLevelId);
    }

    @Override
    protected void renderBody(TableInput input, Map<String, Object> velocityContext) throws D42Exception {
        D42DataHelper.D42DataHelperBuilder dataHelperBuilder = D42DataHelper.create((D42DataManager)this.d42DataManager, (D42SettingsManager)this.d42SettingsManager, (I18nResolver)this.i18n).filterInfo(Long.valueOf(input.getFirstLevelId()), Long.valueOf(input.getSecondLevelId()));
        ConfigurationItemType type = null;
        try {
            type = StringUtils.isNotBlank((CharSequence)input.getD42Type()) ? this.d42DataManager.getConfigurationItemTypeByKey(input.getD42Type()) : this.d42DataManager.getConfigurationItemTypeByName(input.getObjectType());
        }
        catch (Exception e) {
            throw new D42Exception("This type is currently unavailable");
        }
        if (type == null) {
            throw new D42Exception("This type is currently unavailable");
        }
        dataHelperBuilder.value(type);
        D42DataHelper dataHelper = dataHelperBuilder.build();
        velocityContext.put("helper", dataHelper);
    }
}

