/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.manager;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class D42ConfluenceRestrictFilter
implements Filter {
    public static final String D42_USER_NAME = "D42UserName";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SpaceManager spaceManager;

    public D42ConfluenceRestrictFilter(PluginSettingsFactory pluginSettingsFactory, SpaceManager spaceManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.spaceManager = spaceManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        try {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (confluenceUser != null) {
                servletRequest.setAttribute(D42_USER_NAME, (Object)confluenceUser.getKey());
            }
            URL url = new URL(((HttpServletRequest)servletRequest).getHeader("referer"));
            String[] params = url.getQuery().split("&");
            int pageId = 0;
            String spaceKey = null;
            for (String str : params) {
                if (str.contains("spaceKey")) {
                    spaceKey = str.split("=")[1];
                    break;
                }
                if (!str.contains("pageId") && !str.contains("draftId")) continue;
                pageId = Integer.parseInt(str.split("=")[1]);
                spaceKey = this.spaceManager.getSpaceFromPageId((long)pageId);
                break;
            }
            String allowed = (String)pluginSettings.get("d42_restrict_spaces");
            String enable = (String)pluginSettings.get("d42_restrict_spaces_enable");
            if (allowed != null && enable != null && (spaceKey == null || enable.equals("on") && !Arrays.asList(allowed.split(",")).contains(spaceKey))) {
                ((HttpServletResponse)servletResponse).sendError(403);
                return;
            }
        }
        catch (Exception e) {
            ((HttpServletResponse)servletResponse).sendError(403);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

