/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import com.atlassian.extras.common.log.Logger;
import javax.annotation.Nonnull;

public class MutliLineStringTokenizer {
    private static final Logger.Log log = Logger.getInstance(MutliLineStringTokenizer.class);
    private StringBuilder storedString;
    private int currentIndex;
    private boolean newLineSignificant = false;
    private boolean returnSeparators = false;
    private boolean returnSpaces = false;
    private boolean includeQuotesInToken = true;
    private String spaceSeparators = " \t";
    private String quoteCharacters = "'\"";
    private String tokenSeparators = "";
    QuoteEscapeType quoteEscapeType = QuoteEscapeType.DOUBLE;
    private String currentToken;
    private TokenType currentTokenType;

    public MutliLineStringTokenizer(String tokenString) {
        this.storedString = new StringBuilder(tokenString);
        this.currentIndex = 0;
    }

    public TokenType nextToken() {
        boolean tokenCollected = false;
        do {
            TokenType tokenType;
            if ((tokenType = this.nextAllToken()) == TokenType.EOL && !this.newLineSignificant || tokenType == TokenType.SPACE && !this.returnSpaces || tokenType == TokenType.SEPARATOR && !this.returnSeparators) continue;
            tokenCollected = true;
        } while (!tokenCollected);
        return this.currentTokenType;
    }

    private char readNextChar() {
        if (this.storedString.length() <= this.currentIndex) {
            ++this.currentIndex;
            return '\u0000';
        }
        return this.storedString.charAt(this.currentIndex++);
    }

    private void indexBack() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
        }
    }

    private void gatherSequenceToken(@Nonnull TokenType tokenType, @Nonnull StringBuilder token) {
        boolean sequenceFinished = false;
        do {
            char nextChar;
            if (this.getStartTokenType(nextChar = this.readNextChar()) == tokenType) {
                token.append(nextChar);
                continue;
            }
            this.indexBack();
            sequenceFinished = true;
        } while (!sequenceFinished);
    }

    private TokenType getStartTokenType(char tokenStart) {
        if (tokenStart == '\u0000') {
            return TokenType.EOF;
        }
        if (tokenStart == '\r' || tokenStart == '\n') {
            return TokenType.EOL;
        }
        if (this.spaceSeparators != null && this.spaceSeparators.indexOf(tokenStart) >= 0) {
            return TokenType.SPACE;
        }
        if (this.tokenSeparators != null && this.tokenSeparators.indexOf(tokenStart) >= 0) {
            return TokenType.SEPARATOR;
        }
        if (this.quoteCharacters != null && this.quoteCharacters.indexOf(tokenStart) >= 0) {
            return TokenType.QUOTE;
        }
        return TokenType.STRING;
    }

    private void gatherQuote(char tokenStart, StringBuilder token) {
        boolean quoteCollected = false;
        char prevChar = '\u0000';
        char nextChar = '\u0000';
        do {
            prevChar = nextChar;
            nextChar = this.readNextChar();
            if (this.getStartTokenType(nextChar) == TokenType.EOF) break;
            if (nextChar == tokenStart) {
                if (this.quoteEscapeType == QuoteEscapeType.BACKSLASH && prevChar != '\\') {
                    quoteCollected = true;
                }
                if (this.quoteEscapeType == QuoteEscapeType.DOUBLE) {
                    char checkEscape = this.readNextChar();
                    if (checkEscape != tokenStart) {
                        quoteCollected = true;
                        this.indexBack();
                    } else {
                        token.append(checkEscape);
                    }
                }
                if (quoteCollected) continue;
                token.append(nextChar);
                continue;
            }
            token.append(nextChar);
        } while (!quoteCollected);
    }

    private TokenType nextAllToken() {
        StringBuilder token = new StringBuilder();
        char tokenStart = this.readNextChar();
        this.currentTokenType = this.getStartTokenType(tokenStart);
        switch (this.currentTokenType) {
            case EOF: {
                this.currentToken = null;
                break;
            }
            case EOL: {
                token.append(tokenStart);
                if (tokenStart == '\r') {
                    char checkDoubleEndLine = this.readNextChar();
                    if (checkDoubleEndLine == '\n') {
                        token.append(checkDoubleEndLine);
                    } else {
                        this.indexBack();
                    }
                }
                this.currentToken = token.toString();
                break;
            }
            case SPACE: 
            case STRING: {
                token.append(tokenStart);
                this.gatherSequenceToken(this.currentTokenType, token);
                this.currentToken = token.toString();
                break;
            }
            case SEPARATOR: {
                token.append(tokenStart);
                this.currentToken = token.toString();
                break;
            }
            case QUOTE: {
                if (this.includeQuotesInToken) {
                    token.append(tokenStart);
                }
                this.gatherQuote(tokenStart, token);
                if (this.includeQuotesInToken) {
                    token.append(tokenStart);
                }
                this.currentToken = token.toString();
            }
        }
        return this.currentTokenType;
    }

    public boolean isNewLineSignificant() {
        return this.newLineSignificant;
    }

    public void setNewLineSignificant(boolean newLineSignificant) {
        this.newLineSignificant = newLineSignificant;
    }

    public boolean isReturnSeparators() {
        return this.returnSeparators;
    }

    public void setReturnSeparators(boolean returnSeparators) {
        this.returnSeparators = returnSeparators;
    }

    public boolean isReturnSpaces() {
        return this.returnSpaces;
    }

    public void setReturnSpaces(boolean returnSpaces) {
        this.returnSpaces = returnSpaces;
    }

    public String getSpaceSeparators() {
        return this.spaceSeparators;
    }

    public void setSpaceSeparators(String spaceSeparators) {
        this.spaceSeparators = spaceSeparators;
    }

    public String getQuoteCharacters() {
        return this.quoteCharacters;
    }

    public void setQuoteCharacters(String quoteCharacters) {
        this.quoteCharacters = quoteCharacters;
    }

    public String getTokenSeparators() {
        return this.tokenSeparators;
    }

    public void setTokenSeparators(String tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
    }

    public QuoteEscapeType getQuoteEscapeType() {
        return this.quoteEscapeType;
    }

    public void setQuoteEscapeType(QuoteEscapeType quoteEscapeType) {
        this.quoteEscapeType = quoteEscapeType;
    }

    public boolean isIncludeQuotesInToken() {
        return this.includeQuotesInToken;
    }

    public void setIncludeQuotesInToken(boolean includeQuotesInToken) {
        this.includeQuotesInToken = includeQuotesInToken;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public TokenType getCurrentTokenType() {
        return this.currentTokenType;
    }

    public static enum QuoteEscapeType {
        BACKSLASH,
        DOUBLE;

    }

    public static enum TokenType {
        STRING,
        QUOTE,
        SEPARATOR,
        SPACE,
        EOL,
        EOF;

    }
}

