/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.MapParameters;
import com.device42.atlas.common.model.serialization.NestingErrorHolderHelper;
import com.device42.atlas.common.model.serialization.Parameterizable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VelocityParameters
extends MapParameters
implements ErrorHolder {
    public static final String TOKEN_NESTED_ERRORS = "nestedErrors";
    private List<String> errorMessages;
    private Map<String, String> errors;
    private Map<String, Object> nestedErrors;
    private NestingErrorHolderHelper<VelocityParameters> nestingHelper = new NestingErrorHolderHelper();

    public VelocityParameters() {
    }

    public VelocityParameters(Map<String, Object> map) {
        super(map);
    }

    public VelocityParameters(Parameterizable paramObject) {
        super(paramObject);
    }

    @Override
    public synchronized void addErrorMessage(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(message);
        this.setError();
    }

    @Override
    public synchronized void addError(String field, String message) {
        if (this.errors == null) {
            this.errors = new HashMap<String, String>();
        }
        this.errors.put(field, message);
        this.setError();
    }

    @Override
    public void addParameter(String key, Object value) {
        if (!("errors".equals(key) || "errorMessages".equals(key) || "result".equals(key) || value == null)) {
            super.addParameter(key, value);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        Map<String, Object> resultParameters = super.getParameters();
        if (this.errors != null) {
            resultParameters.put("errors", this.errors);
        }
        if (this.errorMessages != null) {
            resultParameters.put("errorMessages", this.errorMessages);
        }
        if (this.nestedErrors != null) {
            resultParameters.put(TOKEN_NESTED_ERRORS, this.nestedErrors);
        }
        return resultParameters;
    }

    @Override
    public boolean hasErrors() {
        return this.errors != null || this.errorMessages != null;
    }

    @Override
    public void setError() {
        this.params.put("result", "error");
        this.nestingHelper.setError();
    }

    @Override
    public void storeNestedErrors() {
        if (this.nestedErrors == null) {
            this.nestedErrors = new LinkedHashMap<String, Object>();
        }
        Map<String, VelocityParameters> failedHolders = this.nestingHelper.extractFailedHolders();
        for (String key : failedHolders.keySet()) {
            VelocityParameters failedHolder = failedHolders.get(key);
            LinkedHashMap<String, Object> nestedHelperErrors = new LinkedHashMap<String, Object>();
            this.nestedErrors.put(key, nestedHelperErrors);
            nestedHelperErrors.put("errors", failedHolder.errors);
            nestedHelperErrors.put("errorMessages", failedHolder.errorMessages);
            nestedHelperErrors.put(TOKEN_NESTED_ERRORS, failedHolder.nestedErrors);
            this.nestedErrors.put(key, nestedHelperErrors);
        }
        if (failedHolders.size() > 0) {
            this.setError();
        }
    }

    @Override
    public ErrorHolder getNestedErrorHolder(String field) {
        VelocityParameters nestedHolder = new VelocityParameters();
        this.nestingHelper.addNestedHolder(field, nestedHolder);
        nestedHolder.nestingHelper.setParentHolder(this);
        return nestedHolder;
    }

    @Override
    public void setSuccess() {
        this.params.put("result", "ok");
    }
}

