/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.JsonUtil;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MapDonor
implements ParameterDonor {
    private final Map<String, ? extends Object> parameters;

    public MapDonor(@Nonnull Map<String, ? extends Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object get(String key) {
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        if (this.parameters != null) {
            return this.parameters.containsKey(key);
        }
        return false;
    }

    @Override
    public Set<String> keys() {
        if (this.parameters != null) {
            return this.parameters.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public ParameterDonor extractNestedObject(String key) {
        if (this.parameters != null && this.parameters.containsKey(key)) {
            Object nestedObject = this.parameters.get(key);
            if (nestedObject instanceof Map) {
                return new MapDonor(ObjectUtils.convertMapToStringMap((Map)nestedObject));
            }
            if (nestedObject instanceof String) {
                return JsonUtil.jsonStringToMapDonor((String)nestedObject);
            }
        }
        return null;
    }
}

