/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.regex.Matcher;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;

public class ReferenceParameterType
extends ParameterType {
    private static final Logger.Log log = Logger.getInstance(ReferenceParameterType.class);
    public static final String PLACE_HOLDER_SIGN = "~";
    public static final String ID_PLACE_HOLDER = "~id~";
    public static final String TOKEN_CONFIGURATION_ITEM_KEY = "configurationItemKey";
    public static final String TOKEN_ID_INDEX = "idIndex";
    public static final String TOKEN_CSV_FORMAT = "csvFormat";
    private String configurationItemKey;
    private int idIndex;
    private String idIndexRaw;
    private String csvFormat;

    public ReferenceParameterType() {
        super(ParameterType.ParameterValueType.REFERENCE);
    }

    public String getConfigurationItemKey() {
        return this.configurationItemKey;
    }

    public void setConfigurationItemKey(String configurationItemKey) {
        this.configurationItemKey = configurationItemKey;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public void setIdIndex(int idIndex) {
        this.idIndex = idIndex;
    }

    public String getCsvFormat() {
        return this.csvFormat;
    }

    public void setNameFormat(String csvFormat) {
        this.csvFormat = csvFormat;
    }

    public String renderCsvRow(CSVRecord csvRow) {
        if (this.csvFormat != null) {
            String result = this.csvFormat;
            for (int i = 0; i < csvRow.size(); ++i) {
                String replacementValue = csvRow.get(i);
                replacementValue = replacementValue == null ? "" : Matcher.quoteReplacement(replacementValue);
                result = result.replaceAll(PLACE_HOLDER_SIGN + i + PLACE_HOLDER_SIGN, replacementValue);
            }
            return result;
        }
        return "";
    }

    @Override
    protected void addAdditionalParameters(ParameterAcceptor output) {
        output.addParameter(TOKEN_CONFIGURATION_ITEM_KEY, this.configurationItemKey);
        output.addParameter(TOKEN_ID_INDEX, this.idIndex);
        output.addParameter(TOKEN_CSV_FORMAT, this.csvFormat);
    }

    @Override
    protected void extractAdditionalParameters(ParameterDonor input) {
        this.configurationItemKey = ObjectUtils.stringValue(input.get(TOKEN_CONFIGURATION_ITEM_KEY));
        this.idIndex = ObjectUtils.intValue(input.get(TOKEN_ID_INDEX));
        this.idIndexRaw = ObjectUtils.stringValue(input.get(TOKEN_ID_INDEX));
        this.csvFormat = ObjectUtils.stringValue(input.get(TOKEN_CSV_FORMAT));
    }

    @Override
    protected void cleanAdditionalParameters(ParameterAcceptor output) {
        output.removeParameter(TOKEN_CONFIGURATION_ITEM_KEY);
        output.removeParameter(TOKEN_ID_INDEX);
        output.removeParameter(TOKEN_CSV_FORMAT);
    }

    @Override
    public void validateAdditionalData(I18nResolver i18n, ErrorHolder errorHolder) {
        if (StringUtils.isBlank((String)this.configurationItemKey)) {
            errorHolder.addError(TOKEN_CONFIGURATION_ITEM_KEY, i18n.getText("com.device42.atlas.page.configuration.parameter.references.confitemkey.error.blank"));
        }
        if (StringUtils.isBlank((String)this.idIndexRaw)) {
            errorHolder.addError(TOKEN_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.blank"));
        } else {
            try {
                Integer.parseInt(this.idIndexRaw);
                if (this.idIndex < 0) {
                    errorHolder.addError(TOKEN_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.negative"));
                }
            }
            catch (Exception e) {
                errorHolder.addError(TOKEN_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.format"));
            }
        }
    }
}

