/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ParameterType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class MultiParameter
extends Parameter
implements Iterable<Parameter> {
    List<Parameter> parameterValues = new ArrayList<Parameter>();

    public MultiParameter(ParameterType type) {
        super(type);
    }

    @Override
    public String getValue() {
        return StringUtils.join(this.parameterValues, (String)", ");
    }

    public boolean canBeAdded(@Nonnull Parameter parameter) {
        return this.type.equals(parameter.getType());
    }

    protected void checkAddition(Parameter parameter) throws IllegalArgumentException {
        if (!this.canBeAdded(parameter)) {
            throw new IllegalArgumentException("Parameters should be of the same kind");
        }
    }

    public void addParameter(Parameter parameter) throws IllegalArgumentException {
        this.checkAddition(parameter);
        if (parameter instanceof MultiParameter) {
            if (!this.equals(parameter)) {
                this.addParameters((MultiParameter)parameter);
            }
        } else {
            this.parameterValues.add(parameter);
        }
    }

    private void addParameters(Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameterValues.iterator();
    }

    @Override
    public boolean checkParameterFilterValue(String filterValue) {
        for (Parameter parameter : this.parameterValues) {
            if (!parameter.checkParameterFilterValue(filterValue)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.parameterValues.size();
    }
}

