/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.serialization.PluginSettingsAcceptor;
import com.device42.atlas.common.model.serialization.PluginSettingsDonor;
import com.device42.atlas.common.util.ObjectUtils;

public class D42SettingsManagerImpl
implements D42SettingsManager {
    public static final String CRON_PREFIX = "CRON.";
    public static final String DEVICE42_SETTINGS_KEY = "DEVICE42_SETTINGS";
    private final PluginSettings pluginSettings;

    public D42SettingsManagerImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(DEVICE42_SETTINGS_KEY);
    }

    @Override
    public void deleteConnectionInfo() {
        D42ConnectionInfo connectionInfo = new D42ConnectionInfo(null);
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(this.pluginSettings, new String[0]);
        connectionInfo.clear(pluginSettingsAcceptor);
    }

    @Override
    public D42ConnectionInfo getConnectionInfo() {
        PluginSettingsDonor pluginSettingsDonor = new PluginSettingsDonor(this.pluginSettings);
        pluginSettingsDonor.addCryptedKey("password");
        D42ConnectionInfo connectionInfo = new D42ConnectionInfo(pluginSettingsDonor);
        if (connectionInfo.isConfigured()) {
            connectionInfo.setCron(this.getCron());
        }
        return connectionInfo;
    }

    @Override
    public void setConnectionInfo(D42ConnectionInfo connectionInfo) {
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(this.pluginSettings, "cron", "configured");
        pluginSettingsAcceptor.addCryptedKey("password");
        connectionInfo.saveToAcceptor(pluginSettingsAcceptor);
    }

    @Override
    public String getCron() {
        Object cronObj = this.pluginSettings.get(CRON_PREFIX.concat("d42defaultjob"));
        return ObjectUtils.stringValue(cronObj);
    }

    @Override
    public void setCron(String cron) {
        this.pluginSettings.put(CRON_PREFIX.concat("d42defaultjob"), (Object)cron);
    }
}

