/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v29;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.job.D42PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.util.PartialCIList;

public class V28_29UpgradeExecutor
extends AbstractUpgradeExecutor {
    private static Logger.Log log = Logger.getInstance(V28_29UpgradeExecutor.class);

    public V28_29UpgradeExecutor(D42PluginUpgradeTask upgradeTask) {
        super(upgradeTask);
    }

    @Override
    public void execute() {
        D42DataManager dataManager = this.upgradeTask.getDataManager();
        log.info((Object)"V2.9 Data display name collection started");
        for (ConfigurationItemType type : dataManager.getCollectableSchema()) {
            log.info((Object)("V2.9 Collecting CI type: " + type.getName()));
            int limit = 1000;
            int offset = 0;
            try {
                PartialCIList ciList = dataManager.getActiveByType(type, null, null, offset, limit);
                dataManager.createOrUpdateCIs(ciList, false);
                int total = ciList.getTotal();
                log.info((Object)("V2.9 Found " + total + " CIs, collected " + ciList.size()));
                while (total > offset + limit) {
                    ciList = dataManager.getActiveByType(type, null, null, offset += limit, limit);
                    log.info((Object)("V2.9 Found " + total + " CIs, collected " + (offset + ciList.size())));
                    dataManager.createOrUpdateCIs(ciList, false);
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to reset display names in lower cases", (Throwable)e);
            }
        }
    }
}

