/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class EnumKeyStorage<E extends Enum<E>> {
    private Map<String, E> enumStorage = new LinkedHashMap<String, E>();
    private E defaultValue;

    @SafeVarargs
    public EnumKeyStorage(E defaultValue, E ... values) {
        this.defaultValue = defaultValue;
        for (E value : values) {
            this.enumStorage.put(((TextValue)value).getTextValue(), value);
        }
    }

    public E getByTextValue(String textValue) {
        if (textValue == null) {
            return this.defaultValue;
        }
        Enum result = (Enum)this.enumStorage.get(textValue);
        return (E)(result == null ? this.defaultValue : result);
    }

    public static interface TextValue {
        public String getTextValue();
    }
}

