/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.device42.atlas.common.model.serialization.ErrorHolder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class NestingErrorHolderHelper<T extends ErrorHolder> {
    private T parentHolder;
    private Map<String, T> nestedHolders = new LinkedHashMap<String, T>();

    public void setError() {
        if (this.parentHolder != null) {
            this.parentHolder.storeNestedErrors();
        }
    }

    public T getParentHolder() {
        return this.parentHolder;
    }

    public void setParentHolder(T parentHolder) {
        this.parentHolder = parentHolder;
    }

    public void addNestedHolder(String key, T nestedHolder) {
        this.nestedHolders.put(key, nestedHolder);
    }

    public Map<String, T> extractFailedHolders() {
        LinkedHashMap<String, ErrorHolder> failedHolders = new LinkedHashMap<String, ErrorHolder>();
        HashSet<String> removedKeys = new HashSet<String>();
        for (String key : this.nestedHolders.keySet()) {
            ErrorHolder nestedHolder = (ErrorHolder)this.nestedHolders.get(key);
            if (!nestedHolder.hasErrors()) continue;
            removedKeys.add(key);
            failedHolders.put(key, nestedHolder);
        }
        if (removedKeys.size() > 0) {
            this.setError();
            for (String key : removedKeys) {
                this.nestedHolders.remove(key);
            }
        }
        return failedHolders;
    }
}

