/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.model.serialization.NestingErrorHolderHelper;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class JsonParameters
implements ErrorHolder {
    private JsonObject jsonObject;
    private NestingErrorHolderHelper<JsonParameters> nestingHelper = new NestingErrorHolderHelper();

    @Override
    public void setError() {
        this.jsonObject.addProperty("result", "error");
        this.nestingHelper.setError();
    }

    @Override
    public void setSuccess() {
        this.jsonObject.addProperty("result", "ok");
    }

    public JsonParameters(@Nonnull JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JsonParameters() {
        this(new JsonObject());
    }

    @Override
    public boolean hasErrors() {
        return this.jsonObject.has("result") && "error".equals(this.jsonObject.get("result").getAsString());
    }

    @Override
    public void addErrorMessage(String message) {
        this.setError();
        JsonArray errorMessages = null;
        if (this.jsonObject.has("errorMessages") && this.jsonObject.get("errorMessages").isJsonArray()) {
            errorMessages = this.jsonObject.get("errorMessages").getAsJsonArray();
        }
        if (errorMessages == null) {
            errorMessages = new JsonArray();
            this.jsonObject.add("errorMessages", errorMessages);
        }
        errorMessages.add(new JsonPrimitive(message));
    }

    private JsonObject getErrorsObject() {
        JsonObject errors = null;
        if (this.jsonObject.has("errors") && this.jsonObject.get("errors").isJsonObject()) {
            errors = this.jsonObject.get("errors").getAsJsonObject();
        }
        if (errors == null) {
            errors = new JsonObject();
            this.jsonObject.add("errors", errors);
        }
        return errors;
    }

    @Override
    public void addError(String field, String message) {
        this.setError();
        JsonObject errors = this.getErrorsObject();
        errors.addProperty(field, message);
    }

    @Override
    public void storeNestedErrors() {
        JsonObject errorsObject = this.getErrorsObject();
        Map<String, JsonParameters> failedHolders = this.nestingHelper.extractFailedHolders();
        for (String key : failedHolders.keySet()) {
            errorsObject.add(key, failedHolders.get(key).getJsonObject());
        }
        if (failedHolders.size() > 0) {
            this.setError();
        }
    }

    @Override
    public ErrorHolder getNestedErrorHolder(String field) {
        JsonParameters nestedHolder = new JsonParameters();
        this.nestingHelper.addNestedHolder(field, nestedHolder);
        nestedHolder.nestingHelper.setParentHolder(this);
        return nestedHolder;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    private JsonElement createParameter(Object value) {
        if (value == null) {
            return new JsonNull();
        }
        if (value instanceof String) {
            return new JsonPrimitive((String)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Character) {
            return new JsonPrimitive((Character)value);
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            Map<String, Object> stringMapValue = ObjectUtils.convertMapToStringMap(mapValue);
            MapDonor mapDonor = new MapDonor(stringMapValue);
            JsonParameters mapParameters = new JsonParameters();
            mapParameters.addParameters(mapDonor);
            return mapParameters.getJsonObject();
        }
        if (value instanceof Collection) {
            JsonArray jsonArray = new JsonArray();
            Collection collectionValue = (Collection)value;
            for (Object collectionObject : collectionValue) {
                jsonArray.add(this.createParameter(collectionObject));
            }
            return jsonArray;
        }
        if (value instanceof JsonParameters) {
            return ((JsonParameters)value).getJsonObject();
        }
        if (value instanceof JsonElement) {
            return (JsonElement)value;
        }
        return new JsonPrimitive(value.toString());
    }

    @Override
    public void addParameter(String key, Object value) {
        if (!("errors".equals(key) || "errorMessages".equals(key) || "result".equals(key))) {
            this.jsonObject.add(key, this.createParameter(value));
        }
    }

    @Override
    public void addParameters(ParameterDonor parameters) {
        for (String key : parameters.keys()) {
            this.addParameter(key, parameters.get(key));
        }
    }

    @Override
    public void removeParameter(String key) {
        this.jsonObject.remove(key);
    }

    @Override
    public void addParameters(Parameterizable paramObject) {
        if (paramObject != null) {
            paramObject.saveToAcceptor(this);
        }
    }

    @Override
    public ParameterAcceptor generateChildAcceptorObject(String key) {
        JsonParameters jsonParameters = new JsonParameters();
        this.addParameter(key, jsonParameters);
        return jsonParameters;
    }
}

