/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.device42.atlas.common.model.core.ConfigurationItemParameter;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ParameterType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiConfigurationItemParameter
extends ConfigurationItemParameter
implements Iterable<ConfigurationItemParameter> {
    private List<ConfigurationItemParameter> ciParameterValues = new ArrayList<ConfigurationItemParameter>();

    public MultiConfigurationItemParameter(ParameterType type) {
        super(type);
    }

    @Override
    public String getValue() {
        String result = super.getValue();
        if (result == null) {
            StringBuilder resultBuilder = new StringBuilder();
            for (ConfigurationItemParameter ciParameterValue : this.ciParameterValues) {
                resultBuilder.append(ciParameterValue.getConfigurationItem().getStorageId());
            }
            result = resultBuilder.toString();
        }
        return result;
    }

    public void addParameter(ConfigurationItemParameter parameter) throws IllegalArgumentException {
        if (!(parameter instanceof MultiConfigurationItemParameter)) {
            this.ciParameterValues.add(parameter);
        }
    }

    @Override
    public Iterator<ConfigurationItemParameter> iterator() {
        return this.ciParameterValues.iterator();
    }

    @Override
    public boolean checkParameterFilterValue(String filterValue) {
        for (Parameter parameter : this.ciParameterValues) {
            if (!parameter.checkParameterFilterValue(filterValue)) continue;
            return true;
        }
        return false;
    }

    public List<ConfigurationItemParameter> getCiParameterValues() {
        return this.ciParameterValues;
    }
}

