/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class D42ValueHolder {
    private static final Logger.Log log = Logger.getInstance(D42ValueHolder.class);
    private final ConfigurationItemType type;
    private final String rawTypeKey;
    private final String[] ids;

    public static D42ValueHolder createD42FieldValueHolder(Schema schema, String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        D42ValueHolder d42ValueHolder = null;
        try {
            Matcher typeKeyMatcher = Pattern.compile("[a-zA-Z]+").matcher(value);
            typeKeyMatcher.find();
            String typeKey = typeKeyMatcher.group();
            String ids = value.substring(typeKey.length());
            d42ValueHolder = new D42ValueHolder(schema, typeKey, ids.split(","));
        }
        catch (Exception e) {
            log.error((Object)("Field " + value + " could not be parsed"));
        }
        return d42ValueHolder;
    }

    private D42ValueHolder(Schema schema, String typeKey, String[] ids) {
        this.rawTypeKey = typeKey;
        this.type = schema.getByKey(typeKey);
        this.ids = ids;
    }

    @Nonnull
    public String[] getIds() {
        return this.ids;
    }

    @Nonnull
    public ConfigurationItemType getType() {
        return this.type;
    }

    public String toString() {
        return "D42ValueHolder [type=" + this.type + ", ids=" + ObjectUtils.stringJoin(",", this.ids) + "]";
    }

    public String getRawTypeKey() {
        return this.rawTypeKey;
    }
}

