/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.device42.atlas.common.job.ConfigurationItemCollectionStatistics;
import com.device42.atlas.common.job.JobStatistics;
import com.device42.atlas.common.job.JobStatus;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.PluginSettingsAcceptor;
import com.device42.atlas.common.model.serialization.PluginSettingsDonor;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class D42JobStatisticsManagerImpl
implements D42JobStatisticsManager {
    public static final String DEVICE42_JOB_STATISTICS_KEY = "DEVICE42_JOB_STATISTICS";
    public static final int DEVICE42_JOB_ABORT_WAIT_TICK_MS = 1000;
    public static final int MAX_ABORT_WAIT_MS = 45000;
    public static final String DEVICE42_PENDING_MARKER = "D42Pending";
    public static final String DEVICE42_PENDING_DATE = "D42PendingDate";
    public static final String DEVICE42_LAST_UPDATED_PREFIX = "D42LastUpdatedDate";
    private final PluginSettings pluginSettings;

    public D42JobStatisticsManagerImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(DEVICE42_JOB_STATISTICS_KEY);
    }

    private JobStatistics loadJobStatistics(Schema schema) {
        PluginSettingsDonor pluginSettingsDonor = new PluginSettingsDonor(this.pluginSettings);
        JobStatistics jobStatistics = new JobStatistics(schema);
        jobStatistics.loadFromDonor(pluginSettingsDonor);
        return jobStatistics;
    }

    private void saveJobStatistics(JobStatistics jobStatistics) {
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(this.pluginSettings, new String[0]);
        jobStatistics.saveToAcceptor(pluginSettingsAcceptor);
    }

    @Override
    public void clearJobStatistics(JobStatistics jobStatistics) {
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(this.pluginSettings, new String[0]);
        jobStatistics.clear(pluginSettingsAcceptor);
    }

    @Override
    public JobStatus getCurrentJobStatus() {
        JobStatistics jobStatistics = this.loadJobStatistics(null);
        return jobStatistics.getJobStatus();
    }

    @Override
    public JobStatistics getCurrentJobStatistics(Schema schema) {
        return this.loadJobStatistics(schema);
    }

    private boolean canStartJob() {
        JobStatistics jobStatistics = this.loadJobStatistics(null);
        return jobStatistics.isTerminal() || jobStatistics.isAbandoned();
    }

    @Override
    public boolean startJob(Schema schema, String jobSessionId, boolean forceStart, boolean fullRescan) throws InterruptedException {
        if (!this.canStartJob()) {
            if (forceStart) {
                this.setJobStatus(null, JobStatus.CANCELLED, true);
                long waitTimeMs = 0L;
                do {
                    Thread.sleep(1000L);
                } while (!this.canStartJob() || (waitTimeMs += 1000L) > 45000L);
                if (!this.canStartJob()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        JobStatistics jobStatistics = new JobStatistics(schema);
        if (fullRescan) {
            jobStatistics.fillDefaultCIStatistics();
        }
        this.clearJobStatistics(jobStatistics);
        Date now = new Date();
        jobStatistics.setJobStarted(now);
        jobStatistics.setJobUpdated(now);
        jobStatistics.setJobSessionId(jobSessionId);
        jobStatistics.setJobStatus(JobStatus.STARTED);
        this.saveJobStatistics(jobStatistics);
        return true;
    }

    @Override
    public boolean setJobStatus(String jobSessionId, JobStatus jobStatus, boolean forceChange) {
        JobStatistics currentJobStatistics = this.getCurrentJobStatistics(null);
        if (forceChange || jobSessionId != null && jobSessionId.equals(currentJobStatistics.getJobSessionId())) {
            currentJobStatistics.setJobStatus(jobStatus);
            Date now = new Date();
            if (currentJobStatistics.isTerminal()) {
                currentJobStatistics.setJobFinished(now);
            }
            currentJobStatistics.setJobUpdated(now);
            this.saveJobStatistics(currentJobStatistics);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateConfigurationItemStatistics(Schema schema, String jobSessionId, ConfigurationItemType type, long collected, long total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus collectionStatus) {
        JobStatistics currentJobStatistics = this.getCurrentJobStatistics(schema);
        if (jobSessionId != null && jobSessionId.equals(currentJobStatistics.getJobSessionId())) {
            currentJobStatistics.setJobUpdated(new Date());
            currentJobStatistics.setConfigurationItemCollectionStatistics(type, collected, total, collectionStatus);
            this.saveJobStatistics(currentJobStatistics);
            return true;
        }
        return false;
    }

    @Override
    public boolean abortCurrentJob() {
        if (!this.canStartJob()) {
            return this.setJobStatus(null, JobStatus.CANCELLED, true);
        }
        return false;
    }

    @Override
    public String generateSessionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public boolean isPendingManually() {
        Calendar abandonedPendingDate = Calendar.getInstance();
        abandonedPendingDate.add(14, -45000);
        Date pendingDate = ObjectUtils.dateValue(this.pluginSettings.get(DEVICE42_PENDING_DATE));
        if (pendingDate != null && abandonedPendingDate.getTime().after(pendingDate)) {
            return false;
        }
        return ObjectUtils.booleanValue(this.pluginSettings.get(DEVICE42_PENDING_MARKER), false);
    }

    @Override
    public void setPendingManually(boolean pending) {
        this.pluginSettings.put(DEVICE42_PENDING_MARKER, (Object)ObjectUtils.stringValue(pending));
        this.pluginSettings.put(DEVICE42_PENDING_DATE, (Object)ObjectUtils.formatDate(new Date()));
    }

    @Override
    public Date getLastUpdatedTime(ConfigurationItemType type) {
        if (type != null && StringUtils.isNotBlank((String)type.getKey())) {
            return ObjectUtils.dateValue(this.pluginSettings.get(DEVICE42_LAST_UPDATED_PREFIX + type.getKey()));
        }
        return null;
    }

    @Override
    public boolean setLastUpdatedTime(String jobSessionId, ConfigurationItemType type, Date lastUpdatedTime) {
        JobStatistics currentJobStatistics = this.getCurrentJobStatistics(null);
        if (jobSessionId == null || jobSessionId.equals(currentJobStatistics.getJobSessionId())) {
            if (lastUpdatedTime != null) {
                this.pluginSettings.put(DEVICE42_LAST_UPDATED_PREFIX + type.getKey(), (Object)ObjectUtils.formatDate(lastUpdatedTime));
            } else {
                this.pluginSettings.remove(DEVICE42_LAST_UPDATED_PREFIX + type.getKey());
            }
            return true;
        }
        return false;
    }
}

