/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.device42.atlas.common.manager.D42CIConfigurationServletProcessor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.util.ObjectUtils;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class D42CIConfigurationServletProcessorImpl
implements D42CIConfigurationServletProcessor {
    private static final Logger.Log log = Logger.getInstance(D42CIConfigurationServletProcessorImpl.class);
    protected static final String VM_BASE = "/com/device42/atlas/templates/action/admin/configuration/";
    protected static final String VM_VIEW = "/com/device42/atlas/templates/action/admin/configuration/main.vm";
    protected static final String ACTION_GET_SCHEMA_AND_DATA = "getSchemaAndData";
    protected static final String ACTION_SAVE_ITEM = "saveItem";
    protected static final String ACTION_DELETE_ITEM = "deleteItem";
    protected static final String ACTION_SAVE_PARAM_TYPE = "saveParamType";
    protected static final String ACTION_DELETE_PARAM_TYPE = "deleteParamType";
    protected static final String ACTION_EXTRACT_PARAM_TYPES = "extractParamTypes";
    protected static final String ACTION_EXPORT_SCHEMA = "exportSchema";
    protected static final String ACTION_IMPORT_SCHEMA = "importSchema";
    protected static final String ACTION_SAVE_CONFIG_STYLE = "saveConfigStyle";
    protected static final String TOKEN_FULL_SCHEMA = "fullSchema";
    protected static final String TOKEN_NEW_CI = "newConfigurationItem";
    protected static final String TOKEN_NEW_PARAM = "newParameter";
    protected static final String TOKEN_KEY = "key";
    protected static final String TOKEN_CI_KEY = "ciKey";
    protected static final String TOKEN_SAVED_KEY = "savedKey";
    protected static final String TOKEN_PARAMETER_VALUE_TYPES = "parameterValueTypes";
    protected static final String TOKEN_PARAMETER_SIMPLE_TYPES = "parameterSimpleTypes";
    protected static final String TOKEN_PARAMETER_ACCORDION_SWITCH = "accordionSwitch";
    protected static final String TOKEN_PARAMETER_CF_TEXT_SIZE = "textSize";
    protected static final String D42_ACCORDION_SWITCH_PROPERTY_KEY = "com.device42.atlas.customfield.accordion.switch";
    protected static final String D42_CF_TEXT_SIZE_PROPERTY_KEY = "com.device42.atlas.customfield.text.size";
    protected static final String SCHEMA_FILE_NAME = "schema.json";
    protected static final String TOKEN_CONFIRM_DELETE = "agreeDelete";
    protected static final String TOKEN_CONFIRM_IMPORT = "agreeImport";
    protected static final String TOKEN_CLEAN_IMPORT = "cleanImport";
    protected static final String TOKEN_LOAD_DEFAULT = "loadDefault";
    protected final D42DataManager dataManager;
    protected final I18nResolver i18n;
    protected final PluginSettingsFactory pluginSettingsFactory;
    protected final TransactionTemplate transactionTemplate;
    protected static final String[] actions = new String[]{"getSchemaAndData", "saveItem", "deleteItem", "saveParamType", "deleteParamType", "extractParamTypes", "exportSchema", "importSchema", "saveConfigStyle"};

    public D42CIConfigurationServletProcessorImpl(D42DataManager dataManager, I18nResolver i18n, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.dataManager = dataManager;
        this.i18n = i18n;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    protected String processViewAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameter(TOKEN_FULL_SCHEMA, this.dataManager.getSchema());
        outputParameters.addParameter(TOKEN_PARAMETER_VALUE_TYPES, ParameterType.ParameterValueType.values());
        outputParameters.addParameter(TOKEN_PARAMETER_SIMPLE_TYPES, SimpleParameterType.SimpleValueType.values());
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String enableAccordion = (String)pluginSettings.get(D42_ACCORDION_SWITCH_PROPERTY_KEY);
        outputParameters.addParameter(TOKEN_PARAMETER_ACCORDION_SWITCH, BooleanUtils.toBoolean((String)enableAccordion));
        String textSize = (String)pluginSettings.get(D42_CF_TEXT_SIZE_PROPERTY_KEY);
        outputParameters.addParameter(TOKEN_PARAMETER_CF_TEXT_SIZE, textSize);
        return VM_VIEW;
    }

    private void gatherSchema(ErrorHolder outputParameters) {
        Schema fullSchema = this.dataManager.getSchema();
        ParameterAcceptor schemaAcceptor = outputParameters.generateChildAcceptorObject(TOKEN_FULL_SCHEMA);
        fullSchema.saveToAcceptor(schemaAcceptor);
    }

    protected String processGetSchemaAndData(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        this.gatherSchema(outputParameters);
        return null;
    }

    protected String processSaveItemAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        ConfigurationItemType configurationItemType = new ConfigurationItemType(new MapDonor(parameters));
        boolean isNewCi = ObjectUtils.booleanValue(parameters.get(TOKEN_NEW_CI), false);
        if (isNewCi) {
            Schema oldSchema = this.dataManager.getSchema();
            configurationItemType.validate(this.i18n, outputParameters, oldSchema);
        } else {
            configurationItemType.validate(this.i18n, outputParameters, null);
        }
        log.debug((Object)("CI: " + configurationItemType));
        if (!outputParameters.hasErrors()) {
            try {
                this.dataManager.saveConfigurationItemType(configurationItemType);
                this.dataManager.checkReferenceParameters();
                outputParameters.setSuccess();
                outputParameters.addParameter(TOKEN_SAVED_KEY, configurationItemType.getKey());
                return this.processGetSchemaAndData(parameters, outputParameters);
            }
            catch (Exception e) {
                log.error((Object)"Failed to save configuration item", (Throwable)e);
                outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.save.ci.unknown", new Serializable[]{e.getMessage()}));
            }
        } else {
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.save.ci.generic"));
        }
        return null;
    }

    protected String processDeleteItemAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        boolean deleteConfirmed = ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_DELETE), false);
        if (deleteConfirmed) {
            String key = ObjectUtils.stringValue(parameters.get(TOKEN_KEY));
            try {
                this.dataManager.deleteConfigurationItemTypeByKey(key);
                this.dataManager.checkReferenceParameters();
                outputParameters.setSuccess();
                return this.processGetSchemaAndData(parameters, outputParameters);
            }
            catch (Exception e) {
                log.error((Object)"Failed to delete configuration item", (Throwable)e);
                outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.delete.ci.unknown.error", new Serializable[]{e.getMessage()}));
            }
        } else {
            outputParameters.addError(TOKEN_CONFIRM_DELETE, this.i18n.getText("com.device42.atlas.page.configuration.delete.ci.agree.error"));
        }
        return null;
    }

    protected String processSaveParamTypeAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        ParameterType parameterType = ParameterType.createParameter(new MapDonor(parameters));
        String ciKey = parameters.get(TOKEN_CI_KEY);
        ConfigurationItemType configurationItemType = this.dataManager.getConfigurationItemTypeByKey(ciKey);
        boolean isNewParam = ObjectUtils.booleanValue(parameters.get(TOKEN_NEW_PARAM), false);
        if (isNewParam) {
            parameterType.validate(this.i18n, outputParameters, configurationItemType);
        } else {
            parameterType.validate(this.i18n, outputParameters, null);
        }
        if (!outputParameters.hasErrors()) {
            try {
                this.dataManager.updateParameterType(ciKey, parameterType);
                this.dataManager.checkReferenceParameters();
                outputParameters.addParameter(TOKEN_SAVED_KEY, ciKey);
                outputParameters.setSuccess();
                return this.processGetSchemaAndData(parameters, outputParameters);
            }
            catch (Exception e) {
                log.error((Object)"Failed to save parameter type", (Throwable)e);
                outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.save.param.unknown", new Serializable[]{e.getMessage()}));
            }
        } else {
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.save.param.generic"));
        }
        return null;
    }

    protected String processExtractParamTypesAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        String ciKey = ObjectUtils.stringValue(parameters.get(TOKEN_CI_KEY));
        if (StringUtils.isBlank((String)ciKey)) {
            outputParameters.addError(TOKEN_CI_KEY, this.i18n.getText("com.device42.atlas.page.configuration.extract.params.nocikey.error"));
            return null;
        }
        try {
            ConfigurationItemType configurationItemType = this.dataManager.getConfigurationItemTypeByKey(ciKey);
            if (configurationItemType == null) {
                outputParameters.addError(TOKEN_CI_KEY, this.i18n.getText("com.device42.atlas.page.configuration.extract.params.noci.error"));
                return null;
            }
            if (configurationItemType.getParameterTypes() != null && configurationItemType.getParameterTypes().size() > 0) {
                outputParameters.addError(TOKEN_CI_KEY, this.i18n.getText("com.device42.atlas.page.configuration.extract.params.cinotemtpy.error"));
                return null;
            }
            if (configurationItemType.getQuery() == null || StringUtils.isBlank((String)configurationItemType.getQuery().toString())) {
                outputParameters.addError("query", this.i18n.getText("com.device42.atlas.page.configuration.extract.params.nodoql.error"));
                return null;
            }
            if (configurationItemType.getQuery().hasErrors()) {
                outputParameters.addError("query", this.i18n.getText("com.device42.atlas.page.configuration.extract.params.doql.error", new Serializable[]{configurationItemType.getQuery().getErrorMessage(this.i18n)}));
                return null;
            }
            if (StringUtils.isBlank((String)configurationItemType.getQuery().getListedColumns())) {
                outputParameters.addError("query", this.i18n.getText("com.device42.atlas.page.configuration.extract.params.nocolumns.error"));
                return null;
            }
            String[] listedColumns = configurationItemType.getQuery().getListedColumns().split(",");
            int weight = 0;
            for (int i = 0; i < listedColumns.length; ++i) {
                if (configurationItemType.getIdIndex() == i) continue;
                String listedColumnName = listedColumns[i];
                String listedColumnKey = listedColumnName.trim().replaceAll("[^A-Za-z0-9]", "_");
                SimpleParameterType parameterType = new SimpleParameterType();
                parameterType.setCollectionIndex(i);
                parameterType.setKey(listedColumnKey);
                parameterType.setName(listedColumnName);
                parameterType.setDefaultFilterViewEnabled(true);
                parameterType.setSearchEnabled(true);
                parameterType.setEnabled(true);
                parameterType.setViewWeight(weight += 100);
                parameterType.setSimpleValueType(SimpleParameterType.SimpleValueType.STRING);
                this.dataManager.updateParameterType(ciKey, parameterType);
            }
            outputParameters.addParameter(TOKEN_SAVED_KEY, ciKey);
            outputParameters.setSuccess();
            return this.processGetSchemaAndData(parameters, outputParameters);
        }
        catch (Exception e) {
            log.error((Object)"Failed to extract parameters", (Throwable)e);
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.extract.params.unknown.error", new Serializable[]{e.getMessage()}));
            return null;
        }
    }

    protected String processDeleteParamTypeAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        boolean deleteConfirmed = ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_DELETE), false);
        if (deleteConfirmed) {
            String key = ObjectUtils.stringValue(parameters.get(TOKEN_KEY));
            String ciKey = ObjectUtils.stringValue(parameters.get(TOKEN_CI_KEY));
            try {
                this.dataManager.removeParameterType(ciKey, key);
                outputParameters.addParameter(TOKEN_SAVED_KEY, ciKey);
                outputParameters.setSuccess();
                return this.processGetSchemaAndData(parameters, outputParameters);
            }
            catch (Exception e) {
                log.error((Object)"Failed to delete parameter type", (Throwable)e);
                outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.delete.param.unknown.error", new Serializable[]{e.getMessage()}));
            }
        } else {
            outputParameters.addError(TOKEN_CONFIRM_DELETE, this.i18n.getText("com.device42.atlas.page.configuration.delete.param.agree.error"));
        }
        return null;
    }

    protected String processExportSchemaAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        Schema fullSchema = this.dataManager.getSchema();
        fullSchema.saveToAcceptor(outputParameters);
        return SCHEMA_FILE_NAME;
    }

    protected String processImportSchemaAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        boolean importConfirmed = ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_IMPORT), false);
        if (importConfirmed) {
            boolean cleanSchema = ObjectUtils.booleanValue(parameters.get(TOKEN_CLEAN_IMPORT), false);
            boolean loadDefault = ObjectUtils.booleanValue(parameters.get(TOKEN_LOAD_DEFAULT), false);
            if (loadDefault) {
                try {
                    this.dataManager.importDefaultSchema(cleanSchema);
                    this.dataManager.checkReferenceParameters();
                    return this.processGetSchemaAndData(parameters, outputParameters);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to load default schema", (Throwable)e);
                    outputParameters.addError(TOKEN_LOAD_DEFAULT, this.i18n.getText("com.device42.atlas.page.configuration.error.loaddefault.unknown", new Serializable[]{e.getMessage()}));
                }
            } else {
                MapDonor requestDonor = new MapDonor(parameters);
                ParameterDonor schemaDonor = requestDonor.extractNestedObject(TOKEN_FULL_SCHEMA);
                Schema importedSchema = new Schema(schemaDonor);
                log.error((Object)importedSchema);
                importedSchema.validate(this.i18n, outputParameters.getNestedErrorHolder(TOKEN_FULL_SCHEMA));
                if (!outputParameters.hasErrors()) {
                    try {
                        if (cleanSchema) {
                            this.dataManager.importSchema(importedSchema);
                        } else {
                            this.dataManager.mergeSchema(importedSchema);
                        }
                        return this.processGetSchemaAndData(parameters, outputParameters);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to import schema", (Throwable)e);
                        outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.import.unknown", new Serializable[]{e.getMessage()}));
                    }
                } else {
                    outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.configuration.error.import.generic"));
                }
            }
        } else {
            outputParameters.addError(TOKEN_CONFIRM_IMPORT, this.i18n.getText("com.device42.atlas.page.configuration.import.schema.dialog.error.agree"));
        }
        return null;
    }

    protected String processSaveConfigStyle(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        boolean accordionSwitch = ObjectUtils.booleanValue(parameters.get(TOKEN_PARAMETER_ACCORDION_SWITCH), false);
        String textSize = ObjectUtils.stringValue(parameters.get(TOKEN_PARAMETER_CF_TEXT_SIZE));
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(D42_ACCORDION_SWITCH_PROPERTY_KEY, (Object)BooleanUtils.toString((boolean)accordionSwitch, (String)"true", (String)"false"));
        try {
            int ts = Integer.parseInt(textSize);
            if (ts < 10 || ts > 20) {
                outputParameters.addError(TOKEN_PARAMETER_CF_TEXT_SIZE, this.i18n.getText("com.device42.atlas.page.configuration.style.textsize.range.error"));
            } else {
                pluginSettings.put(D42_CF_TEXT_SIZE_PROPERTY_KEY, (Object)Integer.toString(ts));
            }
        }
        catch (NumberFormatException e) {
            outputParameters.addError(TOKEN_PARAMETER_CF_TEXT_SIZE, this.i18n.getText("com.device42.atlas.page.configuration.style.textsize.type.error"));
        }
        return null;
    }

    @Override
    public String processRequestServletAction(String action, Map<String, String> parameters, ErrorHolder outputParameters) {
        if (ACTION_GET_SCHEMA_AND_DATA.equals(action)) {
            return this.processGetSchemaAndData(parameters, outputParameters);
        }
        if (ACTION_SAVE_ITEM.equals(action)) {
            return this.processSaveItemAction(parameters, outputParameters);
        }
        if (ACTION_DELETE_ITEM.equals(action)) {
            return this.processDeleteItemAction(parameters, outputParameters);
        }
        if (ACTION_SAVE_PARAM_TYPE.equals(action)) {
            return this.processSaveParamTypeAction(parameters, outputParameters);
        }
        if (ACTION_DELETE_PARAM_TYPE.equals(action)) {
            return this.processDeleteParamTypeAction(parameters, outputParameters);
        }
        if (ACTION_EXTRACT_PARAM_TYPES.equals(action)) {
            return this.processExtractParamTypesAction(parameters, outputParameters);
        }
        if (ACTION_EXPORT_SCHEMA.equals(action)) {
            return this.processExportSchemaAction(parameters, outputParameters);
        }
        if (ACTION_IMPORT_SCHEMA.equals(action)) {
            return this.processImportSchemaAction(parameters, outputParameters);
        }
        if (ACTION_SAVE_CONFIG_STYLE.equals(action)) {
            return this.processSaveConfigStyle(parameters, outputParameters);
        }
        return this.processViewAction(parameters, outputParameters);
    }

    @Override
    public String[] getActions() {
        return actions;
    }

    @Override
    public boolean isPostActionOnly(String actionName) {
        return ACTION_SAVE_ITEM.equals(actionName) || ACTION_DELETE_ITEM.equals(actionName) || ACTION_SAVE_PARAM_TYPE.equals(actionName) || ACTION_DELETE_PARAM_TYPE.equals(actionName) || ACTION_IMPORT_SCHEMA.equals(actionName) || ACTION_EXTRACT_PARAM_TYPES.equals(actionName) || ACTION_SAVE_CONFIG_STYLE.equals(actionName);
    }

    @Override
    public boolean isJson(String action) {
        return ACTION_GET_SCHEMA_AND_DATA.equals(action) || ACTION_SAVE_ITEM.equals(action) || ACTION_DELETE_ITEM.equals(action) || ACTION_SAVE_PARAM_TYPE.equals(action) || ACTION_DELETE_PARAM_TYPE.equals(action) || ACTION_EXPORT_SCHEMA.equals(action) || ACTION_IMPORT_SCHEMA.equals(action) || ACTION_EXTRACT_PARAM_TYPES.equals(action) || ACTION_SAVE_CONFIG_STYLE.equals(action);
    }
}

