/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v30;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.device42.atlas.common.job.ConfigurationItemCollectionStatistics;
import com.device42.atlas.common.job.D42PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.job.upgrade.v30._ConfigurationItemType;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.PluginSettingsAcceptor;
import com.device42.atlas.common.model.serialization.PluginSettingsDonor;
import com.device42.atlas.common.util.ObjectUtils;

public class V29_31UpgradeExecutor
extends AbstractUpgradeExecutor {
    Logger.Log log = Logger.getInstance(V29_31UpgradeExecutor.class);
    public static final String DEVICE42_JOB_STATISTICS_KEY = "DEVICE42_JOB_STATISTICS";
    public static final String TOKEN_DISABLED_CONFIGURATION_ITEM_BASE = "configurationItemScanDisabled";
    public static final String TOKEN_CONTAINS_DISABLED_CONFIGURATION_ITEMS = "containsDisabledConfigurationItems";
    public static final String DEVICE42_SETTINGS_KEY = "DEVICE42_SETTINGS";

    public V29_31UpgradeExecutor(D42PluginUpgradeTask upgradeTask) {
        super(upgradeTask);
    }

    private void importDefaultSchema(D42DataManager dataManager) {
        this.log.info((Object)"Creating the default schema if absent");
        Schema schema = dataManager.getSchema();
        if (schema.isEmpty()) {
            try {
                dataManager.importDefaultSchema(true);
                this.log.info((Object)"Creating schema routine completed");
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to create the schema");
            }
        }
    }

    private void updateCollectability(D42DataManager dataManager) {
        boolean containsDisabledItems = false;
        Schema schema = dataManager.getSchema();
        PluginSettings pluginSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(DEVICE42_SETTINGS_KEY);
        PluginSettingsDonor pluginSettingsDonor = new PluginSettingsDonor(pluginSettings);
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(pluginSettings, new String[0]);
        for (ConfigurationItemType configurationItemType : schema) {
            boolean ciDisabled = ObjectUtils.booleanValue(pluginSettingsDonor.get(TOKEN_DISABLED_CONFIGURATION_ITEM_BASE + configurationItemType.getKey()), false);
            configurationItemType.setCollectable(!ciDisabled);
            containsDisabledItems |= ciDisabled;
        }
        if (containsDisabledItems) {
            try {
                dataManager.importSchema(schema);
                for (ConfigurationItemType configurationItemType : schema) {
                    pluginSettingsAcceptor.removeParameter(TOKEN_DISABLED_CONFIGURATION_ITEM_BASE + configurationItemType.getKey());
                }
                pluginSettingsAcceptor.removeParameter(TOKEN_CONTAINS_DISABLED_CONFIGURATION_ITEMS);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to update configuration item types collectability");
            }
        }
    }

    private void fixScanStatistics(D42DataManager dataManager) {
        PluginSettings pluginSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(DEVICE42_JOB_STATISTICS_KEY);
        PluginSettingsDonor pluginSettingsDonor = new PluginSettingsDonor(pluginSettings);
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(pluginSettings, new String[0]);
        for (_ConfigurationItemType oldConfigurationItemType : _ConfigurationItemType.values()) {
            ConfigurationItemType statisticsType = new ConfigurationItemType();
            statisticsType.setKey(oldConfigurationItemType.toString());
            ConfigurationItemCollectionStatistics collectionStatistics = new ConfigurationItemCollectionStatistics(statisticsType, pluginSettingsDonor);
            collectionStatistics.clear(pluginSettingsAcceptor);
            statisticsType.setKey(oldConfigurationItemType.getKey());
            collectionStatistics.saveToAcceptor(pluginSettingsAcceptor);
        }
    }

    @Override
    public void execute() {
        this.log.info((Object)"Upgrading to version 3.1");
        D42DataManager dataManager = this.upgradeTask.getDataManager();
        this.importDefaultSchema(dataManager);
        this.updateCollectability(dataManager);
        this.fixScanStatistics(dataManager);
        this.log.info((Object)"Upgrade to version 3.1 completed");
    }
}

