/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v26;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.job.upgrade.v26.DeviceAO;
import com.device42.atlas.common.job.upgrade.v26.DeviceTag;
import com.device42.atlas.common.job.upgrade.v26.PartAO;
import com.device42.atlas.common.job.upgrade.v26.PduAO;
import com.device42.atlas.common.job.upgrade.v26.RackAO;
import com.device42.atlas.common.job.upgrade.v26.TagAO;
import com.device42.atlas.common.job.upgrade.v30.ConfigurationItemAO;
import com.device42.atlas.common.job.upgrade.v30.ParameterAO;
import com.device42.atlas.common.job.upgrade.v30._ConfigurationItemType;
import com.device42.atlas.common.job.upgrade.v30._ParameterType;
import com.device42.atlas.common.model.core.ConfigurationItemState;
import net.java.ao.DBParam;
import org.apache.commons.lang.StringUtils;

public class Device42ActiveObjectsUpgradeTask
implements ActiveObjectsUpgradeTask {
    public static Logger.Log log = Logger.getInstance(Device42ActiveObjectsUpgradeTask.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"26");
    }

    private ParameterAO addSimpleParameter(ActiveObjects ao, ConfigurationItemAO ci, _ParameterType parameterType, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return (ParameterAO)ao.create(ParameterAO.class, new DBParam[]{new DBParam("CONF_ITEM_ID", (Object)ci), new DBParam("TYPE", (Object)parameterType), new DBParam("VALUE", (Object)value), new DBParam("LOWERCASE_VALUE", (Object)value.toLowerCase())});
        }
        return null;
    }

    private ConfigurationItemAO createCI(ActiveObjects ao, _ConfigurationItemType ciType, String status, long storageId) {
        ConfigurationItemState state = "A".equals(status) ? ConfigurationItemState.ACTIVE : ConfigurationItemState.DISABLED;
        return (ConfigurationItemAO)ao.create(ConfigurationItemAO.class, new DBParam[]{new DBParam("TYPE", (Object)ciType), new DBParam("STORAGE_ID", (Object)storageId), new DBParam("ACTIVITY_STATE", (Object)state)});
    }

    private void upgradeDevices(ActiveObjects ao) {
        log.info((Object)"Moving devices");
        DeviceAO[] oldDevices = (DeviceAO[])ao.find(DeviceAO.class);
        if (oldDevices != null) {
            for (DeviceAO oldDevice : oldDevices) {
                if (oldDevice.getDeviceId() == null) continue;
                ConfigurationItemAO ci = this.createCI(ao, _ConfigurationItemType.DEVICE, oldDevice.getStatus(), oldDevice.getDeviceId());
                this.addSimpleParameter(ao, ci, _ParameterType.ASSET_NO, oldDevice.getAssetNo());
                this.addSimpleParameter(ao, ci, _ParameterType.BUILDING, oldDevice.getBuilding());
                this.addSimpleParameter(ao, ci, _ParameterType.CUSTOMER, oldDevice.getCustomer());
                this.addSimpleParameter(ao, ci, _ParameterType.HARDWARE_MODEL, oldDevice.getHardwareModel());
                this.addSimpleParameter(ao, ci, _ParameterType.IN_SERVICE, Boolean.toString(oldDevice.isInService()));
                this.addSimpleParameter(ao, ci, _ParameterType.MANUFACTURER, oldDevice.getManufacturer());
                this.addSimpleParameter(ao, ci, _ParameterType.NAME, oldDevice.getName());
                this.addSimpleParameter(ao, ci, _ParameterType.RACK, oldDevice.getRack());
                this.addSimpleParameter(ao, ci, _ParameterType.ROOM, oldDevice.getRoom());
                this.addSimpleParameter(ao, ci, _ParameterType.SERIAL_NO, oldDevice.getSerialNo());
                this.addSimpleParameter(ao, ci, _ParameterType.SERVICE_LEVEL, oldDevice.getServiceLevel());
                this.addSimpleParameter(ao, ci, _ParameterType.TYPE, oldDevice.getType());
                this.addSimpleParameter(ao, ci, _ParameterType.UUID, oldDevice.getUuid());
                this.addSimpleParameter(ao, ci, _ParameterType.VIRTUAL_HOST_NAME, oldDevice.getVirtualHostName());
                TagAO[] tags = oldDevice.getTags();
                if (tags == null) continue;
                for (TagAO tag : tags) {
                    this.addSimpleParameter(ao, ci, _ParameterType.TAG, tag.getTagName());
                }
            }
        }
        log.info((Object)"Devices moved");
    }

    private void upgradeRacks(ActiveObjects ao) {
        log.info((Object)"Moving racks");
        RackAO[] oldRacks = (RackAO[])ao.find(RackAO.class);
        if (oldRacks != null) {
            for (RackAO oldRack : oldRacks) {
                if (oldRack.getRackId() == null) continue;
                ConfigurationItemAO ci = this.createCI(ao, _ConfigurationItemType.RACK, oldRack.getStatus(), oldRack.getRackId());
                this.addSimpleParameter(ao, ci, _ParameterType.BUILDING, oldRack.getBuilding());
                this.addSimpleParameter(ao, ci, _ParameterType.NAME, oldRack.getName());
                this.addSimpleParameter(ao, ci, _ParameterType.ROOM, oldRack.getRoom());
            }
        }
        log.info((Object)"Racks moved");
    }

    private void upgradePdus(ActiveObjects ao) {
        log.info((Object)"Move PDUs");
        PduAO[] oldPdus = (PduAO[])ao.find(PduAO.class);
        if (oldPdus != null) {
            for (PduAO oldPdu : oldPdus) {
                if (oldPdu.getPduId() == null) continue;
                ConfigurationItemAO ci = this.createCI(ao, _ConfigurationItemType.PDU, oldPdu.getStatus(), oldPdu.getPduId());
                this.addSimpleParameter(ao, ci, _ParameterType.NAME, oldPdu.getName());
                this.addSimpleParameter(ao, ci, _ParameterType.NOTES, oldPdu.getNotes());
            }
        }
        log.info((Object)"PDUs moved");
    }

    private void upgradeParts(ActiveObjects ao) {
        log.info((Object)"Move parts");
        PartAO[] oldParts = (PartAO[])ao.find(PartAO.class);
        if (oldParts != null) {
            for (PartAO oldPart : oldParts) {
                if (oldPart.getPartId() == null) continue;
                ConfigurationItemAO ci = this.createCI(ao, _ConfigurationItemType.PART, oldPart.getStatus(), oldPart.getPartId());
                if (oldPart.getPartCount() != null) {
                    this.addSimpleParameter(ao, ci, _ParameterType.COUNT, oldPart.getPartCount().toString());
                }
                this.addSimpleParameter(ao, ci, _ParameterType.ASSIGNMENT, oldPart.getAssignment());
                this.addSimpleParameter(ao, ci, _ParameterType.DESCRIPTION, oldPart.getDescription());
                this.addSimpleParameter(ao, ci, _ParameterType.SERIAL_NO, oldPart.getSerialNo());
                ConfigurationItemAO partModelCI = this.createCI(ao, _ConfigurationItemType.PART_MODEL, "D", 0L);
                this.addSimpleParameter(ao, partModelCI, _ParameterType.NAME, oldPart.getModelName());
                this.addSimpleParameter(ao, partModelCI, _ParameterType.TYPE, oldPart.getModelType());
                ao.create(ParameterAO.class, new DBParam[]{new DBParam("CONF_ITEM_ID", (Object)ci), new DBParam("TYPE", (Object)_ParameterType.PART_MODEL), new DBParam("PARAMETER_CONF_ITEM_ID", (Object)partModelCI)});
            }
        }
        log.info((Object)"Parts moved");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        log.info((Object)"Device42 schema is starting to upgrade to 26 version");
        ao.migrate(new Class[]{DeviceAO.class, RackAO.class, PduAO.class, PartAO.class, DeviceTag.class, TagAO.class, ConfigurationItemAO.class, ParameterAO.class});
        this.upgradeDevices(ao);
        this.upgradeRacks(ao);
        this.upgradePdus(ao);
        this.upgradeParts(ao);
        log.info((Object)"Device42 schema was upgraded to 26 version successfully");
    }
}

