/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import java.util.Collection;
import java.util.List;

public abstract class D42PluginUpgradeTask
implements PluginUpgradeTask {
    protected final D42SettingsManager settingsManager;
    protected final PluginSettingsFactory pluginSettingsFactory;
    protected final D42DataManager dataManager;

    public D42PluginUpgradeTask(D42SettingsManager settingsManager, PluginSettingsFactory pluginSettingsFactory, D42DataManager dataManager) {
        this.settingsManager = settingsManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.dataManager = dataManager;
    }

    public int getBuildNumber() {
        return 37;
    }

    protected abstract List<AbstractUpgradeExecutor> getExecutors();

    public Collection<Message> doUpgrade() throws Exception {
        List<AbstractUpgradeExecutor> executors = this.getExecutors();
        for (AbstractUpgradeExecutor executor : executors) {
            executor.execute();
        }
        return null;
    }

    public String getShortDescription() {
        return "Upgrade task for the D42 plugin for JIRA or Confluence";
    }

    public D42SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public D42DataManager getDataManager() {
        return this.dataManager;
    }
}

