/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.manager;

import com.atlassian.confluence.schedule.ExecutionStatus;
import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.ScheduledJobStatus;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.spring.container.ContainerManager;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42DataUpdaterMonitor;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.util.D42Exception;
import java.lang.reflect.Method;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;

public class D42ConfluenceDataUpdaterMonitorImpl
implements D42DataUpdaterMonitor {
    private static final String GROUP_NAME = "com.device42.atlas.confluence.d42confluence";
    private static final Logger.Log log = Logger.getInstance(D42ConfluenceDataUpdaterMonitorImpl.class);
    private final D42SettingsManager d42SettingsManager;
    private ScheduledJobManager scheduledJobManager;
    private final D42JobStatisticsManager jobStatisticsManager;
    private final D42DataManager dataManager;

    public D42ConfluenceDataUpdaterMonitorImpl(D42SettingsManager d42SettingsManager, D42JobStatisticsManager jobStatisticsManager, D42DataManager dataManager) {
        this.d42SettingsManager = d42SettingsManager;
        this.jobStatisticsManager = jobStatisticsManager;
        this.dataManager = dataManager;
    }

    @Override
    public Date getNextFireDate() throws D42Exception {
        String cron = this.d42SettingsManager.getCron();
        ScheduledJobKey jobKey = new ScheduledJobKey(GROUP_NAME, "d42defaultjob");
        ScheduledJobStatus status = this.getScheduledJobManager().getScheduledJob(jobKey);
        String jobCron = null;
        if (status != null && status.isEnabled()) {
            jobCron = this.getScheduledJobManager().getCronExpression(jobKey);
            if (jobCron != null && !jobCron.equals(cron)) {
                this.d42SettingsManager.setCron(jobCron);
            }
            if (jobCron == null) {
                this.d42SettingsManager.setCron(null);
            }
            return status.getNextExecution();
        }
        if (!StringUtils.isBlank((String)cron)) {
            this.d42SettingsManager.setCron(null);
        }
        return null;
    }

    @Override
    public boolean validateCronExpression(String cron) {
        return CronExpression.isValidExpression((String)cron);
    }

    private void updateSchedule(ScheduledJobKey key, String cron) throws ReflectiveOperationException {
        ScheduledJobManager schedulerObject = this.getScheduledJobManager();
        Method updateMethod = null;
        try {
            updateMethod = ScheduledJobManager.class.getMethod("updateSchedule", ScheduledJobKey.class, String.class);
        }
        catch (NoSuchMethodException e) {
            updateMethod = ScheduledJobManager.class.getMethod("updateCronJobSchedule", ScheduledJobKey.class, String.class);
        }
        updateMethod.invoke((Object)schedulerObject, key, cron);
    }

    @Override
    public void reSchedule() throws D42Exception {
        String cron = this.d42SettingsManager.getCron();
        ScheduledJobKey jobKey = new ScheduledJobKey(GROUP_NAME, "d42defaultjob");
        try {
            if (StringUtils.isBlank((String)cron)) {
                this.getScheduledJobManager().disable(jobKey);
                return;
            }
            this.updateSchedule(jobKey, cron);
            this.getScheduledJobManager().enable(jobKey);
        }
        catch (Exception e) {
            log.error((Object)"reSchedule error ", (Throwable)e);
            throw new D42Exception("reSchedule error", e);
        }
    }

    public ScheduledJobManager getScheduledJobManager() {
        Object scheduledJobManagerObject;
        if (this.scheduledJobManager == null && (scheduledJobManagerObject = ContainerManager.getComponent((String)"scheduledJobManager")) instanceof ScheduledJobManager) {
            this.scheduledJobManager = (ScheduledJobManager)scheduledJobManagerObject;
        }
        return this.scheduledJobManager;
    }

    @Override
    public boolean runOnce(boolean forceRun, boolean fullRescan) throws D42Exception {
        ScheduledJobKey jobKey = new ScheduledJobKey(GROUP_NAME, "d42defaultjob");
        if (!forceRun && (ExecutionStatus.RUNNING.equals((Object)this.getScheduledJobManager().getScheduledJob(jobKey).getStatus()) || ExecutionStatus.DISABLED_MANUALLY_RUNNING.equals((Object)this.getScheduledJobManager().getScheduledJob(jobKey).getStatus()))) {
            return false;
        }
        if (fullRescan) {
            Schema schema = this.dataManager.getCollectableSchema();
            for (ConfigurationItemType configurationItemType : schema) {
                this.jobStatisticsManager.setLastUpdatedTime(null, configurationItemType, null);
            }
        }
        this.jobStatisticsManager.setPendingManually(true);
        this.getScheduledJobManager().runNow(jobKey);
        return true;
    }

    @Override
    public boolean abortCurrentJob() {
        this.jobStatisticsManager.setPendingManually(false);
        return this.jobStatisticsManager.abortCurrentJob();
    }
}

