/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtils {
    private static final String HEX = "0123456789ABCDEF";

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt(b >> 4 & 0xF)).append(HEX.charAt(b & 0xF));
    }

    private static byte[] decrypt(byte[] raw, byte[] encrypted) throws GeneralSecurityException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    public static String decrypt(String seed, String encrypted) throws GeneralSecurityException {
        byte[] rawKey = CryptUtils.getRawKey(seed.getBytes());
        byte[] enc = CryptUtils.toByte(encrypted);
        byte[] result = CryptUtils.decrypt(rawKey, enc);
        return new String(result);
    }

    public static String defaultDecrypt(String encrypted) throws GeneralSecurityException {
        return CryptUtils.decrypt(CryptUtils.getDefaultSeed(), encrypted);
    }

    public static String defaultEncrypt(String cleartext) throws GeneralSecurityException {
        return CryptUtils.encrypt(CryptUtils.getDefaultSeed(), cleartext);
    }

    private static byte[] encrypt(byte[] raw, byte[] clear) throws GeneralSecurityException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    public static String encrypt(String seed, String cleartext) throws GeneralSecurityException {
        byte[] rawKey = CryptUtils.getRawKey(seed.getBytes());
        byte[] result = CryptUtils.encrypt(rawKey, cleartext.getBytes());
        return CryptUtils.toHex(result);
    }

    public static String fromHex(String hex) {
        return new String(CryptUtils.toByte(hex));
    }

    private static String getDefaultSeed() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(20, 11, 4, 45, 23, 12);
        calendar.set(14, 0);
        return Long.toString(calendar.getTimeInMillis());
    }

    private static byte[] getRawKey(byte[] seed) throws GeneralSecurityException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return raw;
    }

    public static byte[] toByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }

    public static String toHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            CryptUtils.appendHex(result, buf[i]);
        }
        return result.toString();
    }

    public static String toHex(String txt) {
        return CryptUtils.toHex(txt.getBytes());
    }

    private CryptUtils() {
    }
}

