/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.device42.atlas.common.manager.ServletProcessor;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.servlet.AbstractActionServlet;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractProcessorServlet
extends AbstractActionServlet {
    private static final long serialVersionUID = -6449866504756622134L;
    private final ServletProcessor servletProcessor;

    public AbstractProcessorServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ApplicationProperties applicationProperties, XsrfTokenValidator tokenValidator, XsrfTokenAccessor tokenAccessor, ServletProcessor servletProcessor) {
        super(userManager, loginUriProvider, renderer, applicationProperties, tokenValidator, tokenAccessor);
        this.servletProcessor = servletProcessor;
    }

    @Override
    protected List<String> getActions() {
        return Arrays.asList(this.servletProcessor.getActions());
    }

    @Override
    protected AbstractActionServlet.ActionResultType getActionResultType(String actionName) {
        if (this.servletProcessor.isJson(actionName)) {
            return AbstractActionServlet.ActionResultType.JSON;
        }
        return AbstractActionServlet.ActionResultType.HTML;
    }

    @Override
    protected AbstractActionServlet.ActionRequestMethodType getActionRequestMethodType(String actionName) {
        if (this.servletProcessor.isPostActionOnly(actionName)) {
            return AbstractActionServlet.ActionRequestMethodType.POST;
        }
        return AbstractActionServlet.ActionRequestMethodType.ALL;
    }

    @Override
    protected String executeAction(String action, Map<String, String[]> parameters, @Nonnull ErrorHolder velocityOutputParameters) {
        Map<String, String> flatParameters = ObjectUtils.flatten(parameters);
        return this.servletProcessor.processRequestServletAction(action, flatParameters, velocityOutputParameters);
    }
}

