/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.servlet;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.JsonParameters;
import com.device42.atlas.common.model.serialization.VelocityParameters;
import com.device42.atlas.common.servlet.ServletContextHelper;
import com.device42.atlas.common.util.ObjectUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractActionServlet
extends HttpServlet {
    private static final Logger.Log log = Logger.getInstance(AbstractActionServlet.class);
    protected static final String DEFAULT_ACTION = "default";
    protected static final String EXPORT_ACTION = "export";
    protected static final String TOKEN_ACTION = "action";
    protected static final String TOKEN_REQUEST_PARAMETER = "requestParameter";
    protected static final String TOKEN_NO_DEFAULT_PARAMETER = "noDefaults";
    protected static final String TOKEN_FORMAT_JSON = "formatJson";
    protected static final String TOKEN_DOWNLOAD_PARAMETER = "download";
    private static final String TOKEN_INLINE_DIALOG = "inline";
    private static final String TOKEN_DIALOG_CLOSED_HEADER = "X-Atlassian-Dialog-Control";
    private static final String TOKEN_DIALOG_CLOSED_REDIRECT = "redirect:";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final XsrfTokenValidator tokenValidator;
    private final XsrfTokenAccessor tokenAccessor;
    private static final long serialVersionUID = 8816564603386931929L;

    public AbstractActionServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, ApplicationProperties applicationProperties, XsrfTokenValidator tokenValidator, XsrfTokenAccessor tokenAccessor) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.tokenValidator = tokenValidator;
        this.tokenAccessor = tokenAccessor;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp, ActionRequestMethodType.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.tokenValidator.validateFormEncodedToken(req)) {
            this.doService(req, resp, ActionRequestMethodType.POST);
        } else {
            resp.sendError(412, "XSRF check failed");
        }
    }

    private boolean hasValue(String[] parameterValues, String checkedValue) {
        return parameterValues != null && Arrays.asList(parameterValues).indexOf(checkedValue) > -1;
    }

    private void doService(HttpServletRequest req, HttpServletResponse resp, ActionRequestMethodType requestType) throws ServletException, IOException {
        Collection parts;
        if (!this.checkPermissions(req)) {
            resp.sendError(401);
            return;
        }
        String actionName = req.getParameter(TOKEN_ACTION);
        if (StringUtils.isEmpty((String)actionName)) {
            actionName = DEFAULT_ACTION;
        }
        if (!this.getActionsWithDefault().contains(actionName)) {
            resp.sendError(501);
            return;
        }
        ActionRequestMethodType allowedRequestType = this.getActionRequestMethodTypeWithDefault(actionName);
        if (allowedRequestType != requestType && allowedRequestType != ActionRequestMethodType.ALL) {
            resp.sendError(501);
            return;
        }
        String[] additionalParameters = req.getParameterValues(TOKEN_REQUEST_PARAMETER);
        boolean noDefaultParameters = this.hasValue(additionalParameters, TOKEN_NO_DEFAULT_PARAMETER);
        if (req.getContentType() != null && req.getContentType().toLowerCase().indexOf("multipart/form-data") > -1 && (parts = req.getParts()) != null) {
            for (Part part : parts) {
                log.error((Object)("Content part: " + part.getContentType()));
                for (String headerName : part.getHeaderNames()) {
                    log.error((Object)("header " + headerName + " = " + part.getHeader(headerName)));
                }
                log.error((Object)("Name: " + part.getName()));
                byte[] byteContent = new byte[(int)part.getSize()];
                part.getInputStream().read(byteContent);
                String content = new String(byteContent);
                log.error((Object)("Content: " + content));
            }
        }
        ActionResultType resultType = this.getActionResultTypeWithDefault(actionName);
        switch (resultType) {
            case HTML: {
                String velocityKey;
                VelocityParameters velocityParameters = new VelocityParameters();
                if (!noDefaultParameters) {
                    this.addDefaultParameters(velocityParameters, req, resp);
                }
                if ((velocityKey = this.executeAction(actionName, req.getParameterMap(), velocityParameters)) == null) {
                    if (ObjectUtils.booleanValue(req.getParameter(TOKEN_INLINE_DIALOG), false)) {
                        resp.addHeader(TOKEN_DIALOG_CLOSED_HEADER, TOKEN_DIALOG_CLOSED_REDIRECT + req.getContextPath() + this.getDefaultRedirect());
                        resp.setStatus(204);
                        break;
                    }
                    resp.sendRedirect(req.getContextPath() + this.getDefaultRedirect());
                    break;
                }
                this.renderer.render(velocityKey, velocityParameters.getParameters(), (Writer)resp.getWriter());
                resp.setContentType("text/html;charset=utf-8");
                resp.getWriter().close();
                break;
            }
            case JSON: {
                JsonParameters jsonParameters = new JsonParameters();
                if (!noDefaultParameters) {
                    this.addDefaultParameters(jsonParameters, req, resp);
                }
                String jsonFileName = this.executeAction(actionName, req.getParameterMap(), jsonParameters);
                boolean saveToFile = this.hasValue(additionalParameters, TOKEN_DOWNLOAD_PARAMETER);
                boolean formatJson = this.hasValue(additionalParameters, TOKEN_FORMAT_JSON);
                if (saveToFile) {
                    resp.setContentType("application/octet-stream");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + jsonFileName + "\"");
                } else {
                    resp.setContentType("application/json;charset=utf-8");
                }
                String jsonString = null;
                if (formatJson) {
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    jsonString = gson.toJson(jsonParameters.getJsonObject());
                } else {
                    jsonString = jsonParameters.getJsonObject().toString();
                }
                resp.getWriter().write(jsonString);
                resp.getWriter().close();
            }
        }
    }

    private void addDefaultParameters(ErrorHolder output, HttpServletRequest req, HttpServletResponse resp) {
        ServletContextHelper.addDefaultParameters(this.tokenAccessor, this.tokenValidator, this.applicationProperties, output, this.getDefaultRedirect(), req, resp);
    }

    protected abstract String executeAction(String var1, Map<String, String[]> var2, ErrorHolder var3);

    private ActionResultType getActionResultTypeWithDefault(String actionName) {
        if (DEFAULT_ACTION.equals(actionName)) {
            return ActionResultType.HTML;
        }
        return this.getActionResultType(actionName);
    }

    private ActionRequestMethodType getActionRequestMethodTypeWithDefault(String actionName) {
        if (DEFAULT_ACTION.equals(actionName)) {
            return ActionRequestMethodType.ALL;
        }
        return this.getActionRequestMethodType(actionName);
    }

    private List<String> getActionsWithDefault() {
        ArrayList<String> allActions = new ArrayList<String>(this.getActions());
        allActions.add(DEFAULT_ACTION);
        return allActions;
    }

    protected boolean checkPermissions(HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        return userKey != null && this.userManager.isSystemAdmin(userKey) || userKey != null && request.getParameter(TOKEN_ACTION) != null && request.getServletPath().equals("/plugins/servlet/d42/configurationadmin") && request.getParameter(TOKEN_ACTION).equals("getSchemaAndData") || userKey != null && request.getParameter(TOKEN_ACTION) != null && request.getServletPath().equals("/plugins/servlet/d42/filteradmin") && (request.getParameter(TOKEN_ACTION).equals("getFieldFilter") || request.getParameter(TOKEN_ACTION).equals("saveConfig") || request.getParameter(TOKEN_ACTION).equals("resetConfig"));
    }

    protected abstract List<String> getActions();

    protected abstract ActionResultType getActionResultType(String var1);

    protected abstract ActionRequestMethodType getActionRequestMethodType(String var1);

    protected abstract String getDefaultRedirect();

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    protected static enum ActionRequestMethodType {
        ALL,
        GET,
        POST;

    }

    protected static enum ActionResultType {
        HTML,
        JSON;

    }
}

