/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.service;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42DataHelper;
import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.service.D42AbstractRestService;
import com.device42.atlas.common.service.RestItem;
import com.device42.atlas.common.service.RestList;
import com.device42.atlas.common.util.JsonUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="d42Options")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class D42FieldRestService
extends D42AbstractRestService {
    private final D42DataManager d42DataManager;
    private final D42SettingsManager d42SettingsManager;
    private final I18nResolver i18n;
    private static final Logger.Log log = Logger.getInstance(D42FieldRestService.class);

    public D42FieldRestService(D42DataManager d42DataManager, D42SettingsManager d42SettingsManager, I18nResolver i18n) {
        this.d42DataManager = d42DataManager;
        this.d42SettingsManager = d42SettingsManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="options")
    public Response getOptions(@QueryParam(value="firstLevelId") Long firstLevelId, @QueryParam(value="secondLevelId") Long secondLevelId, @QueryParam(value="term") String term, @QueryParam(value="offset") Integer offset, @QueryParam(value="type") String type, @Context HttpServletRequest request) {
        try {
            if (request.getAttribute("D42UserName") == null) {
                return this.buildUnauthorizedResponse();
            }
            D42DataHelper.D42DataHelperBuilder helperBuilder = D42DataHelper.create(this.d42DataManager, this.d42SettingsManager, this.i18n).filterInfo(firstLevelId, secondLevelId);
            String value = type + 0L;
            helperBuilder.value(value);
            if (offset == null) {
                offset = 0;
            }
            RestList restList = helperBuilder.build().getRestConfigurationItems(term, offset);
            return this.prepareOkResponseBody(restList);
        }
        catch (Exception e) {
            log.error((Object)("Could not collect options: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="types")
    public Response getTypes(@QueryParam(value="firstLevelId") Long firstLevelId, @QueryParam(value="secondLevelId") Long secondLevelId, @Context HttpServletRequest request) {
        if (request.getAttribute("D42UserName") == null) {
            return this.buildUnauthorizedResponse();
        }
        D42DataHelper.D42DataHelperBuilder helperBuilder = D42DataHelper.create(this.d42DataManager, this.d42SettingsManager, this.i18n).filterInfo(firstLevelId, secondLevelId);
        try {
            RestList restList = helperBuilder.build().getRestTypes();
            return this.prepareOkResponseBody(restList);
        }
        catch (Exception e) {
            log.error((Object)("Could not collect types: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="valueDetails")
    public Response getValueDetails(@QueryParam(value="value") String value, @Context HttpServletRequest request) {
        if (request.getAttribute("D42UserName") == null) {
            return this.buildUnauthorizedResponse();
        }
        try {
            D42DataHelper.D42DataHelperBuilder helperBuilder = D42DataHelper.create(this.d42DataManager, this.d42SettingsManager, this.i18n).filterInfo(0L, 0L).value(value);
            RestList restList = helperBuilder.build().getRestValueDetails();
            return this.prepareOkResponseBody(restList);
        }
        catch (Exception e) {
            log.error((Object)("Could not collect value details: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="filters")
    public Response getFilters(@QueryParam(value="firstLevelId") Long firstLevelId, @Context HttpServletRequest request) {
        if (request.getAttribute("D42UserName") == null) {
            return this.buildUnauthorizedResponse();
        }
        try {
            List<Filter> filters = this.d42DataManager.getFirstLevelFilters(firstLevelId);
            RestList restList = new RestList();
            for (Filter filter : filters) {
                RestItem restItem = new RestItem(filter.getSecondLevelId(), filter.getName());
                restList.addOption(restItem);
            }
            return this.prepareOkResponseBody(restList);
        }
        catch (Exception e) {
            log.error((Object)("Could not collect filters: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="getDeviceIdByName")
    public Response getDeviceIdByName(@QueryParam(value="name") String name, @Context HttpServletRequest request) {
        if (request.getAttribute("D42UserName") == null) {
            return this.buildUnauthorizedResponse();
        }
        RestList fieldOptItems = new RestList();
        return this.prepareOkResponseBody(fieldOptItems);
    }

    @POST
    @Path(value="search")
    public Response search(String body, @Context HttpServletRequest request) {
        if (request.getAttribute("D42UserName") == null) {
            return this.buildUnauthorizedResponse();
        }
        try {
            MapDonor mapDonor = JsonUtil.jsonStringToMapDonor(body);
            String key = (String)mapDonor.get("type");
            Integer offset = Integer.valueOf((String)mapDonor.get("offset"));
            ConfigurationItemType ciType = this.d42DataManager.getConfigurationItemTypeByKey(key);
            ConfigurationItemFilter ciFilter = new ConfigurationItemFilter(ciType);
            ciFilter.loadFromDonor(mapDonor);
            D42DataHelper.D42DataHelperBuilder helperBuilder = D42DataHelper.create(this.d42DataManager, this.d42SettingsManager, this.i18n).searchFilter(ciFilter);
            RestList restList = helperBuilder.build().getRestConfigurationItems(null, offset);
            return this.prepareOkResponseBody(restList);
        }
        catch (Exception e) {
            log.error((Object)("Could not search: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @GET
    @Path(value="hasLoggedInUser")
    public Response hasLoggedInUser(@Context HttpServletRequest request) {
        RestList fieldOptItems = new RestList();
        String result = "false";
        if (request.getAttribute("D42UserName") != null) {
            result = "true";
        }
        fieldOptItems.addOption(new RestItem("result", result));
        return this.prepareOkResponseBody(fieldOptItems);
    }
}

