/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.remote;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.ConfigurationItemParameter;
import com.device42.atlas.common.model.core.MultiConfigurationItemParameter;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.SimpleParameter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.MultiReferenceParameterType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.ReferenceParameterType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.util.JsonUtil;
import com.device42.atlas.common.util.ObjectUtils;
import com.device42.atlas.common.util.PartialCIList;
import com.device42.atlas.common.util.ValuesHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;

public class Device42ResponseParser {
    private static final Logger.Log log = Logger.getInstance(Device42ResponseParser.class);
    private static final String IP_REQUEST_TAG = "ip";
    private static final String MESSAGE_TAG = "msg";
    private static final int MAX_VALUE_LENGTH = 200;
    private static final String DETAIL_TAG = "detail";
    private final Schema schema;

    public Device42ResponseParser(Schema schema) {
        this.schema = schema;
    }

    public static String parseError(JsonElement jsonElement) throws JsonParseException {
        try {
            JsonObject json = jsonElement.getAsJsonObject();
            String message = JsonUtil.extractString(json, MESSAGE_TAG);
            if (StringUtils.isBlank((String)message)) {
                message = JsonUtil.extractString(json, DETAIL_TAG);
            }
            return message;
        }
        catch (Exception e) {
            throw new JsonParseException("Error parse failed", e);
        }
    }

    public static String parseIpRequest(JsonElement jsonElement) throws JsonParseException {
        try {
            JsonObject json = jsonElement.getAsJsonObject();
            String ip = JsonUtil.extractString(json, IP_REQUEST_TAG);
            return ip;
        }
        catch (Exception e) {
            throw new JsonParseException("Error parse failed", e);
        }
    }

    public PartialCIList parseList(String configurationItemTypeKey, CSVParser parser) {
        PartialCIList result = new PartialCIList();
        ConfigurationItemType configurationItemType = this.schema.getByKey(configurationItemTypeKey);
        int row = 0;
        for (CSVRecord record : parser) {
            if (row == 0) {
                log.debug((Object)("Header: " + record));
            } else {
                try {
                    ConfigurationItem configurationItem = this.parseItem(configurationItemType, record);
                    if (configurationItem != null) {
                        result.add(configurationItem);
                        if (configurationItemType.hasLastUpdated()) {
                            Date date = configurationItem.getLastUpdatedDate();
                            date.setSeconds(date.getSeconds() + 1);
                            result.setLastUpdated(date);
                        }
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Failed to parse the csv row " + record.toString() + " for the CI type with key" + configurationItemTypeKey), (Throwable)ex);
                }
            }
            ++row;
        }
        return result;
    }

    public ConfigurationItem parseItem(ConfigurationItemType configurationItemType, CSVRecord record) throws UnsupportedEncodingException {
        ConfigurationItem result = new ConfigurationItem(configurationItemType);
        long idIndex = ObjectUtils.longValue(record.get(configurationItemType.getIdIndex()));
        if (idIndex > 0L) {
            result.setStorageId(idIndex);
            for (ParameterType parameterType : configurationItemType.getParameterTypes()) {
                Parameter parameter = this.parseParameter(record, parameterType);
                result.addParameter(parameter);
            }
            return result;
        }
        return null;
    }

    private Parameter parseParameter(CSVRecord record, ParameterType parameterType) throws UnsupportedEncodingException {
        Parameter result = null;
        if (parameterType instanceof SimpleParameterType) {
            result = this.parseSimpleParameter(record, (SimpleParameterType)parameterType);
        } else if (parameterType instanceof ReferenceParameterType) {
            if (parameterType.isEnabled()) {
                result = this.parseReferenceParameter(record, (ReferenceParameterType)parameterType);
            }
        } else if (parameterType instanceof MultiReferenceParameterType && parameterType.isEnabled()) {
            result = this.parseMultiReferenceParameter(record, (MultiReferenceParameterType)parameterType);
        }
        return result;
    }

    private SimpleParameter parseSimpleParameter(CSVRecord record, SimpleParameterType parameterType) throws UnsupportedEncodingException {
        SimpleParameter simpleParameter = null;
        String value = new String(record.get(parameterType.getCollectionIndex()).getBytes(Charset.forName("ISO-8859-1")), "UTF-8");
        if (StringUtils.isNotBlank((String)value)) {
            if (value.length() > 200) {
                value = value.substring(0, 200);
            }
            simpleParameter = new SimpleParameter(parameterType);
            simpleParameter.setValue(parameterType.renderValue(value));
        }
        return simpleParameter;
    }

    private ConfigurationItemParameter parseReferenceParameter(CSVRecord record, ReferenceParameterType parameterType) {
        ConfigurationItemParameter ciParameter = null;
        String ciKey = parameterType.getConfigurationItemKey();
        long idIndex = ObjectUtils.longValue(record.get(parameterType.getIdIndex()));
        if (idIndex > 0L) {
            ConfigurationItemType referenceConfigurationItemType = this.schema.getByKey(ciKey);
            ConfigurationItem configurationItem = new ConfigurationItem(referenceConfigurationItemType);
            configurationItem.setStorageId(idIndex);
            ciParameter = new ConfigurationItemParameter(parameterType);
            ciParameter.setConfigurationItem(configurationItem);
            ciParameter.setValue(parameterType.renderCsvRow(record));
            return ciParameter;
        }
        log.debug((Object)("ciKey: " + ciKey));
        return null;
    }

    private MultiConfigurationItemParameter parseMultiReferenceParameter(CSVRecord record, MultiReferenceParameterType parameterType) {
        MultiConfigurationItemParameter result = new MultiConfigurationItemParameter(parameterType);
        String ciKey = parameterType.getConfigurationItemKey();
        try {
            result.setValue(record.get(parameterType.getIdsIndex()));
            List<Integer> ids = ValuesHelper.getIdsListFromString(record.get(parameterType.getIdsIndex()));
            if (ids != null && !ids.isEmpty()) {
                result.setValue(ids.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse multireference parameter with key: " + ciKey));
            return null;
        }
        log.debug((Object)("ciKey: " + ciKey));
        return result;
    }
}

