/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.serialization;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.CryptUtils;
import com.device42.atlas.common.util.ObjectUtils;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PluginSettingsAcceptor
implements ParameterAcceptor {
    Logger.Log log = Logger.getInstance(PluginSettingsAcceptor.class);
    private final String[] restrictedKeys;
    private final Set<String> cryptedKeys = new HashSet<String>();
    private final PluginSettings pluginSettings;

    public PluginSettingsAcceptor(PluginSettings pluginSettings, String ... restrictedKeys) {
        this.restrictedKeys = restrictedKeys;
        this.pluginSettings = pluginSettings;
    }

    public void addCryptedKey(String key) {
        this.cryptedKeys.add(key);
    }

    private boolean isRestricted(String key) {
        return this.restrictedKeys != null && Arrays.asList(this.restrictedKeys).contains(key);
    }

    @Override
    public void addParameter(String key, Object value) {
        if (!this.isRestricted(key)) {
            if (this.cryptedKeys.contains(key) && value != null) {
                try {
                    this.pluginSettings.put(key, (Object)CryptUtils.defaultEncrypt(ObjectUtils.stringValue(value)));
                }
                catch (GeneralSecurityException e) {
                    this.log.error((Object)("Could not encrypt the " + key), (Throwable)e);
                }
            } else {
                this.pluginSettings.put(key, (Object)ObjectUtils.stringValue(value));
            }
        }
    }

    @Override
    public void addParameters(ParameterDonor parameters) {
        if (parameters != null) {
            for (String key : parameters.keys()) {
                this.addParameter(key, parameters.get(key));
            }
        }
    }

    @Override
    public void removeParameter(String key) {
        if (!this.isRestricted(key)) {
            this.pluginSettings.remove(key);
        }
    }

    @Override
    public void addParameters(Parameterizable paramObject) {
        if (paramObject != null) {
            paramObject.saveToAcceptor(this);
        }
    }

    @Override
    public ParameterAcceptor generateChildAcceptorObject(String key) {
        return this;
    }
}

