/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class SimpleParameterType
extends ParameterType
implements Parameterizable {
    private static final Logger.Log log = Logger.getInstance(SimpleParameterType.class);
    public static final String TOKEN_PARAMETER_SIMPLE_VALUE_TYPE = "simpleValueType";
    public static final String TOKEN_PARAMETER_VIEW_FORMAT = "viewFormat";
    public static final String TOKEN_PARAMETER_COLLECTION_INDEX = "collectionIndex";
    private SimpleValueType simpleValueType;
    private String viewFormat;
    private String collectionIndexRaw;
    private int collectionIndex;

    public SimpleParameterType() {
        super(ParameterType.ParameterValueType.SIMPLE);
    }

    public SimpleValueType getSimpleValueType() {
        return this.simpleValueType;
    }

    public void setSimpleValueType(SimpleValueType simpleValueType) {
        this.simpleValueType = simpleValueType;
    }

    public String getViewFormat() {
        return this.viewFormat;
    }

    public void setParameterViewFormat(String viewFormat) {
        this.viewFormat = viewFormat;
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public void setCollectionIndex(int collectionIndex) {
        this.collectionIndex = collectionIndex;
    }

    public String renderValue(String value) {
        if (this.viewFormat != null) {
            switch (this.getSimpleValueType()) {
                case STRING: 
                case LONGSTRING: 
                case INTEGER: 
                case NUMERIC: {
                    return value;
                }
                case DATETIME: {
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(this.viewFormat);
                        Date date = dateFormat.parse(value);
                        return ObjectUtils.formatDate(date);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return value;
    }

    @Override
    public void validateAdditionalData(I18nResolver i18n, ErrorHolder errorHolder) {
        if (StringUtils.isBlank((String)this.collectionIndexRaw)) {
            errorHolder.addError(TOKEN_PARAMETER_COLLECTION_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.blank"));
        } else {
            try {
                Integer.parseInt(this.collectionIndexRaw);
                if (this.collectionIndex < 0) {
                    errorHolder.addError(TOKEN_PARAMETER_COLLECTION_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.negative"));
                }
            }
            catch (Exception e) {
                errorHolder.addError(TOKEN_PARAMETER_COLLECTION_INDEX, i18n.getText("com.device42.atlas.page.configuration.parameter.simple.collectionindex.error.format"));
            }
        }
    }

    @Override
    protected void addAdditionalParameters(ParameterAcceptor output) {
        output.addParameter(TOKEN_PARAMETER_SIMPLE_VALUE_TYPE, (Object)this.simpleValueType);
        output.addParameter(TOKEN_PARAMETER_VIEW_FORMAT, this.viewFormat);
        output.addParameter(TOKEN_PARAMETER_COLLECTION_INDEX, this.collectionIndex);
    }

    @Override
    protected void extractAdditionalParameters(ParameterDonor input) {
        this.simpleValueType = ObjectUtils.enumValue(input.get(TOKEN_PARAMETER_SIMPLE_VALUE_TYPE), SimpleValueType.class, SimpleValueType.STRING);
        this.viewFormat = ObjectUtils.stringValue(input.get(TOKEN_PARAMETER_VIEW_FORMAT));
        this.collectionIndex = ObjectUtils.intValue(input.get(TOKEN_PARAMETER_COLLECTION_INDEX));
        this.collectionIndexRaw = ObjectUtils.stringValue(input.get(TOKEN_PARAMETER_COLLECTION_INDEX));
    }

    @Override
    protected void cleanAdditionalParameters(ParameterAcceptor output) {
        output.removeParameter(TOKEN_PARAMETER_VIEW_FORMAT);
        output.removeParameter(TOKEN_PARAMETER_SIMPLE_VALUE_TYPE);
        output.removeParameter(TOKEN_PARAMETER_COLLECTION_INDEX);
    }

    public static enum SimpleValueType {
        STRING("com.device42.atlas.page.configuration.parameter.simple.type.string"),
        LONGSTRING("com.device42.atlas.page.configuration.parameter.simple.type.longstring"),
        INTEGER("com.device42.atlas.page.configuration.parameter.simple.type.integer"),
        NUMERIC("com.device42.atlas.page.configuration.parameter.simple.type.numeric"),
        DATETIME("com.device42.atlas.page.configuration.parameter.simple.type.date");

        private final String i18nKey;

        private SimpleValueType(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }
}

