/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.D42ValueHolder;
import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.ConfigurationItemParameter;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.core.MultiConfigurationItemParameter;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.service.RestItem;
import com.device42.atlas.common.service.RestList;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import com.device42.atlas.common.util.PartialCIList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;

public class D42DataHelper {
    private static final Logger.Log log = Logger.getInstance(D42DataHelper.class);
    private static final String URL_TOKEN = "url";
    private final D42DataManager d42DataManager;
    private final String d42BaseUrl;
    private final I18nResolver i18n;
    private Long firstLevelId;
    private Long secondLevelId;
    private ConfigurationItemType type;
    private String rawTypeKey;
    private Set<String> ids;
    private Map<String, ConfigurationItem> configurationItemValues = null;
    private PartialCIList allowedConfigurationItems = null;
    private List<ConfigurationItemType> allowedTypes = null;
    private Filter filter = null;
    private ConfigurationItemFilter searchFilter = null;
    private String term;
    private int limit;
    private int offset;

    public static D42DataHelperBuilder create(D42DataManager d42DataManager, D42SettingsManager d42SettingsManager, I18nResolver i18n) {
        return new D42DataHelperBuilder(d42DataManager, d42SettingsManager, i18n);
    }

    private D42DataHelper(D42DataManager d42DataManager, D42SettingsManager d42SettingsManager, I18nResolver i18n) {
        this.i18n = i18n;
        this.d42DataManager = d42DataManager;
        this.limit = 50;
        if (d42SettingsManager != null) {
            D42ConnectionInfo connectionInfo = d42SettingsManager.getConnectionInfo();
            if (connectionInfo != null) {
                this.limit = connectionInfo.getSelectDefaultLimit();
                this.d42BaseUrl = connectionInfo.getBaseUrl();
            } else {
                this.d42BaseUrl = null;
            }
        } else {
            this.d42BaseUrl = null;
        }
    }

    public void setFilterInfo(Long firstLevelId, Long secondLevelId) {
        this.firstLevelId = firstLevelId;
        this.secondLevelId = secondLevelId;
    }

    public void setSearchFilter(ConfigurationItemFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public Filter getFilter() throws D42Exception {
        if (this.filter == null && this.firstLevelId != null && this.secondLevelId != null) {
            this.filter = this.d42DataManager.getFilter(this.firstLevelId, this.secondLevelId);
        }
        return this.filter;
    }

    public Long getSecondLevelId() {
        return this.secondLevelId;
    }

    public ConfigurationItem getConfigurationItem(String id) throws D42Exception {
        if (this.configurationItemValues == null) {
            this.initializeValueDetails();
        }
        if (this.configurationItemValues != null) {
            return this.configurationItemValues.get(id);
        }
        return null;
    }

    public List<ConfigurationItem> getConfigurationItems() throws D42Exception {
        if (this.configurationItemValues == null) {
            this.initializeValueDetails();
        }
        if (this.configurationItemValues == null) {
            return null;
        }
        return new ArrayList<ConfigurationItem>(this.configurationItemValues.values());
    }

    private String getEntityUrl(String typeName, String id) {
        if (StringUtils.isNotEmpty((String)this.d42BaseUrl)) {
            return UriBuilder.fromPath((String)this.d42BaseUrl).segment(new String[]{"admin", "rackraj", typeName, id}).build(new Object[0]).toString();
        }
        return null;
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public String getIdsString() {
        if (this.ids != null) {
            return ObjectUtils.stringJoin(",", this.ids);
        }
        return "";
    }

    public boolean isMember(String id) {
        return this.ids != null && this.ids.contains(id);
    }

    public String getCIUrl(ConfigurationItemType itemType, String itemId) {
        if (itemType != null && itemId != null) {
            return this.getEntityUrl(itemType.getLinkComponent(), itemId);
        }
        return null;
    }

    public String getTypeKey() {
        if (this.type != null) {
            return this.type.getKey();
        }
        return null;
    }

    public ConfigurationItemType getType() throws D42Exception {
        List<ConfigurationItemType> allowedTypes;
        if (this.type == null && (allowedTypes = this.getAllowedTypes()) != null && !allowedTypes.isEmpty()) {
            this.type = allowedTypes.get(0);
        }
        return this.type;
    }

    public String getValue() {
        if (this.type != null && this.ids != null && this.ids.size() > 0) {
            return this.type.getKey() + ObjectUtils.stringJoin(",", this.ids);
        }
        return "";
    }

    public String getNamesString(String prefix) {
        ArrayList<String> names = new ArrayList<String>();
        for (String id : this.ids) {
            if (!this.configurationItemValues.containsKey(id)) continue;
            names.add(prefix + " " + this.configurationItemValues.get(id).getDisplayName());
        }
        return ObjectUtils.stringJoin(", ", names);
    }

    public List<ConfigurationItemType> getAllowedTypes() throws D42Exception {
        Filter filter;
        if (this.allowedTypes == null && (filter = this.getFilter()) != null) {
            this.allowedTypes = new ArrayList<ConfigurationItemType>();
            for (ConfigurationItemType type : this.d42DataManager.getSchema()) {
                ConfigurationItemFilter configurationItemFilter = filter.getConfigurationItemFilter(type);
                if (configurationItemFilter == null || !configurationItemFilter.isSwitchedOn()) continue;
                this.allowedTypes.add(type);
            }
        }
        return this.allowedTypes;
    }

    private boolean sameAllowedConditions(String term, int offset, int limit) {
        return StringUtils.equals((String)this.term, (String)term) && this.getLimit() == limit && this.offset == offset;
    }

    public PartialCIList getAllowedConfigurationItems(String term, int offset) throws D42Exception {
        if (this.allowedConfigurationItems == null || !this.sameAllowedConditions(term, offset, this.getLimit())) {
            this.initializeOptions(term, offset, this.getLimit());
            this.term = term;
            this.offset = offset;
        }
        return this.allowedConfigurationItems;
    }

    public PartialCIList getSearchedConfigurationItems(int offset) throws D42Exception {
        PartialCIList partialCIList = this.d42DataManager.getSearchResult(this.searchFilter, offset, this.getLimit());
        return partialCIList;
    }

    public RestList getRestTypes() throws D42Exception {
        RestList options = new RestList();
        List<ConfigurationItemType> types = this.getAllowedTypes();
        for (ConfigurationItemType allowedType : types) {
            options.addOption(new RestItem(allowedType.getKey(), this.i18n.getText(allowedType.getName())));
        }
        options.setOffset(0);
        options.setTotal(types.size());
        options.setLimit(this.limit);
        return options;
    }

    public RestList getRestValueDetails() {
        RestList options = new RestList();
        int total = 0;
        if (this.type != null && this.ids != null && this.configurationItemValues != null) {
            for (String id : this.ids) {
                ConfigurationItem configurationItem = this.configurationItemValues.get(id);
                if (configurationItem == null) continue;
                RestItem restItem = new RestItem(ObjectUtils.longValue(id), configurationItem.getDisplayName());
                restItem.addParameter(URL_TOKEN, this.getCIUrl(this.type, id));
                options.addOption(restItem);
                ++total;
            }
        }
        options.setOffset(0);
        options.setTotal(total);
        options.setLimit(this.limit);
        return options;
    }

    public RestList getRestConfigurationItems(String term, int offset) throws D42Exception {
        PartialCIList allowedConfigurationItems;
        RestList options = new RestList();
        if (this.searchFilter == null) {
            allowedConfigurationItems = this.getAllowedConfigurationItems(term, offset);
        } else {
            if (!this.searchFilter.iterator().hasNext()) {
                return options;
            }
            allowedConfigurationItems = this.getSearchedConfigurationItems(offset);
        }
        for (ConfigurationItem configurationItem : allowedConfigurationItems) {
            RestItem restItem = new RestItem(configurationItem.getStorageId(), configurationItem.getDisplayName());
            options.addOption(restItem);
        }
        options.setTotal(allowedConfigurationItems.getTotal());
        options.setOffset(allowedConfigurationItems.getOffset());
        options.setLimit(this.limit);
        return options;
    }

    private void initializeOptions(String term, int offset, int limit) throws D42Exception {
        this.allowedConfigurationItems = this.d42DataManager.getActiveByType(this.getType(), this.getFilter().getConfigurationItemFilter(this.getType()), term, offset, limit);
    }

    private void initializeValueDetails() throws D42Exception {
        if (this.type != null && this.ids != null) {
            this.configurationItemValues = new TreeMap<String, ConfigurationItem>();
            ConfigurationItemFilter configurationItemFilter = this.getFilter().getConfigurationItemFilter(this.type);
            for (String id : this.ids) {
                try {
                    long valueId = Long.valueOf(id);
                    ConfigurationItem configurationItem = this.d42DataManager.getByStorageId(valueId, this.type);
                    if (configurationItem == null) continue;
                    configurationItem.applyConfigurationItemFilter(configurationItemFilter);
                    for (Parameter par : configurationItem) {
                        if (par instanceof MultiConfigurationItemParameter) {
                            for (ConfigurationItemParameter ciParameter : ((MultiConfigurationItemParameter)par).getCiParameterValues()) {
                                this.applyFilterToCiParametr(ciParameter);
                            }
                            continue;
                        }
                        if (!(par instanceof ConfigurationItemParameter)) continue;
                        this.applyFilterToCiParametr((ConfigurationItemParameter)par);
                    }
                    this.configurationItemValues.put(id, configurationItem);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to collect the value of id: " + id + " and type " + this.type), (Throwable)e);
                }
            }
        }
    }

    private void applyFilterToCiParametr(ConfigurationItemParameter par) throws D42Exception {
        ConfigurationItemFilter filter = this.getFilter().getConfigurationItemFilter(par.getConfigurationItem().getType());
        par.getConfigurationItem().applyConfigurationItemFilter(filter);
    }

    public void setValue(String value) throws D42Exception {
        List<ConfigurationItemType> allowedTypes = this.getAllowedTypes();
        if (StringUtils.isNotBlank((String)value)) {
            D42ValueHolder holder = D42ValueHolder.createD42FieldValueHolder(this.d42DataManager.getSchema(), value);
            this.rawTypeKey = holder.getRawTypeKey();
            if (allowedTypes != null && holder != null && allowedTypes.contains(holder.getType())) {
                this.type = holder.getType();
                this.ids = new TreeSet<String>(Arrays.asList(holder.getIds()));
            }
        }
        if (this.type == null && allowedTypes != null && allowedTypes.size() > 0) {
            this.type = allowedTypes.get(0);
        }
        this.initializeValueDetails();
    }

    public boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((String)str);
    }

    public Long getFirstLevelId() {
        return this.firstLevelId;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getRawTypeKey() {
        return this.rawTypeKey;
    }

    public static class D42DataHelperBuilder {
        private final D42DataHelper d42DataHelper;

        public D42DataHelperBuilder(D42DataManager d42DataManager, D42SettingsManager d42SettingsManager, I18nResolver i18n) {
            this.d42DataHelper = new D42DataHelper(d42DataManager, d42SettingsManager, i18n);
        }

        public D42DataHelperBuilder filterInfo(Long firstLevelId, Long secondLevelId) {
            this.d42DataHelper.setFilterInfo(firstLevelId, secondLevelId);
            return this;
        }

        public D42DataHelperBuilder searchFilter(ConfigurationItemFilter searchFilter) {
            this.d42DataHelper.setSearchFilter(searchFilter);
            return this;
        }

        public D42DataHelperBuilder value(String value) throws D42Exception {
            this.d42DataHelper.setValue(value);
            return this;
        }

        public D42DataHelperBuilder value(ConfigurationItemType type, String ids) throws D42Exception {
            this.d42DataHelper.setValue(type.getKey() + ids);
            return this;
        }

        public D42DataHelperBuilder value(ConfigurationItemType type) throws D42Exception {
            this.d42DataHelper.setValue(type.getKey() + 0L);
            return this;
        }

        public D42DataHelper build() {
            return this.d42DataHelper;
        }
    }
}

