/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.job.upgrade.manual.ManualUpgradeTask;
import com.device42.atlas.common.job.upgrade.manual.ServiceRewriteManualUpgrade;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42DataManagerImpl;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.manager.D42SupportManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.ao.D42SupportAO;
import com.device42.atlas.common.remote.Device42ClientException;
import com.device42.atlas.common.remote.Device42RestClient;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.D42Version;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.http.client.methods.RequestBuilder;

public class D42SupportManagerImpl
implements D42SupportManager {
    private final ActiveObjects ao;
    private final D42SettingsManager settingsManager;
    private HashMap<String, ManualUpgradeTask> manualTasks;
    private static Logger.Log log = Logger.getInstance(D42DataManagerImpl.class);

    public D42SupportManagerImpl(ActiveObjects ao, D42SettingsManager settingsManager) {
        this.ao = ao;
        this.settingsManager = settingsManager;
    }

    @Override
    public long getCurrentSupportedVersion() {
        D42SupportAO[] d42SupportAOs = (D42SupportAO[])this.ao.find(D42SupportAO.class);
        if (d42SupportAOs.length > 0) {
            return d42SupportAOs[0].getCurrentSupportedVersion();
        }
        return D42Version.MINIMUM_SUPPORTED_VERSION.getLong();
    }

    @Override
    public long getCurrentD42Version() throws Device42ClientException {
        try {
            D42ConnectionInfo connectionInfo = this.settingsManager.getConnectionInfo();
            Device42RestClient restClient = new Device42RestClient(connectionInfo.getBaseUrl(), connectionInfo.getUsername(), connectionInfo.getPassword(), connectionInfo.getDefaultLimit());
            String versionResponse = null;
            try {
                versionResponse = restClient.executeRequest(RequestBuilder.get().setUri("/internal/ajax/get_d42_version/"));
            }
            catch (Device42ClientException e) {
                return D42Version.MINIMUM_SUPPORTED_VERSION.getLong();
            }
            JsonObject jsonObject = new JsonParser().parse(versionResponse).getAsJsonObject();
            String version = jsonObject.get("msg").getAsString();
            version = version.replace(".", "");
            return Long.valueOf(version);
        }
        catch (JsonSyntaxException | NumberFormatException e) {
            log.error((Object)"Exception during Device42 response parsing: ", (Throwable)e);
            return D42Version.SERVICE_REWRITE_VERSION.getLong();
        }
        catch (URISyntaxException e) {
            throw new Device42ClientException("Wrong URI syntax: " + e);
        }
    }

    @Override
    public void runUpdateManual(String key, D42DataManager dataManager) throws D42Exception {
        if (this.manualTasks == null) {
            this.initManualTasks(dataManager);
        }
        if (this.manualTasks.containsKey(key)) {
            this.manualTasks.get(key).doUpgrade();
        } else {
            log.error((Object)String.format("Manual task with key %s does not exist", key));
        }
    }

    private void initManualTasks(D42DataManager dataManager) {
        this.manualTasks = new HashMap();
        this.manualTasks.put("service_rewrite_manual_upgrade", new ServiceRewriteManualUpgrade(this.ao, dataManager));
    }
}

