/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.device42.atlas.common.job.JobStatistics;
import com.device42.atlas.common.manager.D42ConfigurationServletProcessor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42DataUpdaterMonitor;
import com.device42.atlas.common.manager.D42JobStatisticsManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.manager.D42SupportManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.remote.Device42ClientException;
import com.device42.atlas.common.remote.Device42RestClient;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class D42ConfigurationServletProcessorImpl
implements D42ConfigurationServletProcessor {
    private static final Logger.Log log = Logger.getInstance(D42ConfigurationServletProcessorImpl.class);
    protected static final String VM_BASE = "/com/device42/atlas/templates/action/admin/connection/";
    protected static final String VM_VIEW = "/com/device42/atlas/templates/action/admin/connection/connection-view.vm";
    protected static final String VM_EDIT = "/com/device42/atlas/templates/action/admin/connection/connection-edit.vm";
    protected static final String VM_DELETE = "/com/device42/atlas/templates/action/admin/connection/delete-confirmation.vm";
    protected static final String VM_UPDATE = "/com/device42/atlas/templates/action/admin/connection/performupdate-view.vm";
    protected static final String VM_CRON = "/com/device42/atlas/templates/action/admin/connection/setup-cron-edit.vm";
    protected static final String ACTION_GET_EDIT = "getEdit";
    protected static final String ACTION_GET_CRON = "getCron";
    protected static final String ACTION_GET_DELETE = "getDelete";
    protected static final String ACTION_GET_UPDATE = "getUpdate";
    protected static final String ACTION_GET_MIGRATE = "getMigrate";
    protected static final String ACTION_EDIT = "edit";
    protected static final String ACTION_CRON = "cron";
    protected static final String ACTION_DELETE = "delete";
    protected static final String ACTION_UPDATE = "update";
    protected static final String ACTION_ABORT = "abort";
    protected static final String ACTION_MIGRATE = "migrate";
    protected static final String TOKEN_CONFIRM_DELETE = "agreeDelete";
    protected static final String TOKEN_DELETE_SCHEMA = "deleteSchema";
    protected static final String TOKEN_CONFIRM_UPDATE = "agreeUpdate";
    protected static final String TOKEN_FORCE_SCAN = "forceScan";
    protected static final String TOKEN_FULL_RESCAN = "fullRescan";
    protected static final String TOKEN_CONFIRM_ABORT = "agreeAbort";
    protected static final String TOKEN_CONFIRM_MIGRATE = "agreeMigrate";
    protected static final String TOKEN_COLLECTED_TYPES = "collectedTypes";
    protected static final String TOKEN_MANUAL_PENDING = "manualPending";
    protected static String[] actions = new String[]{"getEdit", "getCron", "getDelete", "getUpdate", "edit", "cron", "delete", "update", "abort", "getMigrate", "migrate"};
    protected final D42DataManager dataManager;
    protected final D42DataUpdaterMonitor dataUpdaterMonitor;
    protected final D42SettingsManager settingsManager;
    protected final I18nResolver i18n;
    protected final TransactionTemplate transactionTemplate;
    protected final D42JobStatisticsManager jobStatisticsManager;
    protected final PluginSettingsFactory pluginSettingsFactory;
    protected final D42SupportManager d42SupportManager;

    public D42ConfigurationServletProcessorImpl(D42DataManager dataManager, D42DataUpdaterMonitor dataUpdaterMonitor, D42SettingsManager settingsManager, I18nResolver i18n, TransactionTemplate transactionTemplate, D42JobStatisticsManager jobStatisticsManager, PluginSettingsFactory pluginSettingsFactory, D42SupportManager d42SupportManager) {
        this.dataManager = dataManager;
        this.dataUpdaterMonitor = dataUpdaterMonitor;
        this.settingsManager = settingsManager;
        this.i18n = i18n;
        this.transactionTemplate = transactionTemplate;
        this.jobStatisticsManager = jobStatisticsManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.d42SupportManager = d42SupportManager;
    }

    protected String processViewAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        D42ConnectionInfo connectionInfo = this.settingsManager.getConnectionInfo();
        if (connectionInfo != null) {
            connectionInfo.setAcceptorParameters(outputParameters, this.dataUpdaterMonitor);
        }
        this.addJobStatistics(outputParameters);
        return VM_VIEW;
    }

    protected String processGetEditAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(this.settingsManager.getConnectionInfo());
        outputParameters.addParameter(TOKEN_COLLECTED_TYPES, this.dataManager.getCollectableSchema());
        return VM_EDIT;
    }

    protected String processEditAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        String[] schemes;
        UrlValidator urlValidator;
        D42ConnectionInfo oldConnectionInfo = this.settingsManager.getConnectionInfo();
        Schema collectableSchema = this.dataManager.getCollectableSchema();
        D42ConnectionInfo connectionInfo = new D42ConnectionInfo(new MapDonor(parameters));
        outputParameters.addParameter(TOKEN_COLLECTED_TYPES, collectableSchema);
        if (StringUtils.isBlank((String)connectionInfo.getBaseUrl())) {
            outputParameters.addError("baseUrl", this.i18n.getText("com.device42.atlas.page.settings.baseurl.error.blank"));
        }
        if (StringUtils.isBlank((String)connectionInfo.getUsername())) {
            outputParameters.addError("username", this.i18n.getText("com.device42.atlas.page.settings.username.error.blank"));
        }
        if (StringUtils.isBlank((String)connectionInfo.getPassword())) {
            if (oldConnectionInfo == null || StringUtils.isBlank((String)oldConnectionInfo.getPassword())) {
                outputParameters.addError("password", this.i18n.getText("com.device42.atlas.page.settings.password.error.blank"));
            } else {
                connectionInfo.setPassword(oldConnectionInfo.getPassword());
            }
        }
        if (!(urlValidator = new UrlValidator(schemes = new String[]{"http", "https"}, new RegexValidator("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{1,63}$"), 0L)).isValid(connectionInfo.getBaseUrl())) {
            outputParameters.addError("baseUrl", this.i18n.getText("com.device42.atlas.page.settings.baseurl.error.invalid"));
        }
        if (connectionInfo.getLimit() <= 0) {
            outputParameters.addError("limit", this.i18n.getText("com.device42.atlas.page.settings.limit.error.invalid"));
        }
        if (connectionInfo.getSelectLimit() <= 0) {
            outputParameters.addError("selectLimit", this.i18n.getText("com.device42.atlas.page.settings.selectlimit.error.invalid"));
        }
        if (!outputParameters.hasErrors()) {
            try {
                new Device42RestClient(connectionInfo.getBaseUrl(), connectionInfo.getUsername(), connectionInfo.getPassword(), connectionInfo.getDefaultLimit()).checkConnectivity();
                this.settingsManager.setConnectionInfo(connectionInfo);
                if (this.dataManager.getCollectableSchema().isEmpty()) {
                    this.dataManager.importDefaultSchema(false);
                }
                return null;
            }
            catch (Device42ClientException ex) {
                log.error((Object)"Could not connect to service", (Throwable)ex);
                outputParameters.addErrorMessage(ex.getMessage());
            }
            catch (URISyntaxException ex) {
                log.error((Object)"Could not connect to service", (Throwable)ex);
                outputParameters.addErrorMessage(ex.getMessage());
            }
            catch (D42Exception ex) {
                log.error((Object)"Could not import default scheme", (Throwable)ex);
                outputParameters.addErrorMessage(ex.getMessage());
            }
        }
        outputParameters.addParameters(new MapDonor(parameters));
        outputParameters.addParameters(connectionInfo);
        return VM_EDIT;
    }

    protected String processGetDeleteAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(new MapDonor(parameters));
        return VM_DELETE;
    }

    protected String processDeleteAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        if (!ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_DELETE), false)) {
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.settings.delete.agree.error"));
            return VM_DELETE;
        }
        boolean deleteSchema = ObjectUtils.booleanValue(parameters.get(TOKEN_DELETE_SCHEMA), false);
        this.settingsManager.deleteConnectionInfo();
        this.jobStatisticsManager.clearJobStatistics(new JobStatistics(this.dataManager.getSchema()));
        this.dataManager.deleteAoData(deleteSchema);
        return null;
    }

    private void addJobStatistics(@Nonnull ErrorHolder outputParameters) {
        Schema schema = this.dataManager.getCollectableSchema();
        JobStatistics jobStatistics = this.jobStatisticsManager.getCurrentJobStatistics(schema);
        jobStatistics.saveToAcceptor(outputParameters);
        outputParameters.addParameter(TOKEN_COLLECTED_TYPES, schema);
        outputParameters.addParameter(TOKEN_MANUAL_PENDING, this.jobStatisticsManager.isPendingManually());
    }

    protected String processGetUpdateAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(new MapDonor(parameters));
        this.addJobStatistics(outputParameters);
        return VM_UPDATE;
    }

    protected String processUpdateAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(new MapDonor(parameters));
        boolean confirmUpdate = ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_UPDATE), false);
        boolean forceScan = ObjectUtils.booleanValue(parameters.get(TOKEN_FORCE_SCAN), false);
        boolean fullRescan = ObjectUtils.booleanValue(parameters.get(TOKEN_FULL_RESCAN), false);
        try {
            if (confirmUpdate) {
                this.dataManager.checkManualUpdates();
                this.dataUpdaterMonitor.runOnce(forceScan, fullRescan);
                this.addJobStatistics(outputParameters);
                return null;
            }
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.settings.confirm.update.error"));
        }
        catch (Exception ex) {
            log.error((Object)"Could not update data", (Throwable)ex);
            outputParameters.addErrorMessage(ex.getMessage());
        }
        return VM_UPDATE;
    }

    protected String processAbortAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(new MapDonor(parameters));
        boolean confirmAbort = ObjectUtils.booleanValue(parameters.get(TOKEN_CONFIRM_ABORT), false);
        try {
            if (confirmAbort) {
                this.dataUpdaterMonitor.abortCurrentJob();
                this.addJobStatistics(outputParameters);
                return null;
            }
            outputParameters.addErrorMessage(this.i18n.getText("com.device42.atlas.page.settings.confirm.abort.error"));
        }
        catch (Exception ex) {
            log.error((Object)"Could not abort execution", (Throwable)ex);
            outputParameters.addErrorMessage(ex.getMessage());
        }
        return VM_UPDATE;
    }

    protected String processGetCronAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        outputParameters.addParameters(this.settingsManager.getConnectionInfo());
        return VM_CRON;
    }

    protected String processCronAction(Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        D42ConnectionInfo connectionInfo = new D42ConnectionInfo(new MapDonor(parameters));
        if (!StringUtils.isBlank((String)connectionInfo.getCron()) && !this.dataUpdaterMonitor.validateCronExpression(connectionInfo.getCron())) {
            outputParameters.addError(ACTION_CRON, this.i18n.getText("com.device42.atlas.page.settings.setupcron.cron.error.format"));
        } else {
            this.settingsManager.setCron(connectionInfo.getCron());
            try {
                this.dataUpdaterMonitor.reSchedule();
                return null;
            }
            catch (D42Exception ex) {
                log.error((Object)"Could not reschedule", (Throwable)ex);
                outputParameters.addErrorMessage(ex.getMessage());
            }
        }
        outputParameters.addParameters(new MapDonor(parameters));
        return VM_CRON;
    }

    @Override
    public String processRequestServletAction(String action, Map<String, String> parameters, ErrorHolder outputParameters) {
        if (ACTION_GET_EDIT.equals(action)) {
            return this.processGetEditAction(parameters, outputParameters);
        }
        if (ACTION_EDIT.equals(action)) {
            return this.processEditAction(parameters, outputParameters);
        }
        if (ACTION_GET_DELETE.equals(action)) {
            return this.processGetDeleteAction(parameters, outputParameters);
        }
        if (ACTION_DELETE.equals(action)) {
            return this.processDeleteAction(parameters, outputParameters);
        }
        if (ACTION_GET_CRON.equals(action)) {
            return this.processGetCronAction(parameters, outputParameters);
        }
        if (ACTION_CRON.equals(action)) {
            return this.processCronAction(parameters, outputParameters);
        }
        if (ACTION_GET_UPDATE.equals(action)) {
            return this.processGetUpdateAction(parameters, outputParameters);
        }
        if (ACTION_UPDATE.equals(action)) {
            return this.processUpdateAction(parameters, outputParameters);
        }
        if (ACTION_ABORT.equals(action)) {
            return this.processAbortAction(parameters, outputParameters);
        }
        return this.processViewAction(parameters, outputParameters);
    }

    @Override
    public String[] getActions() {
        return actions;
    }

    @Override
    public boolean isPostActionOnly(String actionName) {
        return ACTION_EDIT.equals(actionName) || ACTION_CRON.equals(actionName) || ACTION_DELETE.equals(actionName) || ACTION_UPDATE.equals(actionName) || ACTION_ABORT.equals(actionName);
    }

    @Override
    public boolean isJson(String action) {
        return false;
    }
}

