function d42OptionsAjaxCall(context, data) {
	var options = [];
	AJS.$.ajax({
		url : AJS.contextPath() + "/rest/d42/1.0/" + context,
		type : "get",
		dataType : "json",
		"data" : data,
		async : false,
		error : function(xhr, ajaxOptions, thrownError) {
		    if (xhr.status === 403) {
                options = null;
            } else {
                alert(xhr.status + ": " + xhr.responseText);
            }
		},
		success : function(data) {
			options = data.optItems;
		}
	});
	return options;
}

function d42GetSelector(firstLevelId, secondLevelId) {
	return "[first-id='" + soy.$$escapeHtml(firstLevelId) + "'][second-id='"
			+ soy.$$escapeHtml(secondLevelId) + "']";
}

function d42FillSelect(options, control, isKey) {
	AJS.$(control).empty();
	AJS.$.each(options, function(index, value) {
		AJS.$(control).append(
				AJS.$("<option></option>").attr("value",
						(isKey ? value.key : value.id)).text(value.name));
	});
}

function d42FillTypes(firstLevelId, secondLevelId) {
    var options = d42OptionsAjaxCall("d42Options/types", {
        "firstLevelId": firstLevelId,
        "secondLevelId": secondLevelId
    });
// // for confluence restrict spaces
    if (options == null) {

        AJS.$("#macro-param-div-d42Value").hide();
        AJS.$("#macro-param-div-d42Value").before("<div class=\"aui-message error\">\n" +
            "    <p class=\"title\">\n" +
            "        <span class=\"aui-icon icon-error\"></span>\n" +
            "        <strong>Access denied!</strong>\n" +
            "    </p>\n" +
            "    <p>You don't have access to this space. Please, ask your system administrator.</p>\n" +
            "</div>");
		return;

    }
//-------------------------------------
    var typesSelect = AJS.$("select.d42-data-field-type-select"
        + d42GetSelector(firstLevelId, secondLevelId));
    /*	if(options.length > 1) {*/
    d42FillSelect(options, typesSelect, true);
    /*	} else {
            var parent = typesSelect.parent();
            typesSelect.remove();
            parent.prepend('<div>' + options[0].name + '</div>');
        }*/
	return options;
}

function d42ResetDataSelection(firstLevelId, secondLevelId) {

	var optionsSelect = AJS.$("input.d42-data-field-select"
			+ d42GetSelector(firstLevelId, secondLevelId));
	optionsSelect.val(null);
	optionsSelect.change();

}

function d42StoreData(firstLevelId, secondLevelId, fieldId) {
	var optionsType = AJS.$("select.d42-data-field-type-select"
			+ d42GetSelector(firstLevelId, secondLevelId));
	var optionsField = AJS.$("input.d42-data-field-select"
			+ d42GetSelector(firstLevelId, secondLevelId));
	var valueToSave = "";
	if (AJS.$(optionsType).val() && AJS.$(optionsField).val()) {
		valueToSave = AJS.$(optionsType).val() + AJS.$(optionsField).val();
	}
	AJS.$(fieldId).val(valueToSave);
}

function d42ApplySelect2(fid,sid) {
	var $=$?$:jQuery;

    var type = $("select.d42-data-field-type-select"
        + d42GetSelector(fid, sid)).val();

    var dialogBody = AJS.$("#search_"+sid);

	var ajax;

	var result = function (data, page) {
        var results = [];
        $.each(data.optItems, function (index, value) {
            var result = {};
            result.id = value.id;
            result.text = value.name;
            results.push(result);
        });
        var more = data.total - data.offset - data.optItems.length > 0;
        var context = {};
        context.limit = data.limit;
        return {
            results: results,
            more: more,
            context: context
        };
    };

	if ($("input.d42-data-field-select"+d42GetSelector(fid,sid)).attr("search")==="true") {

		ajax={
            url: AJS.contextPath() + "/rest/d42/1.0/d42Options/search",
            dataType: "json",
            params: {contentType: "application/json;charset=utf-8"},
			type: "POST",
            quietMillis: 400,
            data: function (term, page, context) {


                var limit = (context && context.limit) ? context.limit : 0;

                var ciFilter = createCIFilter(type,(page - 1) * limit,sid,dialogBody.find("[id^='item_']"));

                return JSON.stringify(ciFilter);
            },
            results: result,
        };



	} else {

        ajax = {
            url: AJS.contextPath() + "/rest/d42/1.0/d42Options/options",
            dataType: "json",
            quietMillis: 400,
            data: function (term, page, context) {

                var limit = (context && context.limit) ? context.limit : 0;

                return {
                    firstLevelId: fid,
                    secondLevelId: sid,
                    term: term,
                    offset: (page - 1) * limit,
                    type: type,
                }
            },
            results: result,
        };
    }
	var typeParams = {
		allowClear : true,
		placeholder : 'Start typing entity name'
	};
	var typeControl = $("select.d42-data-field-type-select"+d42GetSelector(fid,sid));
	if (typeControl.auiSelect2)
		typeControl.auiSelect2(typeParams);
	else
		typeControl.select2(typeParams);
	var dataParams = {
		initSelection : function(element, callback) {
			var data = [];

			$(".d42Values" + d42GetSelector(fid, sid))
					.children().each(function() {
						var id = $(this).attr("itemId");
						var text = $(this).attr("itemValue");
						data.push({
							id : id,
							text : text
						});
					});
			callback(data);
		},
		ajax : ajax,
		allowClear : true,
		placeholder : "Start typing entity name",
		multiple : true
	};
	var dataControl = $("input.d42-data-field-select"+d42GetSelector(fid,sid));
	if (dataControl.auiSelect2)
		dataControl.auiSelect2(dataParams);
	else
		dataControl.select2(dataParams);

}

function d42RenderEdit(firstLevelId, secondLevelId, fieldId, prevValue) {
	var $=$?$:jQuery;
	var domField = $(fieldId);
	if (domField && domField.is(":visible")) {
		if (firstLevelId) {
			domField.hide();

			var selectType = $(
					"<select>",
					{
						"class" : "d42-data-field-type-select trigger-select2 js-select2-picker",
						style: "margin-bottom: 10px; width: 89%",
						name : "type_" + soy.$$escapeHtml(secondLevelId),
						id : "type_" + soy.$$escapeHtml(secondLevelId),
						"first-id" : soy.$$escapeHtml(firstLevelId),
						"second-id" : soy.$$escapeHtml(secondLevelId)
					});

			var selectValues = $(
					"<input>",
					{
						type : "hidden",
						"class" : "d42-data-field-select trigger-select2 js-select2-picker",
						size : "5",
						name : "values_" + soy.$$escapeHtml(secondLevelId),
						id : "values_" + soy.$$escapeHtml(secondLevelId),
						"first-id" : soy.$$escapeHtml(firstLevelId),
						"second-id" : soy.$$escapeHtml(secondLevelId)
					});


			var dialog = "<section role='dialog' id='search_"+soy.$$escapeHtml(secondLevelId)+"' fid='"+soy.$$escapeHtml(firstLevelId)+"' sid='"+soy.$$escapeHtml(secondLevelId)+"' class='aui-layer aui-dialog2 aui-dialog2-medium' aria-hidden='true'>" +
                "<header class='aui-dialog2-header'>" +
                "<h2 class='aui-dialog2-header-main'></h2>" +
                "<a class='aui-dialog2-header-close' >" +
                "<span class='aui-icon aui-icon-small aui-iconfont-close-dialog'/>" +
                "</a>" +
                "</header>" +
                "<div class='aui-dialog2-content'>" +
				"<div class='description' style='font-size: 12px' >Select the parameters for search. <a id='resetFilter' href='#'>Reset filter</a></div>"+
                "<a href='#d42parameters_"+soy.$$escapeHtml(secondLevelId)+"' style='font-size: 14px; margin-top: 5px' aria-owns='d42parameters_"+soy.$$escapeHtml(secondLevelId)+"' aria-haspopup='true' class='aui-button aui-style-default aui-dropdown2-trigger'><span class='aui-icon aui-icon-small aui-iconfont-list-add'/></a>" +
                "<div id='d42parameters_"+soy.$$escapeHtml(secondLevelId)+"' class='aui-style-default aui-dropdown2'>" +
                "<ul class='aui-list-truncate'></ul>" +
                "</div>" +
                "<div id='searchParameters' style='margin-top: 20px'></div>" +
                "</div>" +
                "<footer class='aui-dialog2-footer'>" +
                "<div class='aui-dialog2-footer-actions'>" +
                "<button class='aui-button aui-button-primary apply d42-apply'>Apply</button>" +
                "<button class='aui-button aui-button-link cancel d42-cancel'>Cancel</button>" +
                "</div>" +
                "</footer>" +
                "</section>";



			domField.after(selectValues).after(selectType).after(dialog);

			if (AJS.contextPath().includes("jira")) {
                $(domField).after("<button class='aui-button showSearch' style='float: right; border: 0px' type='button'><span class='aui-icon aui-icon-small aui-iconfont-search'/></button>");
			}


			d42FillTypes(firstLevelId, secondLevelId);
			var typeLength = 0;
			// autoselect type
			var typeSelected = false;
			if (prevValue && prevValue.length > 0) {
				var match = prevValue.match(/[a-zA-Z]+/);

				var typeValue = match ? match[0] : null;
				if (typeValue) {
					typeLength = typeValue.length;
					var selectOptions = selectType.find("option[value='"
							+ soy.$$escapeHtml(typeValue) + "']");
					if (selectOptions.length > 0) {
						selectOptions.prop('selected', true);
						typeSelected = true;
					}
				}
			}

			if (!typeSelected) {
				selectType.find("option:first").prop('selected', true);
			}
			// autoselect value
			if (prevValue && typeLength > 0) {
				var ids = prevValue.substring(typeLength, prevValue.length);
				if (ids) {
					selectValues.attr("value", ids);
					
					var details = d42OptionsAjaxCall("d42Options/valueDetails", {
						"value" : prevValue
					});
					if (details) {
						var initValues = $("<ul>", {
							style : "display:none",
							"class" : "d42Values",
							"first-id" : soy.$$escapeHtml(firstLevelId),
							"second-id" : soy.$$escapeHtml(secondLevelId)
						});
						$.each(details, function(index, value) {
							var selectedItemInfo = $("<li>", {
								itemId: value.id,
								itemValue: value.name
							});
							initValues.append(selectedItemInfo);
						});
						selectValues.after(initValues);
						
					}
				}
			}
			d42ApplySelect2(firstLevelId, secondLevelId);
		}
	}
}
