/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ObjectUtils {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String DEFAULT_STRING = "";
    public static final long DEFAULT_LONG = 0L;
    public static final int DEFAULT_INT = 0;

    public static boolean isObjectsNotNull(Object ... objs) {
        for (Object obj : objs) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String stringValue(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static long longValue(Object obj) {
        return ObjectUtils.longValue(obj, 0L);
    }

    public static long longValue(Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static int intValue(Object obj) {
        return ObjectUtils.intValue(obj, 0);
    }

    public static int intValue(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static boolean booleanValue(Object obj, boolean defaultValue) {
        return obj != null ? Boolean.parseBoolean(obj.toString()) : defaultValue;
    }

    public static <T extends Enum<T>> T enumValue(Object obj, Class<T> enumType, T defaultValue) {
        try {
            return Enum.valueOf(enumType, obj.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static Date dateValue(Object obj) {
        try {
            return dateFormat.parse(obj.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stringJoin(String separator, Collection<String> collection) {
        StringBuilder result = new StringBuilder();
        boolean start = true;
        for (String data : collection) {
            if (start) {
                start = false;
            } else {
                result.append(separator);
            }
            result.append(data);
        }
        return result.toString();
    }

    public static String stringJoin(String separator, String[] array) {
        return ObjectUtils.stringJoin(separator, Arrays.asList(array));
    }

    public static Map<String, String> flatten(Map<String, String[]> parameters) {
        if (parameters == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String key : parameters.keySet()) {
            String[] multipleValues = parameters.get(key);
            if (multipleValues == null || multipleValues.length <= 0) continue;
            result.put(key, multipleValues[0]);
        }
        return result;
    }

    public static String flattenObjectStringArray(Object obj) {
        String result = null;
        if (obj != null) {
            String[] stringArray;
            result = obj instanceof String[] ? ((stringArray = (String[])obj).length > 0 ? stringArray[0] : null) : obj.toString();
        }
        if (StringUtils.isBlank(result)) {
            return null;
        }
        return result;
    }

    public static Map<String, Object> convertMapToStringMap(Map<?, ?> input) {
        LinkedHashMap<String, Object> stringMapOutput = new LinkedHashMap<String, Object>();
        for (Object mapKeyObject : input.keySet()) {
            stringMapOutput.put(mapKeyObject.toString(), input.get(mapKeyObject));
        }
        return stringMapOutput;
    }

    private ObjectUtils() {
    }
}

