/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.util;

import com.device42.atlas.common.model.serialization.MapDonor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JsonUtil {
    public static int extractInt(JsonObject json, String key) throws JsonParseException {
        try {
            if (json == null) {
                return 0;
            }
            return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsInt() : 0;
        }
        catch (Exception e) {
            throw new JsonParseException("Integer parse failed", e);
        }
    }

    public static JsonObject extractJson(JsonObject json, String key) throws JsonParseException {
        try {
            if (json == null) {
                return null;
            }
            return json.has(key) && !json.get(key).isJsonNull() ? json.getAsJsonObject(key) : null;
        }
        catch (Exception e) {
            throw new JsonParseException("JsonObject parse failed", e);
        }
    }

    public static long extractLong(JsonObject json, String key) throws JsonParseException {
        try {
            if (json == null || StringUtils.isBlank((String)key)) {
                return 0L;
            }
            return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsLong() : 0L;
        }
        catch (Exception e) {
            throw new JsonParseException("Long parse failed", e);
        }
    }

    public static String extractString(JsonObject json, String key) throws JsonParseException {
        try {
            if (json == null) {
                return "";
            }
            return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : "";
        }
        catch (Exception e) {
            throw new JsonParseException("String parse failed", e);
        }
    }

    public static Object transferJsonElementToObject(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        Object resultValue = null;
        if (jsonElement.isJsonObject()) {
            resultValue = JsonUtil.transferJsonObjectToMap(jsonElement.getAsJsonObject());
        } else if (jsonElement.isJsonArray()) {
            resultValue = JsonUtil.transferJsonArrayToList(jsonElement.getAsJsonArray());
        } else if (jsonElement.isJsonPrimitive()) {
            resultValue = jsonElement.getAsString();
        }
        return resultValue;
    }

    public static List<Object> transferJsonArrayToList(JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement jsonElement = jsonArray.get(i);
            result.add(JsonUtil.transferJsonElementToObject(jsonElement));
        }
        return result;
    }

    public static Map<String, Object> transferJsonObjectToMap(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, JsonElement> entrySet : jsonObject.entrySet()) {
            JsonElement jsonElement = entrySet.getValue();
            result.put(entrySet.getKey(), JsonUtil.transferJsonElementToObject(jsonElement));
        }
        return result;
    }

    public static MapDonor jsonStringToMapDonor(String jsonObjectString) {
        try {
            JsonElement jsonElement = new JsonParser().parse(jsonObjectString);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                return new MapDonor(JsonUtil.transferJsonObjectToMap(jsonElement.getAsJsonObject()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JsonUtil() {
    }
}

