/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletContextHelper {
    private static final String TOKEN_URL = "url";
    private static final String TOKEN_APPLICATION = "applicationType";
    private static final String TOKEN_XSRF_KEY = "xsrfTokenKey";
    private static final String TOKEN_XSRF_VALUE = "atl_token";

    private static String getPlatformId(ApplicationProperties applicationProperties) {
        String platformId = applicationProperties.getDisplayName();
        if ("JIRA".equals(platformId)) {
            return "jira";
        }
        if ("Confluence".equals(platformId)) {
            return "conf";
        }
        return null;
    }

    public static void addDefaultParameters(XsrfTokenAccessor tokenAccessor, XsrfTokenValidator tokenValidator, ApplicationProperties applicationProperties, ErrorHolder output, String url, HttpServletRequest req, HttpServletResponse resp) {
        String xsrfToken = tokenAccessor.getXsrfToken(req, resp, true);
        output.addParameter(TOKEN_APPLICATION, ServletContextHelper.getPlatformId(applicationProperties));
        output.addParameter(TOKEN_URL, req.getContextPath() + url);
        if (xsrfToken != null) {
            output.addParameter(TOKEN_XSRF_KEY, tokenValidator.getXsrfParameterName());
            output.addParameter(TOKEN_XSRF_VALUE, xsrfToken);
        }
    }
}

