/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.remote;

import com.atlassian.extras.common.log.Logger;
import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.remote.Device42ClientException;
import com.device42.atlas.common.remote.Device42ResponseParser;
import com.device42.atlas.common.util.PartialCIList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class Device42RestClient {
    private static final String SUBNET_ID_TAG = "subnet_id";
    private static final String RESERVE_IP_TAG = "reserve_ip";
    private static final String RESERVE_IP_TAG_POSITIVE = "yes";
    private static final String SUGGEST_IP_URL = "/api/1.0/suggest_ip/";
    private static final String TEST_CONNECTION_URL = "/api/1.0/devices/all/?include_cols=device_id&limit=1";
    private static final String QUERY_URL = "/services/data/v1.0/query/";
    public static final String D42_VERSION_URL = "/internal/ajax/get_d42_version/";
    private final HttpHost targetHost;
    private final CloseableHttpClient httpClient;
    private final HttpClientContext clientContext;
    private final long defaultLimit;
    private static final Logger.Log log = Logger.getInstance(Device42RestClient.class);

    protected CloseableHttpClient createHttpClient(String username, String password) throws Device42ClientException {
        SSLContext sslContext = this.createSslContext();
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        BasicHeader header = new BasicHeader("Content-Type", "application/json");
        List<Header> headers = Arrays.asList(header);
        return HttpClients.custom().setHostnameVerifier((X509HostnameVerifier)hostnameVerifier).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultHeaders(headers).build();
    }

    public Device42RestClient(String baseUrl, String username, String password, long defaultLimit) throws URISyntaxException, Device42ClientException {
        URI uri = new URI(baseUrl);
        this.targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        this.httpClient = this.createHttpClient(username, password);
        this.clientContext = this.createClientContext();
        this.defaultLimit = defaultLimit;
    }

    private SSLContext createSslContext() throws Device42ClientException {
        try {
            return new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Device42ClientException("Error creating SSL context. No such algorithm.", e);
        }
        catch (KeyManagementException e) {
            throw new Device42ClientException("Error creating SSL context. Key manager exception.", e);
        }
        catch (KeyStoreException e) {
            throw new Device42ClientException("Error creating SSL context. Keystore exception.", e);
        }
    }

    private HttpClientContext createClientContext() {
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.targetHost, (AuthScheme)new BasicScheme());
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setAuthCache((AuthCache)authCache);
        return clientContext;
    }

    private String executeQueryRequest(String query, boolean addHeader) throws Device42ClientException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(QUERY_URL).addHeader((Header)new BasicHeader("Content-Type", "application/json")).addParameter("header", addHeader ? RESERVE_IP_TAG_POSITIVE : "no").addParameter("query", query);
        return this.executeRequest(requestBuilder);
    }

    public long getAmount(ConfigurationItemType type) throws Device42ClientException {
        return this.getAmount(type, null);
    }

    public long getAmount(ConfigurationItemType type, Date updatedAfter) throws Device42ClientException {
        ConfigurationItemType.DOQLQuery query = type.getQuery();
        if (type.isCollectable() && query != null && !query.hasErrors()) {
            try {
                String lastUpdatedWhere = null;
                if (type.hasLastUpdated() && updatedAfter != null) {
                    lastUpdatedWhere = type.getLastUpdatedWherePart(updatedAfter);
                }
                String queryString = query.getCountRequest(lastUpdatedWhere);
                String queryResult = this.executeQueryRequest(queryString, false);
                return Long.parseLong(queryResult.trim());
            }
            catch (Exception e) {
                throw new Device42ClientException("Cannot count amount of CIs", e);
            }
        }
        throw new Device42ClientException("Cannot count amount of CIs, query contains errors or uncollectable");
    }

    public PartialCIList get(Schema schema, ConfigurationItemType type, long limit, long offset, Date updatedAfter) throws Device42ClientException {
        return this.get(schema, type, limit, offset, updatedAfter, null);
    }

    public PartialCIList get(Schema schema, ConfigurationItemType type, long limit, long offset, Date updatedAfter, String additionalWhere) throws Device42ClientException {
        if (!type.isCollectable()) {
            return null;
        }
        try {
            ConfigurationItemType.DOQLQuery query = type.getQuery();
            if (!query.hasErrors()) {
                String lastUpdatedWhere = null;
                if (type.hasLastUpdated() && updatedAfter != null) {
                    lastUpdatedWhere = type.getLastUpdatedWherePart(updatedAfter);
                }
                if (additionalWhere != null) {
                    lastUpdatedWhere = ConfigurationItemType.DOQLQuery.andWhere(lastUpdatedWhere, additionalWhere);
                }
                String queryString = query.getRequest(lastUpdatedWhere, limit, offset);
                log.debug((Object)("Executing query: " + queryString));
                String queryResult = this.executeQueryRequest(queryString, true);
                CSVParser csvParser = CSVParser.parse(queryResult, CSVFormat.DEFAULT);
                Device42ResponseParser parser = new Device42ResponseParser(schema);
                return parser.parseList(type.getKey(), csvParser);
            }
            throw new Device42ClientException("Query contains errors");
        }
        catch (Exception e) {
            log.error((Object)"Error getting csv response: ", (Throwable)e);
            throw new Device42ClientException("Error getting csv response: " + e.getMessage(), e);
        }
    }

    public ConfigurationItem getSingle(Schema schema, @Nonnull ConfigurationItemType type, String id) throws Device42ClientException {
        if (!type.isCollectable()) {
            return null;
        }
        try {
            ConfigurationItemType.DOQLQuery query = type.getQuery();
            if (!query.hasErrors()) {
                String singleWherePart = type.getSingleItemWherePart(id);
                if (singleWherePart != null) {
                    String queryResult = this.executeQueryRequest(query.getRequest(singleWherePart, 1L, 0L), true);
                    CSVParser csvParser = CSVParser.parse(queryResult, CSVFormat.DEFAULT);
                    Device42ResponseParser parser = new Device42ResponseParser(schema);
                    PartialCIList result = parser.parseList(type.getKey(), csvParser);
                    if (result.size() > 0) {
                        return (ConfigurationItem)result.get(0);
                    }
                    return null;
                }
                throw new Device42ClientException("Query contains errors, no single where part");
            }
            throw new Device42ClientException("Query contains errors");
        }
        catch (Exception e) {
            log.error((Object)"Error getting csv response: ", (Throwable)e);
            throw new Device42ClientException("Error getting csv response: " + e.getMessage(), e);
        }
    }

    public void checkConnectivity() throws Device42ClientException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(TEST_CONNECTION_URL);
        this.executeRequest(requestBuilder);
    }

    public String executeRequest(RequestBuilder requestBuilder) throws Device42ClientException {
        try {
            log.debug((Object)"Request starts");
            CloseableHttpResponse httpResponse = this.httpClient.execute(this.targetHost, (HttpRequest)requestBuilder.build(), (HttpContext)this.clientContext);
            log.debug((Object)"Request finishes, parse starts");
            StatusLine statusLine = httpResponse.getStatusLine();
            try {
                String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                log.debug((Object)"Parse finished");
                if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
                    return result;
                }
                JsonElement jsonElement = new JsonParser().parse(result);
                String errorMessage = Device42ResponseParser.parseError(jsonElement);
                throw new Device42ClientException("Device42 server returned " + statusLine.getStatusCode() + " - " + statusLine.getReasonPhrase() + " and responded with error: " + errorMessage);
            }
            catch (Device42ClientException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new Device42ClientException("Unexpected response from Device42 server: " + statusLine.getStatusCode() + ": " + statusLine.getReasonPhrase(), ex);
            }
        }
        catch (Device42ClientException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new Device42ClientException("Error to call REST API " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new Device42ClientException("Other error " + ex.getMessage(), ex);
        }
    }

    public String aquireIpAddress(String subnetId) throws Device42ClientException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(SUGGEST_IP_URL);
        requestBuilder.addParameter(SUBNET_ID_TAG, subnetId);
        requestBuilder.addParameter(RESERVE_IP_TAG, RESERVE_IP_TAG_POSITIVE);
        String requestResult = this.executeRequest(requestBuilder);
        try {
            JsonElement jsonElement = new JsonParser().parse(requestResult);
            return Device42ResponseParser.parseIpRequest(jsonElement);
        }
        catch (Exception ex) {
            throw new Device42ClientException("Error parsing json response " + ex.getMessage(), ex);
        }
    }

    public long getDefaultLimit() {
        return this.defaultLimit;
    }
}

