/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.MultiReferenceParameterType;
import com.device42.atlas.common.model.core.schema.ReferenceParameterType;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.JsonParameters;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.JsonUtil;
import com.device42.atlas.common.util.ObjectUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class ParameterType
implements Parameterizable {
    public static final String PARAM_TYPE_KEY = "key";
    public static final String PARAM_TYPE_NAME = "name";
    public static final String PARAM_TYPE_DESCRIPTION = "description";
    public static final String PARAM_TYPE_VALUE_TYPE = "valueType";
    public static final String PARAM_TYPE_VIEW_WEIGHT = "viewWeight";
    public static final String PARAM_TYPE_FILTER_ENABLED = "filterEnabled";
    public static final String PARAM_TYPE_SEARCH_ENABLED = "searchEnabled";
    public static final String PARAM_TYPE_PARAM_ENABLED = "paramEnabled";
    public static final String PARAM_TYPE_ADDITIONAL_DATA = "additionalData";
    private String key;
    private String name;
    private String description;
    private boolean enabled;
    protected final ParameterValueType valueType;
    private int viewWeight;
    private String viewWeightRaw;
    protected String additionalTypeData;
    private boolean defaultFilterViewEnabled;
    private boolean searchEnabled;

    public static ParameterType createParameter(ParameterDonor parameterDonor) {
        ParameterValueType parameterValueType = ObjectUtils.enumValue(parameterDonor.get(PARAM_TYPE_VALUE_TYPE), ParameterValueType.class, ParameterValueType.SIMPLE);
        ParameterType parameterType = ParameterType.createParameter(parameterValueType);
        parameterType.loadFromDonor(parameterDonor);
        return parameterType;
    }

    public static ParameterType createParameter(ParameterValueType parameterValueType) {
        ParameterType parameterType;
        switch (parameterValueType) {
            case SIMPLE: {
                parameterType = new SimpleParameterType();
                break;
            }
            case REFERENCE: {
                parameterType = new ReferenceParameterType();
                break;
            }
            case MULTIREFERENCE: {
                parameterType = new MultiReferenceParameterType();
                break;
            }
            default: {
                parameterType = null;
            }
        }
        return parameterType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ParameterValueType getValueType() {
        return this.valueType;
    }

    protected ParameterType(ParameterValueType valueType) {
        this.valueType = valueType;
    }

    public String getAdditionalTypeData() {
        JsonParameters jsonParameters = new JsonParameters();
        this.addAdditionalParameters(jsonParameters);
        return jsonParameters.getJsonObject().toString();
    }

    public void setAdditionalTypeData(String additionalTypeData) {
        this.additionalTypeData = additionalTypeData;
        JsonElement jsonElement = new JsonParser().parse(additionalTypeData);
        if (jsonElement.isJsonObject()) {
            Map<String, Object> convertedMap = JsonUtil.transferJsonObjectToMap(jsonElement.getAsJsonObject());
            MapDonor mapDonor = new MapDonor(convertedMap);
            this.extractAdditionalParameters(mapDonor);
        }
    }

    protected abstract void addAdditionalParameters(ParameterAcceptor var1);

    protected abstract void extractAdditionalParameters(ParameterDonor var1);

    protected abstract void cleanAdditionalParameters(ParameterAcceptor var1);

    public boolean isDefaultFilterViewEnabled() {
        return this.defaultFilterViewEnabled;
    }

    public void setDefaultFilterViewEnabled(boolean defaultFilterViewEnabled) {
        this.defaultFilterViewEnabled = defaultFilterViewEnabled;
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
    }

    public int getViewWeight() {
        return this.viewWeight;
    }

    public void setViewWeight(int viewWeight) {
        this.viewWeight = viewWeight;
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        output.addParameter(PARAM_TYPE_VALUE_TYPE, (Object)this.getValueType());
        output.addParameter(PARAM_TYPE_KEY, this.getKey());
        output.addParameter(PARAM_TYPE_NAME, this.getName());
        output.addParameter(PARAM_TYPE_DESCRIPTION, this.getDescription());
        output.addParameter(PARAM_TYPE_VIEW_WEIGHT, this.getViewWeight());
        output.addParameter(PARAM_TYPE_FILTER_ENABLED, this.isDefaultFilterViewEnabled());
        output.addParameter(PARAM_TYPE_SEARCH_ENABLED, this.isSearchEnabled());
        output.addParameter(PARAM_TYPE_PARAM_ENABLED, this.isEnabled());
        this.addAdditionalParameters(output);
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.setKey(ObjectUtils.stringValue(input.get(PARAM_TYPE_KEY)));
        this.setName(ObjectUtils.stringValue(input.get(PARAM_TYPE_NAME)));
        this.setDescription(ObjectUtils.stringValue(input.get(PARAM_TYPE_DESCRIPTION)));
        this.setViewWeight(ObjectUtils.intValue(input.get(PARAM_TYPE_VIEW_WEIGHT)));
        this.viewWeightRaw = ObjectUtils.stringValue(input.get(PARAM_TYPE_VIEW_WEIGHT));
        this.setDefaultFilterViewEnabled(ObjectUtils.booleanValue(input.get(PARAM_TYPE_FILTER_ENABLED), true));
        this.setSearchEnabled(ObjectUtils.booleanValue(input.get(PARAM_TYPE_SEARCH_ENABLED), true));
        this.setEnabled(ObjectUtils.booleanValue(input.get(PARAM_TYPE_PARAM_ENABLED), true));
        this.extractAdditionalParameters(input);
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(PARAM_TYPE_KEY);
        output.removeParameter(PARAM_TYPE_NAME);
        output.removeParameter(PARAM_TYPE_DESCRIPTION);
        output.removeParameter(PARAM_TYPE_VIEW_WEIGHT);
        output.removeParameter(PARAM_TYPE_FILTER_ENABLED);
        output.removeParameter(PARAM_TYPE_SEARCH_ENABLED);
        output.removeParameter(PARAM_TYPE_PARAM_ENABLED);
        this.cleanAdditionalParameters(output);
    }

    public abstract void validateAdditionalData(I18nResolver var1, ErrorHolder var2);

    public void validate(I18nResolver i18n, ErrorHolder errorHolder, ConfigurationItemType configurationItemType) {
        if (StringUtils.isBlank((String)this.key)) {
            errorHolder.addError(PARAM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.parameter.key.error.blank"));
        } else {
            if (configurationItemType != null && configurationItemType.getParameterTypeByKey(this.key) != null) {
                errorHolder.addError(PARAM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.parameter.key.error.unique"));
            }
            if (!this.key.matches("[A-Za-z0-9_]+")) {
                errorHolder.addError(PARAM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.parameter.key.error.alphanumeric"));
            }
        }
        if (StringUtils.isBlank((String)this.name)) {
            errorHolder.addError(PARAM_TYPE_NAME, i18n.getText("com.device42.atlas.page.configuration.parameter.name.error.blank"));
        }
        if (StringUtils.isBlank((String)this.viewWeightRaw)) {
            errorHolder.addError(PARAM_TYPE_VIEW_WEIGHT, i18n.getText("com.device42.atlas.page.configuration.parameter.viewweight.error.blank"));
        } else {
            try {
                Integer.parseInt(this.viewWeightRaw);
            }
            catch (Exception e) {
                errorHolder.addError(PARAM_TYPE_VIEW_WEIGHT, i18n.getText("com.device42.atlas.page.configuration.parameter.viewweight.error.format"));
            }
        }
        this.validateAdditionalData(i18n, errorHolder);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParameterType)) {
            return false;
        }
        return this.key.equals(((ParameterType)obj).getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "ParameterType [key=" + this.key + ", name=" + this.name + ", description=" + this.description + ", valueType=" + (Object)((Object)this.valueType) + ", additionalTypeData=" + this.additionalTypeData + ", defaultFilterViewEnabled=" + this.defaultFilterViewEnabled + ", searchEnabled=" + this.searchEnabled + "]";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static enum ParameterValueType {
        SIMPLE("com.device42.atlas.page.configuration.parameter.valuetype.simple.label"),
        REFERENCE("com.device42.atlas.page.configuration.parameter.valuetype.reference.label"),
        MULTIREFERENCE("com.device42.atlas.page.configuration.parameter.valuetype.multireference.label");

        private final String i18nKey;

        private ParameterValueType(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }
}

