/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.model.core.schema.ConfigurationItemDisplayName;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.MutliLineStringTokenizer;
import com.device42.atlas.common.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConfigurationItemType
implements Parameterizable {
    private static final Logger.Log log = Logger.getInstance(ConfigurationItemType.class);
    public static final String CONF_ITEM_TYPE_KEY = "key";
    public static final String CONF_ITEM_TYPE_NAME = "name";
    public static final String CONF_ITEM_TYPE_PLURAL_NAME = "pluralName";
    public static final String CONF_ITEM_TYPE_DESCRIPTION = "description";
    public static final String CONF_ITEM_TYPE_LINK_COMPONENT = "linkComponent";
    public static final String CONF_ITEM_TYPE_DOQL = "query";
    public static final String CONF_ITEM_TYPE_ID_INDEX = "idIndex";
    public static final String CONF_ITEM_TYPE_LAST_UPDATED_INDEX = "lastUpdatedIndex";
    public static final String CONF_ITEM_TYPE_WEIGHT = "collectionWeight";
    public static final String CONF_ITEM_TYPE_DISPLAY_NAME = "displayName";
    public static final String CONF_ITEM_TYPE_REQUIRED_INDEXES = "requiredIndexes";
    public static final String CONF_ITEM_TYPE_FILTER_VISIBLE = "filterVisible";
    public static final String CONF_ITEM_TYPE_COLLECTABLE = "collectable";
    public static final String CONF_ITEM_TYPE_DEFAULT_FILTER_ENABLED = "defaultFilterEnabled";
    public static final String CONF_ITEM_TYPE_PARAMETR_TYPES = "parameterTypes";
    public static final String CONF_ITEM_ORDERED_PARAMETER_TYPES_KEYS = "orderedParameterTypeKeys";
    private String key;
    private String name;
    private String pluralName;
    private String description;
    private String linkComponent;
    private DOQLQuery query;
    private int idIndex;
    private String idIndexString;
    private Integer lastUpdatedIndex;
    private String lastUpdatedIndexString;
    private int collectionWeight;
    private String collectionWeightString;
    private ConfigurationItemDisplayName configurationItemDisplayName;
    private int[] requiredColumnIndexes;
    private String requiredColumnIndexesString;
    private boolean filterVisible;
    private boolean collectable;
    private boolean defaultFilterEnabled;
    private Map<String, ParameterType> parameterTypesByKey = new LinkedHashMap<String, ParameterType>();
    private List<ParameterType> parameterTypes = new ArrayList<ParameterType>();
    private List<String> failedParameterKeys = new ArrayList<String>();

    public ConfigurationItemType(ParameterDonor params) {
        if (params != null) {
            this.loadFromDonor(params);
        }
    }

    public ConfigurationItemType() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLinkComponent() {
        return this.linkComponent;
    }

    public void setLinkComponent(String linkComponent) {
        this.linkComponent = linkComponent;
    }

    public DOQLQuery getQuery() {
        return this.query;
    }

    public void setQuery(DOQLQuery query) {
        this.query = query;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public void setIdIndex(int idIndex) {
        this.setIdIndex(idIndex, false);
    }

    public void setIdIndex(int idIndex, boolean changeRaw) {
        this.idIndex = idIndex;
        if (changeRaw) {
            this.idIndexString = Integer.toString(idIndex);
        }
    }

    public String getSingleItemWherePart(String id) {
        if (this.query != null) {
            return this.query.getListedColumnById(this.idIndex) + "=" + id;
        }
        return null;
    }

    public String getLastUpdatedWherePart(Date lastUpdated) {
        if (this.query == null || lastUpdated == null || !this.hasLastUpdated()) {
            return null;
        }
        String lastUpdatedIndexColumName = this.query.getListedColumnById(this.getLastUpdatedIndex());
        if (StringUtils.isNotBlank((String)lastUpdatedIndexColumName)) {
            return this.query.getListedColumnById(this.getLastUpdatedIndex()) + ">'" + ObjectUtils.formatDate(lastUpdated) + "'";
        }
        return null;
    }

    public SimpleParameterType getLastUpdatedParameterType() {
        if (this.lastUpdatedIndex != null && this.parameterTypes != null) {
            for (ParameterType parameterType : this.parameterTypes) {
                SimpleParameterType simpleParameterType;
                if (!(parameterType instanceof SimpleParameterType) || (simpleParameterType = (SimpleParameterType)parameterType).getSimpleValueType() != SimpleParameterType.SimpleValueType.DATETIME || simpleParameterType.getCollectionIndex() != this.lastUpdatedIndex.intValue()) continue;
                return simpleParameterType;
            }
        }
        return null;
    }

    public int getCollectionWeight() {
        return this.collectionWeight;
    }

    public void setCollectionWeight(int collectionWeight) {
        this.collectionWeight = collectionWeight;
    }

    public ConfigurationItemDisplayName getDisplayName() {
        return this.configurationItemDisplayName;
    }

    public void setDisplayName(ConfigurationItemDisplayName configurationItemDisplayName) {
        this.configurationItemDisplayName = configurationItemDisplayName;
    }

    public int[] getRequiredColumnIndexes() {
        return this.requiredColumnIndexes;
    }

    public void setRequiredColumnIndexes(int[] requiredColumnIndexes) {
        this.requiredColumnIndexes = requiredColumnIndexes;
    }

    public void setRequiredColumnIndexesFromString(String requiredColumnIndexesString) {
        this.requiredColumnIndexes = null;
        if (StringUtils.isNotBlank((String)requiredColumnIndexesString)) {
            int i;
            String[] requiredColumnIndexesSplitted = requiredColumnIndexesString.split(",");
            ArrayList<Integer> requiredColumnIndexesList = new ArrayList<Integer>();
            for (i = 0; i < requiredColumnIndexesSplitted.length; ++i) {
                try {
                    requiredColumnIndexesList.add(Integer.parseInt(requiredColumnIndexesSplitted[i].trim()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (requiredColumnIndexesList.size() > 0) {
                this.requiredColumnIndexes = new int[requiredColumnIndexesList.size()];
                for (i = 0; i < requiredColumnIndexesList.size(); ++i) {
                    this.requiredColumnIndexes[i] = (Integer)requiredColumnIndexesList.get(i);
                }
            }
        }
    }

    public String getRequiredColumnIndexesAsString() {
        if (this.requiredColumnIndexes == null) {
            return "";
        }
        String result = Arrays.toString(this.requiredColumnIndexes);
        result = result.substring(1, result.length() - 1);
        return result;
    }

    public boolean isFilterVisible() {
        return this.filterVisible;
    }

    public void setFilterVisible(boolean filterVisible) {
        this.filterVisible = filterVisible;
    }

    public boolean isCollectable() {
        return this.collectable;
    }

    public void setCollectable(boolean collectable) {
        this.collectable = collectable;
    }

    public List<ParameterType> getParameterTypes() {
        return this.parameterTypes;
    }

    public ParameterType getParameterTypeByKey(String parameterTypeKey) {
        return this.parameterTypesByKey.get(parameterTypeKey);
    }

    public void setParameterTypes(Collection<ParameterType> parameterTypes) {
        this.parameterTypesByKey.clear();
        for (ParameterType parameterType : parameterTypes) {
            this.parameterTypesByKey.put(parameterType.getKey(), parameterType);
        }
        this.parameterTypes.clear();
        this.parameterTypes.addAll(parameterTypes);
    }

    public void clearParameterTypes() {
        this.parameterTypesByKey.clear();
        this.parameterTypes.clear();
        this.failedParameterKeys.clear();
    }

    public List<ParameterType> getSortedParameterTypes() {
        ArrayList<ParameterType> sortedList = new ArrayList<ParameterType>(this.parameterTypes);
        Collections.sort(sortedList, new Comparator<ParameterType>(){

            @Override
            public int compare(ParameterType type1, ParameterType type2) {
                if (type1 == null) {
                    return 1;
                }
                if (type2 == null) {
                    return 2;
                }
                return Integer.compare(type1.getViewWeight(), type2.getViewWeight());
            }
        });
        return sortedList;
    }

    public void addParameterType(ParameterType parameterType) {
        this.parameterTypesByKey.put(parameterType.getKey(), parameterType);
        this.parameterTypes.add(parameterType);
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public void setPluralName(String pluralName) {
        this.pluralName = pluralName;
    }

    public boolean isDefaultFilterEnabled() {
        return this.defaultFilterEnabled;
    }

    public void setDefaultFilterEnabled(boolean defaultFilterEnabled) {
        this.defaultFilterEnabled = defaultFilterEnabled;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConfigurationItemType)) {
            return false;
        }
        if (this.key == null) {
            return ((ConfigurationItemType)obj).getKey() == null;
        }
        return this.key.equals(((ConfigurationItemType)obj).getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "Key: " + this.key + "\nName: " + this.name + "\nPluralName: " + this.pluralName + "\nlinkComponent: " + this.linkComponent + "\nQuery: " + this.query + "\nIdIndex: " + this.idIndex + "\nWeight: " + this.collectionWeight + "\nDisplayName: " + this.configurationItemDisplayName + "\nRequired Columns: " + this.requiredColumnIndexes + "\nFilter visible: " + this.filterVisible + "\nCollectable: " + this.collectable + "\nDefault filter enabled: " + this.defaultFilterEnabled + "\nParams: " + this.parameterTypes.toString();
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        output.addParameter(CONF_ITEM_TYPE_KEY, this.getKey());
        output.addParameter(CONF_ITEM_TYPE_NAME, this.getName());
        output.addParameter(CONF_ITEM_TYPE_PLURAL_NAME, this.getPluralName());
        output.addParameter(CONF_ITEM_TYPE_DESCRIPTION, this.getDescription());
        output.addParameter(CONF_ITEM_TYPE_LINK_COMPONENT, this.getLinkComponent());
        output.addParameter(CONF_ITEM_TYPE_DOQL, this.getQuery().toString());
        output.addParameter(CONF_ITEM_TYPE_ID_INDEX, this.getIdIndex());
        output.addParameter(CONF_ITEM_TYPE_LAST_UPDATED_INDEX, this.lastUpdatedIndex);
        output.addParameter(CONF_ITEM_TYPE_WEIGHT, this.getCollectionWeight());
        output.addParameter(CONF_ITEM_TYPE_DISPLAY_NAME, this.getDisplayName().getFormat());
        output.addParameter(CONF_ITEM_TYPE_REQUIRED_INDEXES, this.getRequiredColumnIndexesAsString());
        output.addParameter(CONF_ITEM_TYPE_FILTER_VISIBLE, this.isFilterVisible());
        output.addParameter(CONF_ITEM_TYPE_COLLECTABLE, this.isCollectable());
        output.addParameter(CONF_ITEM_TYPE_DEFAULT_FILTER_ENABLED, this.isDefaultFilterEnabled());
        ParameterAcceptor parameterTypesAcceptor = output.generateChildAcceptorObject(CONF_ITEM_TYPE_PARAMETR_TYPES);
        ArrayList<String> orderedKeys = new ArrayList<String>();
        for (ParameterType parameterType : this.getSortedParameterTypes()) {
            ParameterAcceptor parameterTypeAcceptor = parameterTypesAcceptor.generateChildAcceptorObject(parameterType.getKey());
            parameterType.saveToAcceptor(parameterTypeAcceptor);
            orderedKeys.add(parameterType.getKey());
        }
        output.addParameter(CONF_ITEM_ORDERED_PARAMETER_TYPES_KEYS, orderedKeys);
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.clearParameterTypes();
        this.setKey(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_KEY)));
        this.setName(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_NAME)));
        this.setPluralName(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_PLURAL_NAME)));
        this.setDescription(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_DESCRIPTION)));
        this.setLinkComponent(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_LINK_COMPONENT)));
        this.setIdIndex(ObjectUtils.intValue(input.get(CONF_ITEM_TYPE_ID_INDEX)));
        this.idIndexString = ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_ID_INDEX));
        this.lastUpdatedIndexString = ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_LAST_UPDATED_INDEX));
        if (StringUtils.isNotBlank((String)this.lastUpdatedIndexString)) {
            this.setLastUpdatedIndex(ObjectUtils.intValue(input.get(CONF_ITEM_TYPE_LAST_UPDATED_INDEX)));
        } else {
            this.lastUpdatedIndex = null;
        }
        this.setCollectionWeight(ObjectUtils.intValue(input.get(CONF_ITEM_TYPE_WEIGHT)));
        this.collectionWeightString = ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_WEIGHT));
        this.setFilterVisible(ObjectUtils.booleanValue(input.get(CONF_ITEM_TYPE_FILTER_VISIBLE), true));
        this.setCollectable(ObjectUtils.booleanValue(input.get(CONF_ITEM_TYPE_COLLECTABLE), true));
        this.setDefaultFilterEnabled(ObjectUtils.booleanValue(input.get(CONF_ITEM_TYPE_DEFAULT_FILTER_ENABLED), true));
        try {
            String DOQLString = ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_DOQL)).trim();
            DOQLQuery query = new DOQLQuery(DOQLString);
            this.setQuery(query);
        }
        catch (D42Exception e) {
            log.error((Object)"Error parsing DOQL", (Throwable)e);
        }
        this.setDisplayName(new ConfigurationItemDisplayName(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_DISPLAY_NAME))));
        this.setRequiredColumnIndexesFromString(ObjectUtils.stringValue(input.get(CONF_ITEM_TYPE_REQUIRED_INDEXES)));
        ParameterDonor parameterTypesDonor = input.extractNestedObject(CONF_ITEM_TYPE_PARAMETR_TYPES);
        if (parameterTypesDonor != null) {
            for (String key : parameterTypesDonor.keys()) {
                ParameterDonor parameterTypeDonor = parameterTypesDonor.extractNestedObject(key);
                if (parameterTypeDonor != null) {
                    ParameterType parameterType = ParameterType.createParameter(parameterTypeDonor);
                    if (parameterType != null) {
                        this.addParameterType(parameterType);
                        continue;
                    }
                    this.failedParameterKeys.add(key);
                    continue;
                }
                this.failedParameterKeys.add(key);
            }
        }
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(CONF_ITEM_TYPE_KEY);
        output.removeParameter(CONF_ITEM_TYPE_NAME);
        output.removeParameter(CONF_ITEM_TYPE_PLURAL_NAME);
        output.removeParameter(CONF_ITEM_TYPE_DESCRIPTION);
        output.removeParameter(CONF_ITEM_TYPE_LINK_COMPONENT);
        output.removeParameter(CONF_ITEM_TYPE_DOQL);
        output.removeParameter(CONF_ITEM_TYPE_LAST_UPDATED_INDEX);
        output.removeParameter(CONF_ITEM_TYPE_ID_INDEX);
        output.removeParameter(CONF_ITEM_TYPE_WEIGHT);
        output.removeParameter(CONF_ITEM_TYPE_DISPLAY_NAME);
        output.removeParameter(CONF_ITEM_TYPE_REQUIRED_INDEXES);
        output.removeParameter(CONF_ITEM_TYPE_FILTER_VISIBLE);
        output.removeParameter(CONF_ITEM_TYPE_COLLECTABLE);
        output.removeParameter(CONF_ITEM_TYPE_DEFAULT_FILTER_ENABLED);
    }

    public void validate(I18nResolver i18n, ErrorHolder errorHolder, Schema oldSchema) {
        if (StringUtils.isBlank((String)this.key)) {
            errorHolder.addError(CONF_ITEM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.key.error.blank"));
        } else {
            if (oldSchema != null && oldSchema.getByKey(this.key) != null) {
                errorHolder.addError(CONF_ITEM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.key.error.unique"));
            }
            if (!this.key.matches("[A-Za-z0-9_]+")) {
                errorHolder.addError(CONF_ITEM_TYPE_KEY, i18n.getText("com.device42.atlas.page.configuration.key.error.alphanumeric"));
            }
        }
        if (StringUtils.isBlank((String)this.name)) {
            errorHolder.addError(CONF_ITEM_TYPE_NAME, i18n.getText("com.device42.atlas.page.configuration.name.error.blank"));
        }
        if (StringUtils.isBlank((String)this.pluralName)) {
            errorHolder.addError(CONF_ITEM_TYPE_PLURAL_NAME, i18n.getText("com.device42.atlas.page.configuration.pluralname.error.blank"));
        }
        if (StringUtils.isBlank((String)this.linkComponent)) {
            errorHolder.addError(CONF_ITEM_TYPE_LINK_COMPONENT, i18n.getText("com.device42.atlas.page.configuration.linkcomponent.error.blank"));
        }
        if (this.query == null || StringUtils.isBlank((String)this.query.toString())) {
            errorHolder.addError(CONF_ITEM_TYPE_DOQL, i18n.getText("com.device42.atlas.page.configuration.query.error.blank"));
        } else if (this.query.hasErrors()) {
            errorHolder.addError(CONF_ITEM_TYPE_DOQL, this.query.getErrorMessage(i18n));
        }
        if (StringUtils.isBlank((String)this.idIndexString)) {
            errorHolder.addError(CONF_ITEM_TYPE_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.idindex.error.blank"));
        } else {
            try {
                Integer.parseInt(this.idIndexString);
                if (this.idIndex < 0) {
                    errorHolder.addError(CONF_ITEM_TYPE_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.idindex.error.negative"));
                }
            }
            catch (Exception e) {
                errorHolder.addError(CONF_ITEM_TYPE_ID_INDEX, i18n.getText("com.device42.atlas.page.configuration.idindex.error.format"));
            }
        }
        if (!StringUtils.isBlank((String)this.lastUpdatedIndexString)) {
            try {
                int checkIndex = Integer.parseInt(this.lastUpdatedIndexString);
                if (checkIndex < 0) {
                    errorHolder.addError(CONF_ITEM_TYPE_LAST_UPDATED_INDEX, i18n.getText("com.device42.atlas.page.configuration.lastupdated.error.negative"));
                }
            }
            catch (Exception e) {
                errorHolder.addError(CONF_ITEM_TYPE_LAST_UPDATED_INDEX, i18n.getText("com.device42.atlas.page.configuration.lastupdated.error.format"));
            }
        }
        if (StringUtils.isBlank((String)this.collectionWeightString)) {
            errorHolder.addError(CONF_ITEM_TYPE_WEIGHT, i18n.getText("com.device42.atlas.page.configuration.collectionweight.blank"));
        } else {
            try {
                Integer.parseInt(this.collectionWeightString);
            }
            catch (Exception e) {
                errorHolder.addError(CONF_ITEM_TYPE_WEIGHT, i18n.getText("com.device42.atlas.page.configuration.collectionweight.error.format"));
            }
        }
        if (this.configurationItemDisplayName == null || StringUtils.isBlank((String)this.configurationItemDisplayName.getFormat())) {
            errorHolder.addError(CONF_ITEM_TYPE_DISPLAY_NAME, i18n.getText("com.device42.atlas.page.configuration.displayname.error.blank"));
        }
        if (StringUtils.isNotBlank((String)this.requiredColumnIndexesString)) {
            try {
                String[] splittedIndexStrings = this.requiredColumnIndexesString.split(",");
                for (String splittedIndexString : splittedIndexStrings) {
                    int splittedIndex = Integer.parseInt(splittedIndexString);
                    if (splittedIndex >= 0) continue;
                    errorHolder.addError(CONF_ITEM_TYPE_REQUIRED_INDEXES, i18n.getText("com.device42.atlas.page.configuration.requiredindexes.error.format"));
                    break;
                }
            }
            catch (Exception e) {
                errorHolder.addError(CONF_ITEM_TYPE_REQUIRED_INDEXES, i18n.getText("com.device42.atlas.page.configuration.requiredindexes.error.format"));
            }
        }
        if (this.parameterTypes != null) {
            ErrorHolder parametersErrorHolder = errorHolder.getNestedErrorHolder(CONF_ITEM_TYPE_PARAMETR_TYPES);
            if (this.failedParameterKeys.size() > 0) {
                parametersErrorHolder.addErrorMessage(i18n.getText("com.device42.atlas.page.configuration.parameter.extract.error", new Serializable[]{ObjectUtils.stringJoin(", ", this.failedParameterKeys)}));
            }
            for (ParameterType parameterType : this.parameterTypes) {
                ErrorHolder parameterErrorHolder = parametersErrorHolder.getNestedErrorHolder(parameterType.getKey());
                parameterType.validate(i18n, parameterErrorHolder, null);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getLastUpdatedIndex() {
        return this.lastUpdatedIndex;
    }

    public void setLastUpdatedIndex(Integer lastUpdatedIndex) {
        this.lastUpdatedIndex = lastUpdatedIndex;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdatedIndex != null;
    }

    public static class DOQLQuery {
        public static final String SEPARATOR = " ";
        public static final String SELECT_TOKEN = "SELECT";
        public static final String FROM_TOKEN = "FROM";
        public static final HashSet<String> JOIN_TOKENS = new HashSet<String>(Arrays.asList("JOIN", "INNER", "LEFT", "RIGHT", "FULL", "OUTER"));
        public static final String WHERE_TOKEN = "WHERE";
        public static final String ORDER_BY_START_TOKEN = "ORDER";
        public static final String BY_TOKEN = "BY";
        public static final String ORDER_BY_TOKEN = "ORDER BY";
        public static final String GROUP_TOKEN = "GROUP";
        public static final String HAVING_TOKEN = "HAVING";
        public static final String COUNT_TOKEN = "COUNT(*)";
        public static final String ADDITIONAL_WHERE_LEFT_TOKEN = "(";
        public static final String ADDITIONAL_WHERE_MID_TOKEN = ") AND (";
        public static final String ADDITIONAL_WHERE_RIGHT_TOKEN = ")";
        public static final String LIMIT_TOKEN = "LIMIT";
        public static final String OFFSET_TOKEN = "OFFSET";
        private String errorMessageKey = null;
        private String rawQuery;
        private String listedColumns;
        private String from;
        private String joins;
        private String group;
        private String where;
        private String orderBy;
        private boolean hasJoins;
        private boolean hasGroupBy;

        public DOQLQuery(String query) throws D42Exception {
            this.loadFromQuery(query);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void loadFromQuery(String query) throws D42Exception {
            MutliLineStringTokenizer.TokenType tokenType;
            this.rawQuery = query;
            MutliLineStringTokenizer st = new MutliLineStringTokenizer(query);
            st.setIncludeQuotesInToken(true);
            st.setReturnSpaces(false);
            HashSet<String> commandTokens = new HashSet<String>(Arrays.asList(SELECT_TOKEN, FROM_TOKEN, WHERE_TOKEN, ORDER_BY_START_TOKEN, BY_TOKEN, GROUP_TOKEN, HAVING_TOKEN, LIMIT_TOKEN, OFFSET_TOKEN));
            commandTokens.addAll(JOIN_TOKENS);
            String currentCommandToken = null;
            StringBuilder collectedData = new StringBuilder();
            boolean firstToken = true;
            int order_count = 0;
            do {
                String commandToken;
                block43: {
                    String currentToken;
                    block44: {
                        block47: {
                            block46: {
                                block45: {
                                    tokenType = st.nextToken();
                                    currentToken = st.getCurrentToken();
                                    commandToken = null;
                                    if (currentToken != null) {
                                        String string = commandToken = commandTokens.contains(currentToken.toUpperCase()) ? currentToken.toUpperCase() : null;
                                    }
                                    if (commandToken == null) break block44;
                                    if (!SELECT_TOKEN.equals(commandToken)) break block45;
                                    if (!firstToken) {
                                        this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.selectinside";
                                        return;
                                    }
                                    currentCommandToken = commandToken;
                                    collectedData = new StringBuilder();
                                    break block43;
                                }
                                if (!FROM_TOKEN.equals(commandToken)) break block46;
                                if (!SELECT_TOKEN.equals(currentCommandToken) && !ORDER_BY_START_TOKEN.equals(currentCommandToken)) {
                                    this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.frominside";
                                    return;
                                }
                                this.listedColumns = collectedData.toString().trim();
                                collectedData = new StringBuilder();
                                currentCommandToken = commandToken;
                                break block43;
                            }
                            if (!JOIN_TOKENS.contains(commandToken)) break block47;
                            if (this.hasJoins) {
                                collectedData.append(SEPARATOR).append(commandToken);
                                break block43;
                            } else {
                                if (!FROM_TOKEN.equals(currentCommandToken)) {
                                    this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.whereinside";
                                    return;
                                }
                                this.from = collectedData.toString().trim();
                                this.hasJoins = true;
                                collectedData = new StringBuilder();
                                collectedData.append(commandToken);
                                currentCommandToken = commandToken;
                            }
                            break block43;
                        }
                        if (WHERE_TOKEN.equals(commandToken)) {
                            if (JOIN_TOKENS.contains(currentCommandToken)) {
                                this.joins = collectedData.toString().trim();
                            } else {
                                if (!FROM_TOKEN.equals(currentCommandToken)) {
                                    this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.whereinside";
                                    return;
                                }
                                this.from = collectedData.toString().trim();
                            }
                            collectedData = new StringBuilder();
                            currentCommandToken = commandToken;
                            break block43;
                        } else if (ORDER_BY_START_TOKEN.equals(commandToken)) {
                            boolean orderByFound = false;
                            st.nextToken();
                            currentToken = st.getCurrentToken();
                            if (currentToken != null && BY_TOKEN.equals(currentToken)) {
                                orderByFound = true;
                            }
                            if (!orderByFound) {
                                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.by";
                                return;
                            }
                            if (JOIN_TOKENS.contains(currentCommandToken)) {
                                this.joins = collectedData.toString();
                            } else if (FROM_TOKEN.equals(currentCommandToken)) {
                                this.from = collectedData.toString();
                            } else if (GROUP_TOKEN.equals(currentCommandToken)) {
                                this.group = collectedData.toString();
                            } else if (WHERE_TOKEN.equals(currentCommandToken)) {
                                this.where = collectedData.toString();
                            } else if (query.toLowerCase().indexOf("array_agg") != -1 && order_count == 0 && this.token_count(query, ORDER_BY_START_TOKEN) > 1) {
                                ++order_count;
                                collectedData.append(SEPARATOR).append(ORDER_BY_TOKEN);
                                continue;
                            }
                            collectedData = new StringBuilder();
                            currentCommandToken = commandToken;
                            break block43;
                        } else {
                            if (LIMIT_TOKEN.equals(commandToken) || OFFSET_TOKEN.equals(commandToken)) {
                                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.usedtoken";
                                return;
                            }
                            if (!GROUP_TOKEN.equals(commandToken)) {
                                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.unsupportedtoken";
                                return;
                            }
                            boolean groupByFound = false;
                            st.nextToken();
                            currentToken = st.getCurrentToken();
                            if (currentToken != null && BY_TOKEN.equals(currentToken)) {
                                groupByFound = true;
                            }
                            if (!groupByFound) {
                                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.by";
                                return;
                            }
                            if (JOIN_TOKENS.contains(currentCommandToken)) {
                                this.joins = collectedData.toString();
                            } else if (FROM_TOKEN.equals(currentCommandToken)) {
                                this.from = collectedData.toString();
                            } else {
                                if (!WHERE_TOKEN.equals(currentCommandToken)) {
                                    this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.groupinside";
                                    return;
                                }
                                this.where = collectedData.toString();
                            }
                            this.hasGroupBy = true;
                            collectedData = new StringBuilder();
                            currentCommandToken = commandToken;
                        }
                        break block43;
                    }
                    collectedData.append(SEPARATOR).append(currentToken == null ? "" : currentToken);
                }
                if (!firstToken) continue;
                if (!SELECT_TOKEN.equalsIgnoreCase(commandToken)) {
                    this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.noselect";
                    return;
                }
                firstToken = false;
            } while (tokenType != MutliLineStringTokenizer.TokenType.EOF);
            if (FROM_TOKEN.equals(currentCommandToken)) {
                this.from = collectedData.toString().trim();
            } else if (WHERE_TOKEN.equals(currentCommandToken)) {
                this.where = collectedData.toString().trim();
            } else if (ORDER_BY_START_TOKEN.equals(currentCommandToken)) {
                this.orderBy = collectedData.toString().trim();
            }
            if (StringUtils.isBlank((String)this.listedColumns)) {
                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.nocolumns";
                return;
            }
            if (StringUtils.isBlank((String)this.from)) {
                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.nofrom";
                return;
            }
            if (StringUtils.isBlank((String)this.orderBy)) {
                this.errorMessageKey = "com.device42.atlas.page.configuration.query.error.noorderby";
            }
        }

        public boolean hasErrors() {
            return StringUtils.isNotBlank((String)this.errorMessageKey);
        }

        public String getErrorMessage(I18nResolver i18n) {
            if (this.hasErrors()) {
                return i18n.getText(this.errorMessageKey);
            }
            return "No error key";
        }

        public String getListedColumns() {
            return this.listedColumns;
        }

        public String[] getSplittedListedColumns() {
            String[] splittedListedColumns = null;
            if (this.listedColumns != null) {
                splittedListedColumns = this.listedColumns.split(",");
                for (int i = 0; i < splittedListedColumns.length; ++i) {
                    splittedListedColumns[i] = splittedListedColumns[i].trim();
                }
            }
            return splittedListedColumns;
        }

        public String getListedColumnById(int id) {
            String[] splittedListedColumns = this.getSplittedListedColumns();
            if (id >= 0 && id < splittedListedColumns.length) {
                return splittedListedColumns[id];
            }
            return null;
        }

        public String getFrom() {
            return this.from;
        }

        public String getWhere() {
            return this.where;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public String getJoins() {
            return this.joins;
        }

        public String getGroup() {
            return this.group;
        }

        public static String andWhere(String firstWherePart, String secondWherePart) {
            StringBuilder result = new StringBuilder();
            if (StringUtils.isNotBlank((String)firstWherePart) || StringUtils.isNotBlank((String)secondWherePart)) {
                result.append(SEPARATOR).append(ADDITIONAL_WHERE_LEFT_TOKEN);
                if (StringUtils.isNotBlank((String)firstWherePart)) {
                    result.append(firstWherePart);
                    if (StringUtils.isNotBlank((String)secondWherePart)) {
                        result.append(ADDITIONAL_WHERE_MID_TOKEN).append(secondWherePart);
                    }
                } else {
                    result.append(secondWherePart);
                }
                result.append(ADDITIONAL_WHERE_RIGHT_TOKEN);
            }
            return result.toString();
        }

        public String getRequest(String additionalWhere, long limit, long offset) {
            String fullWherePart;
            StringBuilder result = new StringBuilder();
            result.append(SELECT_TOKEN).append(SEPARATOR).append(this.listedColumns).append(SEPARATOR).append(FROM_TOKEN).append(SEPARATOR).append(this.from).append(SEPARATOR);
            if (this.hasJoins) {
                result.append(this.joins).append(SEPARATOR);
            }
            if (StringUtils.isNotBlank((String)(fullWherePart = DOQLQuery.andWhere(this.where, additionalWhere)))) {
                result.append(WHERE_TOKEN).append(SEPARATOR);
                result.append(fullWherePart).append(SEPARATOR);
            }
            if (this.hasGroupBy) {
                result.append(GROUP_TOKEN).append(SEPARATOR).append(BY_TOKEN).append(SEPARATOR).append(this.group).append(SEPARATOR);
            }
            result.append(ORDER_BY_TOKEN).append(SEPARATOR).append(this.orderBy).append(SEPARATOR);
            result.append(LIMIT_TOKEN).append(SEPARATOR).append(limit).append(SEPARATOR).append(OFFSET_TOKEN).append(SEPARATOR).append(offset);
            return result.toString();
        }

        public String getCountRequest(String additionalWhere) {
            StringBuilder result = new StringBuilder();
            result.append(SELECT_TOKEN).append(SEPARATOR).append(COUNT_TOKEN).append(SEPARATOR).append(FROM_TOKEN).append(SEPARATOR).append(this.from).append(SEPARATOR);
            String fullWherePart = DOQLQuery.andWhere(this.where, additionalWhere);
            if (StringUtils.isNotBlank((String)fullWherePart)) {
                result.append(WHERE_TOKEN).append(SEPARATOR);
                result.append(fullWherePart).append(SEPARATOR);
            }
            return result.toString();
        }

        public String toString() {
            return this.rawQuery;
        }

        public String getRawQuery() {
            return this.rawQuery;
        }

        public void setRawQuery(String rawQuery) {
            this.rawQuery = rawQuery;
        }

        public Integer token_count(String query, String token) {
            String[] temp = query.split(SEPARATOR);
            Integer count = 0;
            for (int i = 0; i < temp.length; ++i) {
                if (!token.equalsIgnoreCase(temp[i])) continue;
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            return count;
        }
    }
}

