/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core.schema;

import com.device42.atlas.common.model.core.ConfigurationItem;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.schema.ParameterType;
import java.util.regex.Matcher;

public class ConfigurationItemDisplayName {
    public static final String TOKEN = "%";
    public static final String ID_TOKEN = "~id~";
    private String format;

    public String getFormat() {
        return this.format;
    }

    public ConfigurationItemDisplayName(String format) {
        this.format = format;
    }

    private String tokenizeParameterKey(String parameterKey) {
        StringBuilder result = new StringBuilder();
        result.append(TOKEN).append(parameterKey).append(TOKEN);
        return result.toString();
    }

    public String render(ConfigurationItem ci) {
        String renderedName = this.format;
        if (ci != null) {
            renderedName = renderedName.replaceAll(ID_TOKEN, Long.toString(ci.getStorageId()));
            if (ci.getType() != null && ci.getType().getParameterTypes() != null) {
                for (ParameterType parameterType : ci.getType().getParameterTypes()) {
                    Parameter parameter = ci.getParameter(parameterType);
                    String replaceValue = parameter != null ? Matcher.quoteReplacement(parameter.getValue()) : "";
                    renderedName = renderedName.replaceFirst(this.tokenizeParameterKey(parameterType.getKey()), replaceValue);
                }
            }
        }
        return renderedName;
    }

    public static ConfigurationItemDisplayName createSimpleDisplayName() {
        return new ConfigurationItemDisplayName(ID_TOKEN);
    }
}

