/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model.core;

import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.ConfigurationItemParameter;
import com.device42.atlas.common.model.core.ConfigurationItemState;
import com.device42.atlas.common.model.core.MultiConfigurationItemParameter;
import com.device42.atlas.common.model.core.MultiParameter;
import com.device42.atlas.common.model.core.Parameter;
import com.device42.atlas.common.model.core.ParameterFilter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConfigurationItem
implements Iterable<Parameter> {
    private ConfigurationItemType type;
    private long id;
    private long storageId;
    private ConfigurationItemState activityState = ConfigurationItemState.ACTIVE;
    private Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();

    public ConfigurationItem(@Nonnull ConfigurationItemType type) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        this.type = type;
    }

    public Date getLastUpdatedDate() {
        SimpleParameterType lastUpdatedParameterType;
        if (this.type.hasLastUpdated() && (lastUpdatedParameterType = this.type.getLastUpdatedParameterType()) != null) {
            Parameter parameter = this.getParameter(lastUpdatedParameterType);
            return ObjectUtils.dateValue(parameter.getValue());
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        ParameterType parameterType = parameter.getType();
        if (this.parameters.containsKey(parameterType.getKey())) {
            Parameter existParameter = this.parameters.get(parameterType.getKey());
            if (existParameter instanceof ConfigurationItemParameter) {
                MultiConfigurationItemParameter existMultiParameter = null;
                if (existParameter instanceof MultiConfigurationItemParameter) {
                    existMultiParameter = (MultiConfigurationItemParameter)existParameter;
                } else {
                    existMultiParameter = new MultiConfigurationItemParameter(parameterType);
                    existMultiParameter.addParameter((ConfigurationItemParameter)existParameter);
                    this.parameters.put(parameterType.getKey(), existMultiParameter);
                }
                existMultiParameter.addParameter((ConfigurationItemParameter)parameter);
            } else {
                MultiParameter existMultiParameter = null;
                if (existParameter instanceof MultiParameter) {
                    existMultiParameter = (MultiParameter)existParameter;
                } else {
                    existMultiParameter = new MultiParameter(parameterType);
                    existMultiParameter.addParameter(existParameter);
                    this.parameters.put(parameterType.getKey(), existMultiParameter);
                }
                existMultiParameter.addParameter(parameter);
            }
        } else {
            this.parameters.put(parameterType.getKey(), parameter);
        }
    }

    public ConfigurationItemType getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getStorageId() {
        return this.storageId;
    }

    public void setStorageId(long storageId) {
        this.storageId = storageId;
    }

    public String getDisplayName() {
        if (this.type != null) {
            return this.type.getDisplayName().render(this);
        }
        return "";
    }

    public Parameter getParameter(@Nonnull ParameterType parameterType) {
        return this.parameters.get(parameterType.getKey());
    }

    public boolean isActive() {
        return this.activityState == ConfigurationItemState.ACTIVE;
    }

    public ConfigurationItemState getActivityState() {
        return this.activityState;
    }

    public void setActivityState(ConfigurationItemState activityState) {
        this.activityState = activityState;
    }

    private List<Parameter> getOrderedParameters() {
        ArrayList<Parameter> sortedList = new ArrayList<Parameter>(this.parameters.values());
        Collections.sort(sortedList, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter type1, Parameter type2) {
                if (type1 == null || type1.getType() == null) {
                    return 1;
                }
                if (type2 == null || type2.getType() == null) {
                    return 2;
                }
                return Integer.compare(type1.getType().getViewWeight(), type2.getType().getViewWeight());
            }
        });
        return sortedList;
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.getOrderedParameters().iterator();
    }

    public void applyConfigurationItemFilter(ConfigurationItemFilter ciFilter) {
        if (ciFilter != null) {
            for (ParameterFilter parameterFilter : ciFilter) {
                if (parameterFilter.isSwitchedOn()) continue;
                this.parameters.remove(parameterFilter.getType().getKey());
            }
        }
    }

    public boolean checkConfigurationItemFilter(ConfigurationItemFilter ciFilter) {
        for (ParameterFilter parameterFilter : ciFilter) {
            Parameter parameter;
            if (parameterFilter.checkParameter(parameter = this.getParameter(parameterFilter.getType()))) continue;
            return false;
        }
        return true;
    }
}

