/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.model;

import com.device42.atlas.common.manager.D42DataUpdaterMonitor;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Date;
import javax.annotation.Nonnull;

public class D42ConnectionInfo
implements Parameterizable {
    public static final String TOKEN_BASE_URL = "baseUrl";
    public static final String TOKEN_USERNAME = "username";
    public static final String TOKEN_PASSWORD = "password";
    public static final String TOKEN_CRON = "cron";
    public static final String TOKEN_NEXT_UPDATE_DATE = "nextUpdate";
    public static final String TOKEN_CONFIGURED = "configured";
    public static final String TOKEN_LIMIT = "limit";
    public static final String TOKEN_DEFAULT_LIMIT = "defaultLimit";
    public static final int DEFAULT_LIMIT = 1000;
    public static final String TOKEN_SELECT_LIMIT = "selectLimit";
    public static final String TOKEN_SELECT_DEFAULT_LIMIT = "selectDefaultLimit";
    public static final int SELECT_DEFAULT_LIMIT = 50;
    private String baseUrl;
    private String username;
    private String password;
    private String cron;
    private int limit;
    private int selectLimit;

    public D42ConnectionInfo(ParameterDonor params) {
        if (params != null) {
            this.loadFromDonor(params);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getDefaultLimit() {
        if (this.limit > 0) {
            return this.limit;
        }
        return 1000;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public int getSelectDefaultLimit() {
        if (this.selectLimit > 0) {
            return this.selectLimit;
        }
        return 50;
    }

    public void setSelectLimit(int selectLimit) {
        this.selectLimit = selectLimit;
    }

    public boolean isConfigured() {
        return ObjectUtils.isObjectsNotNull(this.baseUrl, this.username, this.password);
    }

    public String toString() {
        return "D42ConnectionInfo [baseUrl=" + this.baseUrl + ", username=" + this.username + ", password=" + this.password + ", type=]";
    }

    @Override
    public void saveToAcceptor(@Nonnull ParameterAcceptor output) {
        this.setAcceptorParameters(output, null);
    }

    @Override
    public void loadFromDonor(@Nonnull ParameterDonor input) {
        this.baseUrl = ObjectUtils.stringValue(input.get(TOKEN_BASE_URL));
        this.username = ObjectUtils.stringValue(input.get(TOKEN_USERNAME));
        this.password = ObjectUtils.stringValue(input.get(TOKEN_PASSWORD));
        this.cron = ObjectUtils.stringValue(input.get(TOKEN_CRON));
        this.limit = ObjectUtils.intValue(input.get(TOKEN_LIMIT));
        this.selectLimit = ObjectUtils.intValue(input.get(TOKEN_SELECT_LIMIT));
    }

    public void setAcceptorParameters(@Nonnull ParameterAcceptor output, D42DataUpdaterMonitor monitor) {
        output.addParameter(TOKEN_BASE_URL, this.getBaseUrl());
        output.addParameter(TOKEN_USERNAME, this.getUsername());
        output.addParameter(TOKEN_PASSWORD, this.getPassword());
        output.addParameter(TOKEN_CRON, this.getCron());
        output.addParameter(TOKEN_LIMIT, this.getLimit());
        output.addParameter(TOKEN_DEFAULT_LIMIT, this.getDefaultLimit());
        output.addParameter(TOKEN_SELECT_LIMIT, this.getSelectLimit());
        output.addParameter(TOKEN_SELECT_DEFAULT_LIMIT, this.getSelectDefaultLimit());
        if (monitor != null) {
            Date nextUpdateDate = null;
            try {
                nextUpdateDate = monitor.getNextFireDate();
            }
            catch (D42Exception d42Exception) {
                // empty catch block
            }
            output.addParameter(TOKEN_NEXT_UPDATE_DATE, ObjectUtils.formatDate(nextUpdateDate));
        }
        output.addParameter(TOKEN_CONFIGURED, this.isConfigured());
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(TOKEN_BASE_URL);
        output.removeParameter(TOKEN_USERNAME);
        output.removeParameter(TOKEN_PASSWORD);
        output.removeParameter(TOKEN_CRON);
        output.removeParameter(TOKEN_LIMIT);
        output.removeParameter(TOKEN_DEFAULT_LIMIT);
        output.removeParameter(TOKEN_SELECT_LIMIT);
        output.removeParameter(TOKEN_SELECT_DEFAULT_LIMIT);
    }
}

