/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.manager;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.I18nResolver;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42FilterServletProcessor;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.serialization.ErrorHolder;
import com.device42.atlas.common.model.serialization.MapDonor;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class D42FilterServletProcessorImpl
implements D42FilterServletProcessor {
    Logger.Log log = Logger.getInstance(D42FilterServletProcessorImpl.class);
    protected static final String ACTION_SAVE_CONFIGURATION = "saveConfig";
    protected static final String ACTION_RESET_CONFIGURATION = "resetConfig";
    protected static final String ACTION_GET_FIELD_FILTER = "getFieldFilter";
    protected static final String IS_TEMPLATE = "isTemplate";
    public static final String TOKEN_FILTERS = "filters";
    public static final String TOKEN_FILTER_TEMPLATES = "filterTemplates";
    protected static String[] actions = new String[]{"saveConfig", "resetConfig", "getFieldFilter"};
    protected final D42DataManager d42DataManager;
    protected final I18nResolver i18n;
    protected final D42SettingsManager settingsManager;

    public D42FilterServletProcessorImpl(D42DataManager d42DataManager, I18nResolver i18n, D42SettingsManager settingsManager) {
        this.d42DataManager = d42DataManager;
        this.i18n = i18n;
        this.settingsManager = settingsManager;
    }

    protected abstract String getViewKey();

    protected abstract long getFirstLevelFilter(Map<String, String> var1, ErrorHolder var2);

    protected abstract long getSecondLevelFilter(Map<String, String> var1, ErrorHolder var2, boolean var3);

    protected abstract void addSecondLevelOptions(long var1, ErrorHolder var3) throws D42Exception;

    private void processGetAction(Map<String, String> parameters, ErrorHolder outputParameters, boolean isRequired) {
        long firstLevelId = this.getFirstLevelFilter(parameters, outputParameters);
        long secondLevelId = this.getSecondLevelFilter(firstLevelId, parameters, outputParameters, isRequired);
        this.log.debug((Object)("processViewAction firstLevelId = " + firstLevelId + ", secondLevelId = " + secondLevelId));
        if (!outputParameters.hasErrors()) {
            try {
                Filter filter = this.d42DataManager.getFilter(firstLevelId, secondLevelId);
                filter.setFirstLevelId(firstLevelId);
                filter.setSecondLevelId(secondLevelId);
                filter.saveToAcceptor(outputParameters);
                outputParameters.setSuccess();
                if (firstLevelId == 0L) {
                    outputParameters.addParameter(TOKEN_FILTERS, this.d42DataManager.getFilterTemplates());
                } else {
                    this.addSecondLevelOptions(firstLevelId, outputParameters);
                    outputParameters.addParameter(TOKEN_FILTER_TEMPLATES, this.d42DataManager.getFilterTemplates());
                }
            }
            catch (Exception e) {
                outputParameters.addErrorMessage("Unable to gather filters");
            }
        }
    }

    protected long getSecondLevelFilter(long firstLevelId, Map<String, String> parameters, ErrorHolder outputParameters, boolean isRequired) {
        if (firstLevelId != 0L) {
            return this.getSecondLevelFilter(parameters, outputParameters, isRequired);
        }
        return this.getSecondLevelTemplateFilterId(parameters);
    }

    protected long getSecondLevelTemplateFilterId(Map<String, String> parameters) {
        long secondLevelId = ObjectUtils.longValue(parameters.get("secondLevelId"), 0L);
        if (secondLevelId < 0L) {
            secondLevelId = new Date().getTime();
        }
        return secondLevelId;
    }

    protected boolean checkTemplate(Map<String, String> parameters, ErrorHolder outputParameters) {
        boolean isTemplate = ObjectUtils.booleanValue(parameters.get(IS_TEMPLATE), false);
        if (isTemplate) {
            outputParameters.addParameter(IS_TEMPLATE, true);
            return true;
        }
        return false;
    }

    protected String processViewAction(Map<String, String> parameters, ErrorHolder outputParameters) {
        this.processGetAction(parameters, outputParameters, false);
        return this.getViewKey();
    }

    protected String processSaveConfigurationAction(Map<String, String> parameters, ErrorHolder errorHolder) {
        long firstLevelId = this.getFirstLevelFilter(parameters, errorHolder);
        long secondLevelId = this.getSecondLevelFilter(firstLevelId, parameters, errorHolder, true);
        this.log.debug((Object)("processSaveConfigurationAction firstLevelId = " + firstLevelId + ", secondLevelId = " + secondLevelId));
        if (!errorHolder.hasErrors()) {
            Filter filter = new Filter(this.d42DataManager, new MapDonor(parameters));
            filter.setFirstLevelId(firstLevelId);
            filter.setSecondLevelId(secondLevelId);
            if (filter.isFilterValid()) {
                try {
                    D42ConnectionInfo connectionInfo = this.settingsManager.getConnectionInfo();
                    int limit = connectionInfo != null ? connectionInfo.getDefaultLimit() : 1000;
                    this.d42DataManager.setFilter(filter, limit);
                    filter.saveToAcceptor(errorHolder);
                    errorHolder.setSuccess();
                }
                catch (D42Exception e) {
                    this.log.error((Object)"Exception on filter save", (Throwable)e);
                    errorHolder.addErrorMessage(e.getMessage());
                }
            } else {
                errorHolder.addErrorMessage(this.i18n.getText("com.device42.atlas.filter.section.error.empty.option"));
            }
        }
        return null;
    }

    protected String processResetConfigurationAction(Map<String, String> parameters, ErrorHolder errorHolder) {
        long firstLevelId = this.getFirstLevelFilter(parameters, errorHolder);
        long secondLevelId = this.getSecondLevelFilter(firstLevelId, parameters, errorHolder, true);
        this.log.debug((Object)("processResetConfigurationAction firstLevelId = " + firstLevelId + ", secondLevelId = " + secondLevelId));
        if (!errorHolder.hasErrors()) {
            this.d42DataManager.removeFilter(firstLevelId, secondLevelId);
            errorHolder.setSuccess();
        }
        return null;
    }

    protected String processGetFieldFilter(Map<String, String> parameters, ErrorHolder outputParameters) {
        this.processGetAction(parameters, outputParameters, true);
        return null;
    }

    @Override
    public String processRequestServletAction(String action, Map<String, String> parameters, @Nonnull ErrorHolder outputParameters) {
        if (ACTION_SAVE_CONFIGURATION.equals(action)) {
            return this.processSaveConfigurationAction(parameters, outputParameters);
        }
        if (ACTION_RESET_CONFIGURATION.equals(action)) {
            return this.processResetConfigurationAction(parameters, outputParameters);
        }
        if (ACTION_GET_FIELD_FILTER.equals(action)) {
            return this.processGetFieldFilter(parameters, outputParameters);
        }
        return this.processViewAction(parameters, outputParameters);
    }

    @Override
    public String[] getActions() {
        return actions;
    }

    @Override
    public boolean isPostActionOnly(String actionName) {
        return ACTION_SAVE_CONFIGURATION.equals(actionName) || ACTION_RESET_CONFIGURATION.equals(actionName);
    }

    @Override
    public boolean isJson(String actionName) {
        return ACTION_SAVE_CONFIGURATION.equals(actionName) || ACTION_RESET_CONFIGURATION.equals(actionName) || ACTION_GET_FIELD_FILTER.equals(actionName);
    }
}

