/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v35;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ReferenceParameterType;
import java.util.Collection;

public class V35UpgradeExecutor
implements PluginUpgradeTask {
    private Logger.Log log = Logger.getInstance(V35UpgradeExecutor.class);
    private final D42DataManager dataManager;

    public V35UpgradeExecutor(D42DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public int getBuildNumber() {
        return 35;
    }

    public String getShortDescription() {
        return "Upgrade task for the D42 plugin v35 for JIRA or Confluence";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.log.info((Object)"Device42 schema is starting to upgrade to version 35");
        try {
            ConfigurationItemType dev = this.dataManager.getConfigurationItemTypeByKey("D");
            if (dev == null) {
                this.log.error((Object)"Item Type Device not found, skipping version 35 upgrade.");
                return null;
            }
            ConfigurationItemType.DOQLQuery devQuery = new ConfigurationItemType.DOQLQuery("SELECT view_device_v1.device_pk, view_device_v1.name, view_device_v1.last_changed, view_device_v1.asset_no, view_device_v1.serial_no, view_device_v1.uuid, view_device_v1.service_level, view_device_v1.type, view_device_v1.tags, view_customer_v1.name, view_hardware_v1.hardware_pk, view_hardware_v1.name, view_virtual_host.name, view_rack_v1.rack_pk, view_rack_v1.name, view_room_v1.room_pk, view_room_v1.name, view_building_v1.building_pk, view_building_v1.name, view_ipaddress_v1.ipaddress_pk FROM view_device_v1 LEFT JOIN view_customer_v1 ON view_device_v1.customer_fk = view_customer_v1.customer_pk LEFT JOIN view_hardware_v1 ON view_device_v1.hardware_fk = view_hardware_v1.hardware_pk LEFT JOIN view_device_v1 view_virtual_host ON view_device_v1.virtual_host_device_fk = view_virtual_host.device_pk  LEFT JOIN view_room_v1 ON view_device_v1.calculated_room_fk = view_room_v1.room_pk LEFT JOIN view_building_v1 ON view_device_v1.calculated_building_fk = view_building_v1.building_pk LEFT JOIN view_rack_v1 ON view_device_v1.calculated_rack_fk = view_rack_v1.rack_pk LEFT JOIN view_ipaddress_v1 ON view_ipaddress_v1.device_fk = view_device_v1.device_pk ORDER BY view_device_v1.device_pk");
            dev.setQuery(devQuery);
            ReferenceParameterType parameterType = new ReferenceParameterType();
            parameterType.setKey("view_device_v1_ipaddress_pk");
            parameterType.setDefaultFilterViewEnabled(true);
            parameterType.setName("IP Address");
            parameterType.setDescription("IP Address for Device");
            parameterType.setEnabled(true);
            parameterType.setSearchEnabled(true);
            parameterType.setViewWeight(1800);
            parameterType.setDefaultFilterViewEnabled(true);
            parameterType.setAdditionalTypeData("{\"configurationItemKey\":\"IP\",\"idIndex\":19,\"csvFormat\":\"~20~\"}");
            dev.addParameterType(parameterType);
            this.dataManager.saveConfigurationItemType(dev);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update parameter type in the configuration schema", (Throwable)e);
        }
        this.log.info((Object)"Upgrade to version 35 completed");
        return null;
    }

    public String getPluginKey() {
        return "com.device42.atlas.jira.d42jira";
    }
}

