/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v33;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import java.util.Collection;

public class V32_33UpgradeExecutor
implements PluginUpgradeTask {
    Logger.Log log = Logger.getInstance(V32_33UpgradeExecutor.class);
    private final D42DataManager dataManager;

    public V32_33UpgradeExecutor(D42DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public int getBuildNumber() {
        return 33;
    }

    public String getShortDescription() {
        return "Upgrade task for the D42 plugin v33 for JIRA or Confluence";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.log.info((Object)"Upgrading to version 3.3");
        try {
            ConfigurationItemType configurationItemType;
            Schema schema = this.dataManager.getSchema();
            if (!schema.isEmpty() && (configurationItemType = schema.getByKey("IP")) != null) {
                configurationItemType.setLinkComponent("ip_address");
                this.dataManager.saveConfigurationItemType(configurationItemType);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update parameter type in the configuration scheme");
        }
        this.log.info((Object)"Upgrade to version 3.3 completed");
        return null;
    }

    public String getPluginKey() {
        return "com.device42.atlas.jira.d42jira";
    }
}

