/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.v26;

import com.atlassian.extras.common.log.Logger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.device42.atlas.common.job.D42PluginUpgradeTask;
import com.device42.atlas.common.job.upgrade.AbstractUpgradeExecutor;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.core.ConfigurationItemFilter;
import com.device42.atlas.common.model.core.Filter;
import com.device42.atlas.common.model.core.ParameterFilter;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.model.serialization.PluginSettingsAcceptor;
import com.device42.atlas.common.model.serialization.PluginSettingsDonor;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public abstract class V25_26UpgradeExecutor
extends AbstractUpgradeExecutor {
    private static final String DEVICE42_SETTINGS_KEY = "DEVICE42_SETTINGS";
    private static final String DEVICE42_PROJECT_PREFIX = "_PROJECT_";
    private static final String DEVICE42_CUSTOMFIELD_PREFIX = "_CUSTOMFIELD_";
    private static final String DEVICE42_FILTER_DEVICE_KEY = "D";
    private static final String DEVICE42_FILTER_DEVICE_CUSTOMER_KEY = "customer";
    private static final String DEVICE42_FILTER_DEVICE_TYPE_KEY = "type";
    private static final String DEVICE42_FILTER_DEVICE_SERVICE_LEVEL_KEY = "serviceLevel";
    private static final String DEVICE42_FILTER_DEVICE_TAGS_KEY = "tags";
    private static final String DEVICE42_FILTER_RACK_KEY = "R";
    private static final String DEVICE42_FILTER_RACK_BUILDING_KEY = "building";
    private static final String DEVICE42_FILTER_RACK_ROOM_KEY = "room";
    private static final String DEVICE42_FILTER_PDU_KEY = "U";
    private static final String DEVICE42_FILTER_PDU_NAME_KEY = "name";
    private static final String DEVICE42_FILTER_PART_KEY = "P";
    private static final String DEVICE42_FILTER_PART_MODEL_KEY = "partModel";
    private static Logger.Log log = Logger.getInstance(V25_26UpgradeExecutor.class);

    private String getFilterKey(long firstLevelId, long secondLevelId) {
        return "DEVICE42_SETTINGS_PROJECT_" + firstLevelId + DEVICE42_CUSTOMFIELD_PREFIX + secondLevelId;
    }

    public V25_26UpgradeExecutor(D42PluginUpgradeTask upgradeTask) {
        super(upgradeTask);
    }

    protected abstract List<Long> getFirstLevelIds();

    protected abstract List<Long> getSecondLevelIds(long var1);

    private D42FilterInfo getFilterInfo(long firstLevelId, long secondLevelId) {
        PluginSettings filterSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(this.getFilterKey(firstLevelId, secondLevelId));
        PluginSettingsDonor pluginSettingsDonor = new PluginSettingsDonor(filterSettings);
        return new D42FilterInfo(pluginSettingsDonor);
    }

    private void deleteFilterInfo(long firstLevelId, long secondLevelId) {
        PluginSettings filterSettings = this.upgradeTask.getPluginSettingsFactory().createSettingsForKey(this.getFilterKey(firstLevelId, secondLevelId));
        PluginSettingsAcceptor pluginSettingsAcceptor = new PluginSettingsAcceptor(filterSettings, new String[0]);
        D42FilterInfo filterInfo = new D42FilterInfo(null);
        filterInfo.clear(pluginSettingsAcceptor);
    }

    private void updateParameterFilter(ConfigurationItemType ciType, ConfigurationItemFilter ciFilter, String parameterKey, String filterValue) {
        ParameterFilter parameterFilter;
        ParameterType parameterType = ciType.getParameterTypeByKey(parameterKey);
        if (parameterType != null && (parameterFilter = ciFilter.getParameterFilter(parameterType)) != null) {
            parameterFilter.setFilterValue(filterValue);
        }
    }

    private ConfigurationItemFilter updateConfigurationItemFilter(Schema schema, String ciTypeKey, Filter filter, boolean switchedOn) {
        ConfigurationItemType type = schema.getByKey(ciTypeKey);
        if (type != null) {
            ConfigurationItemFilter ciFilter = filter.getConfigurationItemFilter(type);
            if (ciFilter != null) {
                ciFilter.setSwitchedOn(switchedOn);
            }
            return ciFilter;
        }
        return null;
    }

    private void updateFilters() {
        log.info((Object)"Starting filters upgrade");
        D42DataManager dataManager = this.upgradeTask.getDataManager();
        Schema schema = dataManager.getCollectableSchema();
        for (long firstLevelId : this.getFirstLevelIds()) {
            for (long secondLevelId : this.getSecondLevelIds(firstLevelId)) {
                D42FilterInfo filterInfo = this.getFilterInfo(firstLevelId, secondLevelId);
                D42DataManager dataManger = this.upgradeTask.getDataManager();
                if (filterInfo.isPrimitive()) continue;
                try {
                    ConfigurationItemFilter partFilter;
                    ConfigurationItemFilter pduFilter;
                    ConfigurationItemFilter rackFilter;
                    ConfigurationItemFilter deviceFilter;
                    Filter savedFilter = dataManger.getFilter(firstLevelId, secondLevelId);
                    if (!savedFilter.isPrimitive()) continue;
                    boolean allSet = true;
                    for (ConfigurationItemFilter configurationItemFilter : savedFilter) {
                        if (configurationItemFilter.isSwitchedOn()) continue;
                        allSet = false;
                        break;
                    }
                    if (!allSet) continue;
                    Filter filter = Filter.createDefaultFilter(dataManger);
                    filter.setFirstLevelId(firstLevelId);
                    filter.setSecondLevelId(secondLevelId);
                    String allTags = "";
                    if (filterInfo.deviceTagsAnd != null) {
                        allTags = filterInfo.deviceTagsAnd;
                    }
                    if (!StringUtils.isBlank((String)filterInfo.deviceTags)) {
                        if (!StringUtils.isBlank((String)allTags)) {
                            allTags = allTags + "|";
                        }
                        allTags = allTags + filterInfo.deviceTags.replace(",", "|");
                    }
                    if ((deviceFilter = this.updateConfigurationItemFilter(schema, DEVICE42_FILTER_DEVICE_KEY, filter, filterInfo.devicesEnabled)) != null) {
                        this.updateParameterFilter(deviceFilter.getType(), deviceFilter, DEVICE42_FILTER_DEVICE_CUSTOMER_KEY, filterInfo.deviceCustomer);
                        this.updateParameterFilter(deviceFilter.getType(), deviceFilter, DEVICE42_FILTER_DEVICE_TYPE_KEY, filterInfo.deviceType);
                        this.updateParameterFilter(deviceFilter.getType(), deviceFilter, DEVICE42_FILTER_DEVICE_SERVICE_LEVEL_KEY, filterInfo.deviceServiceLevel);
                        this.updateParameterFilter(deviceFilter.getType(), deviceFilter, DEVICE42_FILTER_DEVICE_TAGS_KEY, allTags);
                    }
                    if ((rackFilter = this.updateConfigurationItemFilter(schema, DEVICE42_FILTER_RACK_KEY, filter, filterInfo.racksEnabled)) != null) {
                        this.updateParameterFilter(rackFilter.getType(), rackFilter, DEVICE42_FILTER_RACK_BUILDING_KEY, filterInfo.rackBuilding);
                        this.updateParameterFilter(rackFilter.getType(), rackFilter, DEVICE42_FILTER_RACK_ROOM_KEY, filterInfo.rackRoom);
                    }
                    if ((pduFilter = this.updateConfigurationItemFilter(schema, DEVICE42_FILTER_PDU_KEY, filter, filterInfo.pdusEnabled)) != null) {
                        this.updateParameterFilter(pduFilter.getType(), pduFilter, DEVICE42_FILTER_PDU_NAME_KEY, filterInfo.pduModelName);
                    }
                    if ((partFilter = this.updateConfigurationItemFilter(schema, DEVICE42_FILTER_PART_KEY, filter, filterInfo.partsEnabled)) != null) {
                        this.updateParameterFilter(partFilter.getType(), partFilter, DEVICE42_FILTER_PART_MODEL_KEY, filterInfo.partModelType);
                    }
                    try {
                        this.upgradeTask.getDataManager().setFilter(filter, 1000);
                        this.deleteFilterInfo(firstLevelId, secondLevelId);
                    }
                    catch (D42Exception e) {
                        log.error((Object)("Could not set filter with firstLevelId " + firstLevelId + " and secondLevelId " + secondLevelId + " during upgrade"), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed to upgrade filter.");
                }
            }
        }
        log.info((Object)"Filters upgrade finished successfully");
    }

    private void updateData() {
    }

    @Override
    public void execute() {
        log.info((Object)"Starting upgrade from 2.5 to 2.6");
        this.updateFilters();
        this.updateData();
        log.info((Object)"Upgraded to 2.6");
    }

    private static class D42FilterInfo
    implements Parameterizable {
        public static final String DEVICE42_DEVICE_TYPE = "deviceType";
        public static final String DEVICE42_DEVICE_SERVICE_LEVEL = "deviceServiceLevel";
        public static final String DEVICE42_DEVICE_CUSTOMER = "deviceCustomer";
        public static final String DEVICE42_DEVICE_TAGS = "deviceTags";
        public static final String DEVICE42_DEVICE_TAGS_AND = "deviceTagsAnd";
        public static final String DEVICE42_RACK_ROOM = "rackRoom";
        public static final String DEVICE42_RACK_BUILDING = "rackBuilding";
        public static final String DEVICE42_RACK_TAGS = "rackTags";
        public static final String DEVICE42_RACK_TAGS_AND = "rackTagsAnd";
        public static final String DEVICE42_PDU_MODEL_NAME = "pduModelName";
        public static final String DEVICE42_PDU_TAGS = "pduTags";
        public static final String DEVICE42_PDU_TAGS_AND = "pduTagsAnd";
        public static final String DEVICE42_PART_MODEL_TYPE = "partModelType";
        public static final String DEVICE42_PART_TAGS = "partTags";
        public static final String DEVICE42_PART_TAGS_AND = "partTagsAnd";
        public static final String DEVICE42_DEVICES_ENABLED = "devicesEnabled";
        public static final String DEVICE42_RACKS_ENABLED = "racksEnabled";
        public static final String DEVICE42_PDUS_ENABLED = "pdusEnabled";
        public static final String DEVICE42_PARTS_ENABLED = "partsEnabled";
        private String deviceType;
        private String deviceServiceLevel;
        private String deviceCustomer;
        private String deviceTags;
        private String deviceTagsAnd;
        private String rackRoom;
        private String rackBuilding;
        private String pduModelName;
        private String partModelType;
        private boolean devicesEnabled;
        private boolean racksEnabled;
        private boolean partsEnabled;
        private boolean pdusEnabled;

        public D42FilterInfo(ParameterDonor parameters) {
            if (parameters != null) {
                this.loadFromDonor(parameters);
            }
        }

        @Override
        public void saveToAcceptor(@Nonnull ParameterAcceptor output) {
        }

        @Override
        public void loadFromDonor(ParameterDonor input) {
            this.deviceType = ObjectUtils.stringValue(input.get(DEVICE42_DEVICE_TYPE));
            this.deviceServiceLevel = ObjectUtils.stringValue(input.get(DEVICE42_DEVICE_SERVICE_LEVEL));
            this.deviceCustomer = ObjectUtils.stringValue(input.get(DEVICE42_DEVICE_CUSTOMER));
            this.deviceTags = ObjectUtils.stringValue(input.get(DEVICE42_DEVICE_TAGS));
            this.deviceTagsAnd = ObjectUtils.stringValue(input.get(DEVICE42_DEVICE_TAGS_AND));
            this.rackRoom = ObjectUtils.stringValue(input.get(DEVICE42_RACK_ROOM));
            this.rackBuilding = ObjectUtils.stringValue(input.get(DEVICE42_RACK_BUILDING));
            this.pduModelName = ObjectUtils.stringValue(input.get(DEVICE42_PDU_MODEL_NAME));
            this.partModelType = ObjectUtils.stringValue(input.get(DEVICE42_PART_MODEL_TYPE));
            this.devicesEnabled = ObjectUtils.booleanValue(input.get(DEVICE42_DEVICES_ENABLED), true);
            this.racksEnabled = ObjectUtils.booleanValue(input.get(DEVICE42_RACKS_ENABLED), true);
            this.pdusEnabled = ObjectUtils.booleanValue(input.get(DEVICE42_PDUS_ENABLED), true);
            this.partsEnabled = ObjectUtils.booleanValue(input.get(DEVICE42_PARTS_ENABLED), true);
        }

        @Override
        public void clear(ParameterAcceptor output) {
            output.removeParameter(DEVICE42_DEVICE_TYPE);
            output.removeParameter(DEVICE42_DEVICE_SERVICE_LEVEL);
            output.removeParameter(DEVICE42_DEVICE_CUSTOMER);
            output.removeParameter(DEVICE42_DEVICE_TAGS);
            output.removeParameter(DEVICE42_DEVICE_TAGS_AND);
            output.removeParameter(DEVICE42_RACK_ROOM);
            output.removeParameter(DEVICE42_RACK_BUILDING);
            output.removeParameter(DEVICE42_RACK_TAGS);
            output.removeParameter(DEVICE42_RACK_TAGS_AND);
            output.removeParameter(DEVICE42_PDU_MODEL_NAME);
            output.removeParameter(DEVICE42_PDU_TAGS);
            output.removeParameter(DEVICE42_PDU_TAGS_AND);
            output.removeParameter(DEVICE42_PART_MODEL_TYPE);
            output.removeParameter(DEVICE42_PART_TAGS);
            output.removeParameter(DEVICE42_PART_TAGS_AND);
            output.removeParameter(DEVICE42_DEVICES_ENABLED);
            output.removeParameter(DEVICE42_RACKS_ENABLED);
            output.removeParameter(DEVICE42_PDUS_ENABLED);
            output.removeParameter(DEVICE42_PARTS_ENABLED);
        }

        public boolean isPrimitive() {
            return this.devicesEnabled && this.racksEnabled && this.pdusEnabled && this.partsEnabled && StringUtils.isBlank((String)this.deviceType) && StringUtils.isBlank((String)this.deviceServiceLevel) && StringUtils.isBlank((String)this.deviceCustomer) && StringUtils.isBlank((String)this.deviceTags) && StringUtils.isBlank((String)this.rackRoom) && StringUtils.isBlank((String)this.rackBuilding) && StringUtils.isBlank((String)this.pduModelName) && StringUtils.isBlank((String)this.partModelType);
        }
    }
}

