/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job.upgrade.manual;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.device42.atlas.common.job.upgrade.manual.ManualUpgradeTask;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.model.ao.D42SupportAO;
import com.device42.atlas.common.model.core.schema.ConfigurationItemDisplayName;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.ParameterType;
import com.device42.atlas.common.model.core.schema.ReferenceParameterType;
import com.device42.atlas.common.model.core.schema.SimpleParameterType;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.common.util.D42Version;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;

public class ServiceRewriteManualUpgrade
extends ManualUpgradeTask {
    public static final String KEY = "service_rewrite_manual_upgrade";
    private final ActiveObjects ao;
    private final D42DataManager dataManager;

    public ServiceRewriteManualUpgrade(ActiveObjects ao, D42DataManager dataManager) {
        this.ao = ao;
        this.dataManager = dataManager;
    }

    private void updateSupportedVersion() throws D42Exception {
        try {
            D42SupportAO[] d42SupportAOs = (D42SupportAO[])this.ao.find(D42SupportAO.class);
            D42SupportAO d42SupportAO = d42SupportAOs.length == 0 ? (D42SupportAO)this.ao.create(D42SupportAO.class, new DBParam[0]) : d42SupportAOs[0];
            d42SupportAO.setCurrentSupportedVersion(D42Version.SERVICE_REWRITE_VERSION.getLong());
            d42SupportAO.save();
            d42SupportAO.save();
        }
        catch (Exception e) {
            throw new D42Exception("Failed to update the current supported version", e);
        }
    }

    @Override
    public void doUpgrade() throws D42Exception {
        ParameterType svcVendorPkParameterType;
        ParameterType stateParameterType;
        ParameterType startmodeParameterType;
        ParameterType devicePkParameterType;
        ConfigurationItemType svc = this.dataManager.getConfigurationItemTypeByKey("SVC");
        ConfigurationItemType svcd = this.dataManager.getConfigurationItemTypeByKey("SVCD");
        ConfigurationItemType.DOQLQuery svcQuery = new ConfigurationItemType.DOQLQuery("SELECT view_service_v2.service_pk, view_service_v2.pretty_name, view_service_v2.last_changed, view_service_v2.servicecategory_name, view_service_v2.description, view_service_v2.notes, view_vendor_v1.vendor_pk, view_vendor_v1.name FROM view_service_v2 LEFT JOIN view_vendor_v1 ON view_vendor_v1.vendor_pk = view_service_v2.vendor_fk ORDER BY view_service_v2.service_pk");
        ConfigurationItemType.DOQLQuery svcdQuery = new ConfigurationItemType.DOQLQuery("SELECT view_serviceinstance_v2.serviceinstance_pk, view_service_v2.service_pk, view_service_v2.pretty_name, view_serviceinstance_v2.last_changed, view_device_v1.device_pk, view_device_v1.name, view_serviceinstance_v2.startmode, view_serviceinstance_v2.state, view_vendor_v1.vendor_pk, view_vendor_v1.name FROM view_serviceinstance_v2 LEFT JOIN view_service_v2 ON view_service_v2.service_pk = view_serviceinstance_v2.service_fk LEFT JOIN view_vendor_v1 ON view_vendor_v1.vendor_pk = view_service_v2.vendor_fk LEFT JOIN view_device_v1 ON view_device_v1.device_pk = view_serviceinstance_v2.device_fk ORDER BY view_serviceinstance_v2.serviceinstance_pk");
        svc.setQuery(svcQuery);
        svcd.setQuery(svcdQuery);
        ParameterType vendorPkParameterType = svcd.getParameterTypeByKey("view_vendor_v1_vendor_pk");
        if (vendorPkParameterType instanceof ReferenceParameterType) {
            ((ReferenceParameterType)vendorPkParameterType).setIdIndex(8);
        }
        if ((devicePkParameterType = svcd.getParameterTypeByKey("view_device_v1_device_pk")) instanceof ReferenceParameterType) {
            ((ReferenceParameterType)devicePkParameterType).setIdIndex(4);
        }
        if ((startmodeParameterType = svcd.getParameterTypeByKey("view_serviceinstance_v1_startmode")) instanceof SimpleParameterType) {
            ((SimpleParameterType)startmodeParameterType).setCollectionIndex(6);
        }
        if ((stateParameterType = svcd.getParameterTypeByKey("view_serviceinstance_v1_state")) instanceof SimpleParameterType) {
            ((SimpleParameterType)stateParameterType).setCollectionIndex(7);
        }
        if ((svcVendorPkParameterType = svc.getParameterTypeByKey("view_vendor_v1_vendor_pk")) instanceof ReferenceParameterType) {
            ((ReferenceParameterType)svcVendorPkParameterType).setIdIndex(6);
        }
        this.updatePropertiesName(svc, svcd);
        this.dataManager.saveConfigurationItemType(svc);
        this.dataManager.saveConfigurationItemType(svcd);
        this.updateSupportedVersion();
    }

    private void updatePropertiesName(ConfigurationItemType svc, ConfigurationItemType svcd) throws D42Exception {
        svc.setDisplayName(new ConfigurationItemDisplayName("%view_service_v2_name%"));
        svcd.setDisplayName(new ConfigurationItemDisplayName("%view_device_v1_device_pk% %view_service_v2_service_pk%"));
        this.changeParameterTypeKey(svc, "view_service_v1_name", "view_service_v2_name");
        this.changeParameterTypeKey(svc, "view_service_v1_last_changed", "view_service_v2_last_changed");
        this.changeParameterTypeKey(svc, "view_service_v1_category", "view_service_v2_category");
        this.changeParameterTypeKey(svc, "view_service_v1_notes", "view_service_v2_notes");
        this.changeParameterTypeKey(svc, "view_service_v1_description", "view_service_v2_description");
        this.changeParameterTypeKey(svc, "view_service_v1_tags", null);
        this.changeParameterTypeKey(svc, "view_service_v1_service_type", null);
        this.changeParameterTypeKey(svcd, "view_service_v1_service_pk", "view_service_v2_service_pk");
        this.changeParameterTypeKey(svcd, "view_serviceinstance_v1_last_changed", "view_serviceinstance_v2_last_changed");
        this.changeParameterTypeKey(svcd, "view_serviceinstance_v1_startmode", "view_serviceinstance_v2_startmode");
        this.changeParameterTypeKey(svcd, "view_serviceinstance_v1_state", "view_serviceinstance_v2_state");
        this.changeParameterTypeKey(svcd, "view_appcomp_v1_appcomp_pk", null);
    }

    private void changeParameterTypeKey(ConfigurationItemType itemType, String oldKey, String newKey) throws D42Exception {
        if (itemType.getParameterTypeByKey(newKey) != null && itemType.getParameterTypeByKey(newKey).getKey().equalsIgnoreCase(newKey)) {
            return;
        }
        if (newKey != null) {
            itemType.getParameterTypeByKey(oldKey).setKey(newKey);
        }
        List<ParameterType> parameterTypes = itemType.getParameterTypes();
        this.removeParameterTypeByKey(parameterTypes, oldKey);
        itemType.setParameterTypes(new ArrayList<ParameterType>(parameterTypes));
        this.dataManager.removeParameterType(itemType.getKey(), oldKey);
    }

    private void removeParameterTypeByKey(List<ParameterType> svcParameterTypes, String key) {
        ParameterType typeToRemove = null;
        for (ParameterType svcParameterType : svcParameterTypes) {
            if (!key.equals(svcParameterType.getKey())) continue;
            typeToRemove = svcParameterType;
            break;
        }
        if (typeToRemove != null) {
            svcParameterTypes.remove(typeToRemove);
        }
    }
}

