/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.common.job;

import com.device42.atlas.common.job.ConfigurationItemCollectionStatistics;
import com.device42.atlas.common.job.JobStatus;
import com.device42.atlas.common.model.core.schema.ConfigurationItemType;
import com.device42.atlas.common.model.core.schema.Schema;
import com.device42.atlas.common.model.serialization.ParameterAcceptor;
import com.device42.atlas.common.model.serialization.ParameterDonor;
import com.device42.atlas.common.model.serialization.Parameterizable;
import com.device42.atlas.common.util.ObjectUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class JobStatistics
implements Parameterizable {
    int JOB_LIVE_TIMEOUT_MS = 60000;
    public static String JOB_SESSION_ID_KEY = "jobSessionId";
    public static String JOB_UPDATED_KEY = "jobUpdated";
    public static String JOB_STATUS = "jobStatus";
    public static String JOB_STARTED_KEY = "jobStarted";
    public static String JOB_FINISHED_KEY = "jobFinished";
    public static String TOTAL_TICKS_KEY = "totalTicks";
    public static String CURRENT_TICKS_KEY = "currentTicks";
    public static String CURRENT_STATE_MESSAGE_KEY = "currentStateMessage";
    public static String JOB_STATUS_TERMINAL = "terminal";
    public static String JOB_STATUS_ABANDONED = "abandoned";
    public static String JOB_STATUS_ABORTING = "aborting";
    private String jobSessionId;
    private Date jobUpdated;
    private Date jobStarted;
    private Date jobFinished;
    private JobStatus jobStatus;
    private boolean basic;
    private Map<String, ConfigurationItemCollectionStatistics> ciCollectionStatistics;
    private Schema schema;
    private boolean estimateCalculated = false;
    private int totalTicks;
    private int currentTicks;
    private String currentStateMessage;

    public JobStatistics(Schema schema) {
        this.basic = schema == null;
        this.schema = schema;
    }

    @Override
    public void saveToAcceptor(ParameterAcceptor output) {
        output.addParameter(JOB_SESSION_ID_KEY, this.jobSessionId);
        output.addParameter(JOB_UPDATED_KEY, ObjectUtils.formatDate(this.jobUpdated));
        output.addParameter(JOB_STATUS, (Object)this.jobStatus);
        output.addParameter(JOB_STARTED_KEY, ObjectUtils.formatDate(this.jobStarted));
        output.addParameter(JOB_FINISHED_KEY, ObjectUtils.formatDate(this.jobFinished));
        output.addParameter(JOB_STATUS_TERMINAL, this.isTerminal());
        output.addParameter(JOB_STATUS_ABANDONED, this.isAbandoned());
        output.addParameter(JOB_STATUS_ABORTING, this.isAborting());
        if (!this.basic && this.ciCollectionStatistics != null) {
            output.addParameter(TOTAL_TICKS_KEY, this.getTotalTicks());
            output.addParameter(CURRENT_TICKS_KEY, this.getCurrentTicks());
            output.addParameter(CURRENT_STATE_MESSAGE_KEY, this.getCurrentStateMessage());
            for (ConfigurationItemCollectionStatistics ciStatistics : this.ciCollectionStatistics.values()) {
                ciStatistics.saveToAcceptor(output);
            }
        }
    }

    @Override
    public void loadFromDonor(ParameterDonor input) {
        this.jobSessionId = ObjectUtils.stringValue(input.get(JOB_SESSION_ID_KEY));
        this.jobStatus = ObjectUtils.enumValue(input.get(JOB_STATUS), JobStatus.class, null);
        this.jobStarted = ObjectUtils.dateValue(input.get(JOB_STARTED_KEY));
        this.jobFinished = ObjectUtils.dateValue(input.get(JOB_FINISHED_KEY));
        this.jobUpdated = ObjectUtils.dateValue(input.get(JOB_UPDATED_KEY));
        if (!this.basic && this.schema != null) {
            this.ciCollectionStatistics = new LinkedHashMap<String, ConfigurationItemCollectionStatistics>();
            for (ConfigurationItemType type : this.schema) {
                ConfigurationItemCollectionStatistics ciStatistics = new ConfigurationItemCollectionStatistics(type, input);
                this.ciCollectionStatistics.put(type.getKey(), ciStatistics);
            }
        }
    }

    @Override
    public void clear(ParameterAcceptor output) {
        output.removeParameter(JOB_SESSION_ID_KEY);
        output.removeParameter(JOB_UPDATED_KEY);
        output.removeParameter(JOB_STATUS);
        output.removeParameter(JOB_STARTED_KEY);
        output.removeParameter(JOB_FINISHED_KEY);
        if (!this.basic && this.ciCollectionStatistics != null) {
            for (ConfigurationItemCollectionStatistics ciStatistics : this.ciCollectionStatistics.values()) {
                ciStatistics.clear(output);
            }
        }
    }

    public void fillDefaultCIStatistics() {
        this.ciCollectionStatistics = new LinkedHashMap<String, ConfigurationItemCollectionStatistics>();
        if (this.schema != null) {
            for (ConfigurationItemType type : this.schema) {
                ConfigurationItemCollectionStatistics ciStatistics = new ConfigurationItemCollectionStatistics(type, 0L, 0L, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus.NOT_STARTED);
                this.ciCollectionStatistics.put(type.getKey(), ciStatistics);
            }
        }
    }

    public Date getJobStarted() {
        return this.jobStarted;
    }

    public void setJobStarted(Date jobStarted) {
        this.jobStarted = jobStarted;
    }

    public Date getJobFinished() {
        return this.jobFinished;
    }

    public void setJobFinished(Date jobFinished) {
        this.jobFinished = jobFinished;
    }

    public String getJobSessionId() {
        return this.jobSessionId;
    }

    public void setJobSessionId(String jobSessionId) {
        this.jobSessionId = jobSessionId;
    }

    public Date getJobUpdated() {
        return this.jobUpdated;
    }

    public void setJobUpdated(Date jobUpdated) {
        this.jobUpdated = jobUpdated;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public ConfigurationItemCollectionStatistics getConfigurationItemCollectionStatistics(ConfigurationItemType type) {
        if (this.ciCollectionStatistics != null) {
            return this.ciCollectionStatistics.get(type.getKey());
        }
        return null;
    }

    public void setConfigurationItemCollectionStatistics(ConfigurationItemType type, long collected, long total, ConfigurationItemCollectionStatistics.ConfigurationItemCollectionStatus collectionStatus) {
        if (this.ciCollectionStatistics == null) {
            this.ciCollectionStatistics = new LinkedHashMap<String, ConfigurationItemCollectionStatistics>();
        }
        this.basic = false;
        ConfigurationItemCollectionStatistics ciStatistics = new ConfigurationItemCollectionStatistics(type, collected, total, collectionStatus);
        this.ciCollectionStatistics.put(type.getKey(), ciStatistics);
    }

    public boolean isTerminal() {
        if (this.jobStatus == null) {
            return true;
        }
        switch (this.jobStatus) {
            case COMPLETED: 
            case INCREMENTAL_COMPLETED: 
            case ABORTED: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    public boolean isAbandoned() {
        Calendar lastUpdateChecker = Calendar.getInstance();
        lastUpdateChecker.add(14, -this.JOB_LIVE_TIMEOUT_MS);
        return this.jobUpdated == null || lastUpdateChecker.getTime().after(this.jobUpdated);
    }

    public boolean isAborting() {
        if (this.jobStatus == null) {
            return false;
        }
        switch (this.jobStatus) {
            case CANCELLED: 
            case ROLLBACK: {
                return true;
            }
        }
        return false;
    }

    void calculateStatistics() {
        if (!this.estimateCalculated) {
            int baseTotalTicks = 3;
            if (this.ciCollectionStatistics != null) {
                baseTotalTicks += this.ciCollectionStatistics.values().size();
            }
            this.totalTicks = baseTotalTicks * 100;
            if (this.jobStatus != null) {
                switch (this.jobStatus) {
                    case COMPLETED: 
                    case INCREMENTAL_COMPLETED: 
                    case ABORTED: 
                    case FAILED: {
                        this.currentTicks = this.totalTicks;
                        break;
                    }
                    case STARTED: {
                        this.currentTicks = 0;
                    }
                    case SCANNING: {
                        this.currentTicks = 100;
                    }
                    case CANCELLED: 
                    case ROLLBACK: 
                    case POST_PROCESSING: {
                        this.currentTicks = 200;
                        if (this.ciCollectionStatistics == null) break;
                        for (ConfigurationItemCollectionStatistics ciStatistics : this.ciCollectionStatistics.values()) {
                            this.currentTicks = (int)((long)this.currentTicks + (ciStatistics.total == 0L ? 0L : 100L * ciStatistics.collected / ciStatistics.total));
                        }
                        break;
                    }
                }
            }
        }
    }

    public int getTotalTicks() {
        this.calculateStatistics();
        return this.totalTicks;
    }

    public int getCurrentTicks() {
        this.calculateStatistics();
        return this.currentTicks;
    }

    public String getCurrentStateMessage() {
        this.calculateStatistics();
        return this.currentStateMessage;
    }
}

