/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.model.D42ConnectionInfo;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.confluence.macro.input.AbstractInput;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class D42Macro<T extends AbstractInput>
implements Macro {
    protected static final String D42_ACCORDION_SWITCH_PROPERTY_KEY = "com.device42.atlas.customfield.accordion.switch";
    protected static final String D42_CF_TEXT_SIZE_PROPERTY_KEY = "com.device42.atlas.customfield.text.size";
    private static final Logger log = LoggerFactory.getLogger(D42Macro.class);
    private static final String COMMON_ERROR_TEMPLATE = "/com/device42/atlas/confluence/templates/macro/common-error.vm";
    private static final String SETTINGS_ERROR_TEMPLATE = "/com/device42/atlas/confluence/templates/macro/settings-error.vm";
    protected final D42SettingsManager d42SettingsManager;
    protected final D42DataManager d42DataManager;
    private final SpaceManager spaceManager;
    protected final I18nResolver i18n;
    private final PluginSettingsFactory pluginSettingsFactory;

    public D42Macro(D42SettingsManager d42SettingsManager, D42DataManager d42DataManager, SpaceManager spaceManager, I18nResolver i18n, PluginSettingsFactory pluginSettingsFactory) {
        this.d42SettingsManager = d42SettingsManager;
        this.d42DataManager = d42DataManager;
        this.spaceManager = spaceManager;
        this.i18n = i18n;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        Space space;
        D42ConnectionInfo d42ConnectionInfo = this.d42SettingsManager.getConnectionInfo();
        Map velocityContext = MacroUtils.defaultVelocityContext();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        if (d42ConnectionInfo == null || !d42ConnectionInfo.isConfigured()) {
            return VelocityUtils.getRenderedTemplate((String)SETTINGS_ERROR_TEMPLATE, (Map)velocityContext);
        }
        String allowed = (String)pluginSettings.get("d42_restrict_spaces");
        String enable = (String)pluginSettings.get("d42_restrict_spaces_enable");
        if (enable != null && enable.equals("on")) {
            if (allowed == null || allowed.trim().isEmpty()) {
                return this.renderAccessDeniedError(velocityContext);
            }
            String currentSpaceKey = conversionContext.getSpaceKey();
            if (currentSpaceKey == null || !Arrays.asList(allowed.split(",")).contains(currentSpaceKey)) {
                return this.renderAccessDeniedError(velocityContext);
            }
        }
        String spaceKey = conversionContext.getSpaceKey();
        long firstLevelId = 0L;
        if (spaceKey != null && (space = this.spaceManager.getSpace(spaceKey)) != null) {
            firstLevelId = space.getId();
        }
        try {
            this.renderBody(this.parseParameters(parameters, firstLevelId), velocityContext);
            return VelocityUtils.getRenderedTemplate((String)this.getTemplatePath(), (Map)velocityContext);
        }
        catch (Exception ex) {
            log.error("Error to render Device42 macro", (Throwable)ex);
            velocityContext.put("error", ex.getMessage());
            return VelocityUtils.getRenderedTemplate((String)COMMON_ERROR_TEMPLATE, (Map)velocityContext);
        }
    }

    protected abstract String getTemplatePath();

    protected abstract T parseParameters(Map<String, String> var1, long var2);

    protected abstract void renderBody(T var1, Map<String, Object> var2) throws D42Exception;

    private String renderAccessDeniedError(Map<String, Object> velocityContext) {
        velocityContext.put("error", "Access denied! You don't have access to this space. Please, ask your system administrator.");
        return VelocityUtils.getRenderedTemplate((String)COMMON_ERROR_TEMPLATE, velocityContext);
    }
}

