/*
 * Decompiled with CFR 0.152.
 */
package com.device42.atlas.confluence.macro;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.device42.atlas.common.manager.D42DataManager;
import com.device42.atlas.common.manager.D42SettingsManager;
import com.device42.atlas.common.util.D42Exception;
import com.device42.atlas.confluence.macro.D42Macro;
import com.device42.atlas.confluence.macro.input.ObjectInput;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class D42DetailMacro
extends D42Macro<ObjectInput> {
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final String DEFAULT_OBJECT = "Device";

    public D42DetailMacro(D42SettingsManager d42SettingsManager, D42DataManager d42DataManager, SpaceManager spaceManager, I18nResolver i18n, PluginSettingsFactory pluginSettingsFactory) {
        super(d42SettingsManager, d42DataManager, spaceManager, i18n, pluginSettingsFactory);
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    @Override
    protected String getTemplatePath() {
        return "/com/device42/atlas/confluence/templates/macro/details.vm";
    }

    @Override
    protected ObjectInput parseParameters(Map<String, String> parameters, long firstLevelId) {
        String objectType = parameters.get("objectType");
        String objectId = parameters.get("objectId");
        String objectName = parameters.get("objectName");
        String d42Value = parameters.get("d42Value");
        if (StringUtils.isNotBlank((CharSequence)d42Value)) {
            return new ObjectInput(d42Value, firstLevelId);
        }
        return new ObjectInput(StringUtils.isBlank((CharSequence)objectType) ? DEFAULT_OBJECT : objectType, objectId, objectName, firstLevelId);
    }

    @Override
    protected void renderBody(ObjectInput input, Map<String, Object> velocityContext) throws D42Exception {
        velocityContext.put("helper", input.getHelper(input.getFirstLevelId(), input.getSecondLevelId(), this.d42DataManager, this.d42SettingsManager, this.i18n));
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String enableAccordion = (String)pluginSettings.get("com.device42.atlas.customfield.accordion.switch");
        String textSize = (String)pluginSettings.get("com.device42.atlas.customfield.text.size");
        velocityContext.put("enableAccordion", enableAccordion);
        velocityContext.put("textSize", textSize);
    }
}

